/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension;

import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.extension.IManifestControllerService;
import com.adobe.csi.internal.extension.ExtensionUtilties;
import java.util.Properties;
import org.osgi.framework.BundleException;
import org.osgi.service.component.ComponentContext;

public class InternalStartUpChecker {
    static final Logger LOGGER = Logger.getLogger(InternalStartUpChecker.class);
    private static final String MANIFEST_CONTROLLER_SERVICE = "MANIFEST_CONTROLLER_SERVICE";
    ComponentContext context;

    protected void activate(ComponentContext context) throws Exception {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating: " + InternalStartUpChecker.class));
        }
        this.context = context;
        Properties properties = ExtensionUtilties.getAgentProperties();
        this.clearExtensions(properties);
        this.shutdown(properties);
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating: " + InternalStartUpChecker.class));
        }
        this.context = null;
    }

    private void clearExtensions(Properties properties) {
        String clearExtensions;
        if (System.getProperties().containsKey("launchedbylogin") && Boolean.parseBoolean(clearExtensions = properties.getProperty("clearExtensions"))) {
            IManifestControllerService manifestControllerService = (IManifestControllerService)this.context.locateService(MANIFEST_CONTROLLER_SERVICE);
            manifestControllerService.deleteSuperfluousVersions();
        }
    }

    private void shutdown(Properties properties) {
        boolean launchedByLogin = System.getProperties().containsKey("launchedbylogin");
        String shouldautomount = properties.getProperty("shouldautomount");
        if (launchedByLogin && !Boolean.parseBoolean(shouldautomount)) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        InternalStartUpChecker.this.context.getBundleContext().getBundles()[0].stop();
                        System.exit(0);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }
}

