/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension;

import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.core.model.ExtensionBundle;
import com.adobe.csi.core.model.UserManifest;
import com.adobe.csi.internal.extension.UserManifestParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.SAXParserFactory;
import sun.security.validator.Validator;
import sun.security.x509.X509Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUtilties {
    private static String EXTENSION_DIRECTORY;
    private static final Logger LOGGER;
    private static final byte[] PK_BYTES_THAWTE;
    private static final byte[] PK_BYTES_VERISIGN;
    private static final byte[] PK_BYTES_VERISIGN_2;
    private static X509Key pkThawte;
    private static X509Key pkVerisign;
    private static X509Key pkVerisign2;
    private static final Set<CertPath> trustedCertPaths;
    private static String USER_EXTENSION_DIRECTORY;

    static {
        LOGGER = Logger.getLogger(ExtensionUtilties.class);
        byte[] byArray = new byte[162];
        byArray[0] = 48;
        byArray[1] = -127;
        byArray[2] = -97;
        byArray[3] = 48;
        byArray[4] = 13;
        byArray[5] = 6;
        byArray[6] = 9;
        byArray[7] = 42;
        byArray[8] = -122;
        byArray[9] = 72;
        byArray[10] = -122;
        byArray[11] = -9;
        byArray[12] = 13;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[16] = 5;
        byArray[18] = 3;
        byArray[19] = -127;
        byArray[20] = -115;
        byArray[22] = 48;
        byArray[23] = -127;
        byArray[24] = -119;
        byArray[25] = 2;
        byArray[26] = -127;
        byArray[27] = -127;
        byArray[29] = -46;
        byArray[30] = 54;
        byArray[31] = 54;
        byArray[32] = 106;
        byArray[33] = -117;
        byArray[34] = -41;
        byArray[35] = -62;
        byArray[36] = 91;
        byArray[37] = -98;
        byArray[38] = -38;
        byArray[39] = -127;
        byArray[40] = 65;
        byArray[41] = 98;
        byArray[42] = -113;
        byArray[43] = 56;
        byArray[44] = -18;
        byArray[45] = 73;
        byArray[46] = 4;
        byArray[47] = 85;
        byArray[48] = -42;
        byArray[49] = -48;
        byArray[50] = -17;
        byArray[51] = 28;
        byArray[52] = 27;
        byArray[53] = -107;
        byArray[54] = 22;
        byArray[55] = 71;
        byArray[56] = -17;
        byArray[57] = 24;
        byArray[58] = 72;
        byArray[59] = 53;
        byArray[60] = 58;
        byArray[61] = 82;
        byArray[62] = -12;
        byArray[63] = 43;
        byArray[64] = 106;
        byArray[65] = 6;
        byArray[66] = -113;
        byArray[67] = 59;
        byArray[68] = 47;
        byArray[69] = -22;
        byArray[70] = 86;
        byArray[71] = -29;
        byArray[72] = -81;
        byArray[73] = -122;
        byArray[74] = -115;
        byArray[75] = -98;
        byArray[76] = 23;
        byArray[77] = -9;
        byArray[78] = -98;
        byArray[79] = -76;
        byArray[80] = 101;
        byArray[81] = 117;
        byArray[82] = 2;
        byArray[83] = 77;
        byArray[84] = -17;
        byArray[85] = -53;
        byArray[86] = 9;
        byArray[87] = -94;
        byArray[88] = 33;
        byArray[89] = 81;
        byArray[90] = -40;
        byArray[91] = -101;
        byArray[92] = -48;
        byArray[93] = 103;
        byArray[94] = -48;
        byArray[95] = -70;
        byArray[96] = 13;
        byArray[97] = -110;
        byArray[98] = 6;
        byArray[99] = 20;
        byArray[100] = 115;
        byArray[101] = -44;
        byArray[102] = -109;
        byArray[103] = -53;
        byArray[104] = -105;
        byArray[105] = 42;
        byArray[107] = -100;
        byArray[108] = 92;
        byArray[109] = 78;
        byArray[110] = 12;
        byArray[111] = -68;
        byArray[112] = -6;
        byArray[113] = 21;
        byArray[114] = 82;
        byArray[115] = -4;
        byArray[116] = -14;
        byArray[117] = 68;
        byArray[118] = 110;
        byArray[119] = -38;
        byArray[120] = 17;
        byArray[121] = 74;
        byArray[122] = 110;
        byArray[123] = 8;
        byArray[124] = -97;
        byArray[125] = 47;
        byArray[126] = 45;
        byArray[127] = -29;
        byArray[128] = -7;
        byArray[129] = -86;
        byArray[130] = 58;
        byArray[131] = -122;
        byArray[132] = 115;
        byArray[133] = -74;
        byArray[134] = 70;
        byArray[135] = 83;
        byArray[136] = 88;
        byArray[137] = -56;
        byArray[138] = -119;
        byArray[139] = 5;
        byArray[140] = -67;
        byArray[141] = -125;
        byArray[142] = 17;
        byArray[143] = -72;
        byArray[144] = 115;
        byArray[145] = 63;
        byArray[146] = -86;
        byArray[147] = 7;
        byArray[148] = -115;
        byArray[149] = -12;
        byArray[150] = 66;
        byArray[151] = 77;
        byArray[152] = -25;
        byArray[153] = 64;
        byArray[154] = -99;
        byArray[155] = 28;
        byArray[156] = 55;
        byArray[157] = 2;
        byArray[158] = 3;
        byArray[159] = 1;
        byArray[161] = 1;
        PK_BYTES_THAWTE = byArray;
        byte[] byArray2 = new byte[162];
        byArray2[0] = 48;
        byArray2[1] = -127;
        byArray2[2] = -97;
        byArray2[3] = 48;
        byArray2[4] = 13;
        byArray2[5] = 6;
        byArray2[6] = 9;
        byArray2[7] = 42;
        byArray2[8] = -122;
        byArray2[9] = 72;
        byArray2[10] = -122;
        byArray2[11] = -9;
        byArray2[12] = 13;
        byArray2[13] = 1;
        byArray2[14] = 1;
        byArray2[15] = 1;
        byArray2[16] = 5;
        byArray2[18] = 3;
        byArray2[19] = -127;
        byArray2[20] = -115;
        byArray2[22] = 48;
        byArray2[23] = -127;
        byArray2[24] = -119;
        byArray2[25] = 2;
        byArray2[26] = -127;
        byArray2[27] = -127;
        byArray2[29] = -55;
        byArray2[30] = 92;
        byArray2[31] = 89;
        byArray2[32] = -98;
        byArray2[33] = -14;
        byArray2[34] = 27;
        byArray2[35] = -118;
        byArray2[36] = 1;
        byArray2[37] = 20;
        byArray2[38] = -76;
        byArray2[39] = 16;
        byArray2[40] = -33;
        byArray2[41] = 4;
        byArray2[42] = 64;
        byArray2[43] = -37;
        byArray2[44] = -29;
        byArray2[45] = 87;
        byArray2[46] = -81;
        byArray2[47] = 106;
        byArray2[48] = 69;
        byArray2[49] = 64;
        byArray2[50] = -113;
        byArray2[51] = -124;
        byArray2[52] = 12;
        byArray2[53] = 11;
        byArray2[54] = -47;
        byArray2[55] = 51;
        byArray2[56] = -39;
        byArray2[57] = -39;
        byArray2[58] = 17;
        byArray2[59] = -49;
        byArray2[60] = -18;
        byArray2[61] = 2;
        byArray2[62] = 88;
        byArray2[63] = 31;
        byArray2[64] = 37;
        byArray2[65] = -9;
        byArray2[66] = 42;
        byArray2[67] = -88;
        byArray2[68] = 68;
        byArray2[69] = 5;
        byArray2[70] = -86;
        byArray2[71] = -20;
        byArray2[72] = 3;
        byArray2[73] = 31;
        byArray2[74] = 120;
        byArray2[75] = 127;
        byArray2[76] = -98;
        byArray2[77] = -109;
        byArray2[78] = -71;
        byArray2[79] = -102;
        byArray2[81] = -86;
        byArray2[82] = 35;
        byArray2[83] = 125;
        byArray2[84] = -42;
        byArray2[85] = -84;
        byArray2[86] = -123;
        byArray2[87] = -94;
        byArray2[88] = 99;
        byArray2[89] = 69;
        byArray2[90] = -57;
        byArray2[91] = 114;
        byArray2[92] = 39;
        byArray2[93] = -52;
        byArray2[94] = -12;
        byArray2[95] = 76;
        byArray2[96] = -58;
        byArray2[97] = 117;
        byArray2[98] = 113;
        byArray2[99] = -46;
        byArray2[100] = 57;
        byArray2[101] = -17;
        byArray2[102] = 79;
        byArray2[103] = 66;
        byArray2[104] = -16;
        byArray2[105] = 117;
        byArray2[106] = -33;
        byArray2[107] = 10;
        byArray2[108] = -112;
        byArray2[109] = -58;
        byArray2[110] = -114;
        byArray2[111] = 32;
        byArray2[112] = 111;
        byArray2[113] = -104;
        byArray2[114] = 15;
        byArray2[115] = -8;
        byArray2[116] = -84;
        byArray2[117] = 35;
        byArray2[118] = 95;
        byArray2[119] = 112;
        byArray2[120] = 41;
        byArray2[121] = 54;
        byArray2[122] = -92;
        byArray2[123] = -55;
        byArray2[124] = -122;
        byArray2[125] = -25;
        byArray2[126] = -79;
        byArray2[127] = -102;
        byArray2[128] = 32;
        byArray2[129] = -53;
        byArray2[130] = 83;
        byArray2[131] = -91;
        byArray2[132] = -123;
        byArray2[133] = -25;
        byArray2[134] = 61;
        byArray2[135] = -66;
        byArray2[136] = 125;
        byArray2[137] = -102;
        byArray2[138] = -2;
        byArray2[139] = 36;
        byArray2[140] = 69;
        byArray2[141] = 51;
        byArray2[142] = -36;
        byArray2[143] = 118;
        byArray2[144] = 21;
        byArray2[145] = -19;
        byArray2[146] = 15;
        byArray2[147] = -94;
        byArray2[148] = 113;
        byArray2[149] = 100;
        byArray2[150] = 76;
        byArray2[151] = 101;
        byArray2[152] = 46;
        byArray2[153] = -127;
        byArray2[154] = 104;
        byArray2[155] = 69;
        byArray2[156] = -89;
        byArray2[157] = 2;
        byArray2[158] = 3;
        byArray2[159] = 1;
        byArray2[161] = 1;
        PK_BYTES_VERISIGN = byArray2;
        byte[] byArray3 = new byte[294];
        byArray3[0] = 48;
        byArray3[1] = -126;
        byArray3[2] = 1;
        byArray3[3] = 34;
        byArray3[4] = 48;
        byArray3[5] = 13;
        byArray3[6] = 6;
        byArray3[7] = 9;
        byArray3[8] = 42;
        byArray3[9] = -122;
        byArray3[10] = 72;
        byArray3[11] = -122;
        byArray3[12] = -9;
        byArray3[13] = 13;
        byArray3[14] = 1;
        byArray3[15] = 1;
        byArray3[16] = 1;
        byArray3[17] = 5;
        byArray3[19] = 3;
        byArray3[20] = -126;
        byArray3[21] = 1;
        byArray3[22] = 15;
        byArray3[24] = 48;
        byArray3[25] = -126;
        byArray3[26] = 1;
        byArray3[27] = 10;
        byArray3[28] = 2;
        byArray3[29] = -126;
        byArray3[30] = 1;
        byArray3[31] = 1;
        byArray3[33] = -66;
        byArray3[34] = -68;
        byArray3[35] = -18;
        byArray3[36] = -68;
        byArray3[37] = 126;
        byArray3[38] = -17;
        byArray3[39] = -125;
        byArray3[40] = -21;
        byArray3[41] = -32;
        byArray3[42] = 55;
        byArray3[43] = 79;
        byArray3[44] = -5;
        byArray3[45] = 3;
        byArray3[46] = 16;
        byArray3[47] = 56;
        byArray3[48] = -66;
        byArray3[49] = 8;
        byArray3[50] = -46;
        byArray3[51] = -116;
        byArray3[52] = 125;
        byArray3[53] = -99;
        byArray3[54] = -6;
        byArray3[55] = -110;
        byArray3[56] = 127;
        byArray3[57] = 25;
        byArray3[58] = 12;
        byArray3[59] = -62;
        byArray3[60] = 107;
        byArray3[61] = -18;
        byArray3[62] = 66;
        byArray3[63] = 82;
        byArray3[64] = -116;
        byArray3[65] = -34;
        byArray3[66] = -45;
        byArray3[67] = 28;
        byArray3[68] = 72;
        byArray3[69] = 19;
        byArray3[70] = 37;
        byArray3[71] = -22;
        byArray3[72] = -63;
        byArray3[73] = 99;
        byArray3[74] = 122;
        byArray3[75] = -7;
        byArray3[76] = 81;
        byArray3[77] = 101;
        byArray3[78] = -18;
        byArray3[79] = -45;
        byArray3[80] = -86;
        byArray3[81] = 59;
        byArray3[82] = -11;
        byArray3[83] = -16;
        byArray3[84] = -108;
        byArray3[85] = -100;
        byArray3[86] = 43;
        byArray3[87] = -5;
        byArray3[88] = -14;
        byArray3[89] = 102;
        byArray3[90] = -44;
        byArray3[91] = 36;
        byArray3[92] = -38;
        byArray3[93] = -9;
        byArray3[94] = -11;
        byArray3[95] = -97;
        byArray3[96] = 110;
        byArray3[97] = 25;
        byArray3[98] = 57;
        byArray3[99] = 54;
        byArray3[100] = -68;
        byArray3[101] = -48;
        byArray3[102] = -93;
        byArray3[103] = 118;
        byArray3[104] = 8;
        byArray3[105] = 30;
        byArray3[106] = 34;
        byArray3[107] = 39;
        byArray3[108] = 36;
        byArray3[109] = 108;
        byArray3[110] = 56;
        byArray3[111] = -111;
        byArray3[112] = 39;
        byArray3[113] = -30;
        byArray3[114] = -124;
        byArray3[115] = 73;
        byArray3[116] = -82;
        byArray3[117] = 27;
        byArray3[118] = -118;
        byArray3[119] = -95;
        byArray3[120] = -3;
        byArray3[121] = 37;
        byArray3[122] = -126;
        byArray3[123] = 44;
        byArray3[124] = 16;
        byArray3[125] = 48;
        byArray3[126] = -24;
        byArray3[127] = 113;
        byArray3[128] = -85;
        byArray3[129] = 40;
        byArray3[130] = -24;
        byArray3[131] = 119;
        byArray3[132] = 74;
        byArray3[133] = 81;
        byArray3[134] = -15;
        byArray3[135] = -20;
        byArray3[136] = -51;
        byArray3[137] = -8;
        byArray3[138] = -16;
        byArray3[139] = 84;
        byArray3[140] = -44;
        byArray3[141] = 111;
        byArray3[142] = -64;
        byArray3[143] = -29;
        byArray3[144] = 109;
        byArray3[145] = 10;
        byArray3[146] = -113;
        byArray3[147] = -39;
        byArray3[148] = -40;
        byArray3[149] = 100;
        byArray3[150] = -115;
        byArray3[151] = 99;
        byArray3[152] = -78;
        byArray3[153] = 45;
        byArray3[154] = 78;
        byArray3[155] = 39;
        byArray3[156] = -10;
        byArray3[157] = -123;
        byArray3[158] = 14;
        byArray3[159] = -2;
        byArray3[160] = 109;
        byArray3[161] = -29;
        byArray3[162] = 41;
        byArray3[163] = -103;
        byArray3[164] = -30;
        byArray3[165] = -123;
        byArray3[166] = 71;
        byArray3[167] = 124;
        byArray3[168] = 45;
        byArray3[169] = -122;
        byArray3[170] = 127;
        byArray3[171] = -24;
        byArray3[172] = 87;
        byArray3[173] = -113;
        byArray3[174] = -83;
        byArray3[175] = 103;
        byArray3[176] = -62;
        byArray3[177] = 51;
        byArray3[178] = 50;
        byArray3[179] = -111;
        byArray3[180] = 19;
        byArray3[181] = 32;
        byArray3[182] = -4;
        byArray3[183] = -87;
        byArray3[184] = 35;
        byArray3[185] = 20;
        byArray3[186] = -102;
        byArray3[187] = 109;
        byArray3[188] = -62;
        byArray3[189] = -124;
        byArray3[190] = 75;
        byArray3[191] = 118;
        byArray3[192] = 104;
        byArray3[193] = 4;
        byArray3[194] = -43;
        byArray3[195] = 113;
        byArray3[196] = 44;
        byArray3[197] = 93;
        byArray3[198] = 33;
        byArray3[199] = -6;
        byArray3[200] = -120;
        byArray3[201] = 13;
        byArray3[202] = 38;
        byArray3[203] = -3;
        byArray3[204] = 31;
        byArray3[205] = 45;
        byArray3[206] = -111;
        byArray3[207] = 43;
        byArray3[208] = -25;
        byArray3[209] = 1;
        byArray3[210] = 85;
        byArray3[211] = 77;
        byArray3[212] = -14;
        byArray3[213] = 109;
        byArray3[214] = 53;
        byArray3[215] = 40;
        byArray3[216] = -126;
        byArray3[217] = -33;
        byArray3[218] = -39;
        byArray3[219] = 107;
        byArray3[220] = 92;
        byArray3[221] = -74;
        byArray3[222] = -42;
        byArray3[223] = -39;
        byArray3[224] = -86;
        byArray3[225] = -127;
        byArray3[226] = -3;
        byArray3[227] = 95;
        byArray3[228] = -51;
        byArray3[229] = -125;
        byArray3[230] = -70;
        byArray3[231] = 99;
        byArray3[232] = -99;
        byArray3[233] = -48;
        byArray3[234] = 34;
        byArray3[235] = -4;
        byArray3[236] = -87;
        byArray3[237] = 59;
        byArray3[238] = 66;
        byArray3[239] = 105;
        byArray3[240] = -78;
        byArray3[241] = -114;
        byArray3[242] = 58;
        byArray3[243] = -75;
        byArray3[244] = -68;
        byArray3[245] = -76;
        byArray3[246] = -98;
        byArray3[247] = 15;
        byArray3[248] = 94;
        byArray3[249] = -60;
        byArray3[250] = -22;
        byArray3[251] = 44;
        byArray3[252] = -126;
        byArray3[253] = -117;
        byArray3[254] = 40;
        byArray3[255] = -3;
        byArray3[256] = 83;
        byArray3[257] = 8;
        byArray3[258] = -106;
        byArray3[259] = -35;
        byArray3[260] = -75;
        byArray3[261] = 1;
        byArray3[262] = 32;
        byArray3[263] = -47;
        byArray3[264] = -7;
        byArray3[265] = -91;
        byArray3[266] = 24;
        byArray3[267] = -25;
        byArray3[268] = -64;
        byArray3[269] = -18;
        byArray3[270] = 81;
        byArray3[271] = 112;
        byArray3[272] = 55;
        byArray3[273] = -31;
        byArray3[274] = -74;
        byArray3[275] = 5;
        byArray3[276] = 72;
        byArray3[277] = 82;
        byArray3[278] = 72;
        byArray3[279] = 111;
        byArray3[280] = 56;
        byArray3[281] = -22;
        byArray3[282] = -61;
        byArray3[283] = -24;
        byArray3[284] = 108;
        byArray3[285] = 123;
        byArray3[286] = 68;
        byArray3[287] = -124;
        byArray3[288] = -69;
        byArray3[289] = 2;
        byArray3[290] = 3;
        byArray3[291] = 1;
        byArray3[293] = 1;
        PK_BYTES_VERISIGN_2 = byArray3;
        trustedCertPaths = new HashSet<CertPath>();
        try {
            pkVerisign = new X509Key();
            pkVerisign2 = new X509Key();
            pkThawte = new X509Key();
            pkVerisign.decode(PK_BYTES_VERISIGN);
            pkVerisign2.decode(PK_BYTES_VERISIGN_2);
            pkThawte.decode(PK_BYTES_THAWTE);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException("CA keys could not be initiated! I guessed that should never happen, sorry :-)");
        }
    }

    public static File[] collectNewestExtensionManifests() {
        File[] extensionFiles;
        LinkedList<File> manifestFileList = new LinkedList<File>();
        File[] fileArray = extensionFiles = new File(ExtensionUtilties.getUserExtensionDirectory()).listFiles();
        int n = extensionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File manifestFile;
            File highestVersionExtensionDir;
            File extensionFile = fileArray[n2];
            if (extensionFile.isDirectory() && (highestVersionExtensionDir = ExtensionUtilties.getHighestVersionExtensionDir(extensionFile.getName())) != null && (manifestFile = ExtensionUtilties.getManifestFile(highestVersionExtensionDir)) != null) {
                manifestFileList.add(manifestFile);
            }
            ++n2;
        }
        return manifestFileList.toArray(new File[manifestFileList.size()]);
    }

    public static File[] collectNewestExtensionManifests(UserManifest userManifest) {
        LinkedList<File> manifestFileList = new LinkedList<File>();
        for (ExtensionBundle extensionBundle : userManifest.getExtensionBundles()) {
            String localUri = extensionBundle.getLocalUri();
            File extensionDir = new File(URI.create(localUri));
            File manifestFile = ExtensionUtilties.getManifestFile(extensionDir);
            if (manifestFile == null) continue;
            manifestFileList.add(manifestFile);
        }
        return manifestFileList.toArray(new File[manifestFileList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public static List<File> copyFiles(File src, File dest) throws IOException {
        block4: {
            copiedFiles = new LinkedList<File>();
            try {
                ExtensionUtilties.copyFilesInternal(src, dest, copiedFiles);
                break block4;
            }
            catch (IOException e) {
                ** for (file : copiedFiles)
            }
lbl-1000:
            // 1 sources

            {
                if (ExtensionUtilties.LOGGER.isLogging(Level.DEBUG)) {
                    ExtensionUtilties.LOGGER.debug((Object)("Reverting because of failure: " + file));
                }
                file.delete();
                continue;
            }
lbl12:
            // 1 sources

            throw e;
        }
        return copiedFiles;
    }

    public static void deleteFiles(File file) throws IOException {
        boolean success;
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File current = fileArray[n2];
                ExtensionUtilties.deleteFiles(current);
                ++n2;
            }
        }
        if (LOGGER.isLogging(Level.DEBUG)) {
            LOGGER.debug((Object)("Deleting: " + file));
        }
        if (!(success = file.delete())) {
            throw new IOException("Could not delete: " + file);
        }
    }

    public static void downloadFile(URL url, File destFile) throws IOException {
        if (!destFile.isFile()) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(destFile);
                ExtensionUtilties.downloadFile(url, fos);
            }
            catch (IOException e) {
                if (destFile.exists()) {
                    destFile.delete();
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void downloadFile(URL url, OutputStream os) throws IOException {
        if (LOGGER.isLogging(Level.DEBUG)) {
            LOGGER.debug((Object)("Downloading file from : " + url));
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(url.openStream());
            bos = new BufferedOutputStream(os);
            int length = 0;
            byte[] bytes = new byte[2048];
            while ((length = bis.read(bytes)) > 0) {
                ((BufferedOutputStream)bos).write(bytes, 0, length);
            }
        }
        catch (Throwable throwable) {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Properties getAgentProperties() throws IOException {
        Properties properties = new Properties();
        File propFile = new File(String.valueOf(System.getProperty("user.dir")) + "/configuration/agent.properties");
        if (propFile.isFile()) {
            properties.load(new FileInputStream(propFile));
        }
        return properties;
    }

    public static long getDirectorySize(File file) {
        long size = 0L;
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File current = fileArray[n2];
                long currentSize = ExtensionUtilties.getDirectorySize(current);
                size += currentSize;
                ++n2;
            }
        } else {
            long currentSize = file.length();
            size += currentSize;
        }
        return size;
    }

    public static String getExtensionBundleId(File extensionManifestFile) throws IOException {
        return ExtensionUtilties.getExtensionBundleAttribute(extensionManifestFile, "ExtensionBundleId");
    }

    public static String getExtensionBundleVersion(File extensionManifestFile) throws IOException {
        return ExtensionUtilties.getExtensionBundleAttribute(extensionManifestFile, "ExtensionBundleVersion");
    }

    public static String getExtensionDirectory() {
        if (EXTENSION_DIRECTORY == null) {
            String osgiInstallDir = System.getProperty("osgi.install.area");
            try {
                URL url = new URL(osgiInstallDir);
                URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
                File file = new File(uri);
                osgiInstallDir = file.getAbsolutePath();
                osgiInstallDir = osgiInstallDir.replaceAll("\\\\", "/");
                osgiInstallDir = osgiInstallDir.replaceAll("/+", "/");
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {}
            File file = new File(String.valueOf(osgiInstallDir) + "/extensions");
            EXTENSION_DIRECTORY = file.getAbsolutePath();
        }
        return EXTENSION_DIRECTORY;
    }

    public static File getHighestVersionExtensionDir(String extensionName) {
        File[] versionDirs;
        File highestVersionExtensionDir = null;
        File extensionDir = new File(ExtensionUtilties.getUserExtensionDirectory(), extensionName);
        if (extensionDir.isDirectory() && (versionDirs = extensionDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().matches("[0-9]+");
            }
        })).length > 0) {
            Arrays.sort(versionDirs, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    String name1 = o1.getName();
                    String name2 = o2.getName();
                    int version1 = Integer.parseInt(name1);
                    int version2 = Integer.parseInt(name2);
                    return version2 - version1;
                }
            });
            highestVersionExtensionDir = versionDirs[0];
        }
        return highestVersionExtensionDir;
    }

    public static File getManifestFile(File versionExtensionDir) {
        File[] manifestFiles;
        File manifestFile = null;
        File[] metaInfFiles = versionExtensionDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().equals("META-INF");
            }
        });
        if (metaInfFiles.length == 1 && (manifestFiles = metaInfFiles[0].listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equals("manifest.xml");
            }
        })).length == 1) {
            manifestFile = manifestFiles[0];
        }
        return manifestFile;
    }

    public static File getNextVersionExtensionDir(String extensionName) {
        File nextVersionExtensionDir = null;
        File highestVersionExtensionDir = ExtensionUtilties.getHighestVersionExtensionDir(extensionName);
        if (highestVersionExtensionDir != null) {
            int version = Integer.parseInt(highestVersionExtensionDir.getName());
            nextVersionExtensionDir = new File(String.valueOf(ExtensionUtilties.getUserExtensionDirectory()) + "/" + extensionName + "/" + ++version);
        } else {
            nextVersionExtensionDir = new File(String.valueOf(ExtensionUtilties.getUserExtensionDirectory()) + "/" + extensionName + "/1");
        }
        return nextVersionExtensionDir;
    }

    public static String getUserExtensionDirectory() {
        if (USER_EXTENSION_DIRECTORY == null) {
            USER_EXTENSION_DIRECTORY = System.getProperty("user.dir");
            USER_EXTENSION_DIRECTORY = String.valueOf(USER_EXTENSION_DIRECTORY) + "/extensions";
            USER_EXTENSION_DIRECTORY = USER_EXTENSION_DIRECTORY.replaceAll("\\\\", "/");
            USER_EXTENSION_DIRECTORY = USER_EXTENSION_DIRECTORY.replaceAll("/+", "/");
        }
        return USER_EXTENSION_DIRECTORY;
    }

    public static boolean hasValidExtensionStructure(File extensionRootDir) {
        boolean validStructure = false;
        if (extensionRootDir.isDirectory()) {
            File manifest = ExtensionUtilties.getManifestFile(extensionRootDir);
            validStructure = manifest != null;
        }
        return validStructure;
    }

    public static boolean isDirectorySizeChanging(File file, long timeGap) {
        long size1 = ExtensionUtilties.getDirectorySize(file);
        try {
            Thread.sleep(timeGap);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long size2 = ExtensionUtilties.getDirectorySize(file);
        return size1 != size2;
    }

    public static UserManifest parseUserManifest(String xml, SAXParserFactory saxParserFactory) throws IOException {
        UserManifest userManifest = null;
        UserManifestParser parser = new UserManifestParser(saxParserFactory);
        userManifest = parser.parse(new ByteArrayInputStream(xml.getBytes()));
        return userManifest;
    }

    public static void setAgentProperties(Properties properties) throws IOException {
        File propFile = new File(String.valueOf(System.getProperty("user.dir")) + "/configuration/agent.properties");
        if (!propFile.isFile()) {
            propFile.getParentFile().mkdirs();
        }
        properties.store(new FileOutputStream(propFile), "");
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        if (!destDir.isDirectory()) {
            destDir.mkdirs();
        }
        JarInputStream zis = new JarInputStream(new FileInputStream(zipFile));
        try {
            try {
                Manifest manifest = zis.getManifest();
                if (manifest == null) {
                    throw new SecurityException(zipFile + ": No MANIFEST.MF found (not signed?)");
                }
                Map<String, Attributes> entriesMap = manifest.getEntries();
                int deflatedCount = 0;
                JarEntry entry = null;
                while ((entry = zis.getNextJarEntry()) != null) {
                    File entryFile = new File(destDir + "/" + entry.getName());
                    if (entry.isDirectory()) {
                        entryFile.mkdirs();
                        continue;
                    }
                    if (entry.toString().toUpperCase().matches("^META-INF/.*SF$") || entry.toString().toUpperCase().matches("^META-INF/.*RSA$")) continue;
                    if (!entriesMap.containsKey(entry.toString())) {
                        throw new SecurityException(entry + " has no corresponding entry in the MANIFEST.MF");
                    }
                    entryFile.getParentFile().mkdirs();
                    if (LOGGER.isLogging(Level.DEBUG)) {
                        LOGGER.debug((Object)("Deflating file: " + entry.getName()));
                    }
                    BufferedInputStream bis = null;
                    FilterOutputStream bos = null;
                    try {
                        bis = new BufferedInputStream(zis);
                        bos = new BufferedOutputStream(new FileOutputStream(new File(destDir + "/" + entry.getName())));
                        byte[] bytes = new byte[2048];
                        int length = 0;
                        while ((length = bis.read(bytes)) > 0) {
                            ((BufferedOutputStream)bos).write(bytes, 0, length);
                        }
                        if (!entry.toString().toUpperCase().matches("^META-INF/.*")) {
                            CodeSigner[] codeSigners = entry.getCodeSigners();
                            if (codeSigners == null || codeSigners.length != 1) {
                                throw new SecurityException("No codesigner found for " + entry.getName());
                            }
                            CodeSigner[] codeSignerArray = codeSigners;
                            int n = codeSigners.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CodeSigner codeSigner = codeSignerArray[n2];
                                CertPath certPath = codeSigner.getSignerCertPath();
                                if (!trustedCertPaths.contains(certPath)) {
                                    try {
                                        if (LOGGER.isLogging(Level.INFO)) {
                                            LOGGER.info((Object)("Checking certificate and certificate path for " + zipFile));
                                        }
                                        if (LOGGER.isLogging(Level.DEBUG)) {
                                            LOGGER.debug((Object)certPath);
                                        }
                                        List<? extends Certificate> certificateList = certPath.getCertificates();
                                        X509Certificate rootCertificate = (X509Certificate)certificateList.get(certificateList.size() - 1);
                                        HashSet<X509Certificate> trustedCertSet = new HashSet<X509Certificate>();
                                        rootCertificate.checkValidity();
                                        if (!rootCertificate.getPublicKey().equals(pkVerisign) && !rootCertificate.getPublicKey().equals(pkThawte)) {
                                            throw new Exception("No valid CA certificate could be found!");
                                        }
                                        trustedCertSet.add(rootCertificate);
                                        Validator validator = Validator.getInstance("PKIX", "code signing", trustedCertSet);
                                        validator.validate(certificateList.toArray(new X509Certificate[certificateList.size()]));
                                        X509Certificate adobeCertificate = (X509Certificate)certificateList.get(0);
                                        adobeCertificate.checkValidity();
                                        if (!adobeCertificate.getSubjectDN().getName().matches(".*O\\s*=\\s*Adobe Systems Incorporated.*")) {
                                            throw new Exception("Extension was not signed by Adobe Systems Incorporated");
                                        }
                                        trustedCertPaths.add(certPath);
                                    }
                                    catch (Exception e) {
                                        throw new SecurityException("Signing of " + entry.getName() + " couln't be verified: " + e.getMessage(), e);
                                    }
                                }
                                ++n2;
                            }
                        }
                        ++deflatedCount;
                    }
                    catch (Throwable throwable) {
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (bos == null) continue;
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (deflatedCount != entriesMap.size()) {
                    throw new SecurityException("There are entries in the MANIFEST.MF which haven't been found in the zip");
                }
            }
            catch (SecurityException e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            try {
                zis.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zis.close();
        }
        catch (IOException iOException) {}
    }

    private static void copyFilesInternal(File src, File dest, List<File> copiedFiles) throws IOException {
        if (src.isDirectory()) {
            File[] files;
            boolean created = dest.mkdirs();
            if (created) {
                copiedFiles.add(dest);
            }
            File[] fileArray = files = src.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ExtensionUtilties.copyFilesInternal(file, new File(dest, file.getName()), copiedFiles);
                ++n2;
            }
        } else {
            if (LOGGER.isLogging(Level.DEBUG)) {
                LOGGER.debug((Object)("Copying " + src + " => " + dest));
            }
            FileChannel srcChannel = null;
            AbstractInterruptibleChannel destChannel = null;
            long transferred = 0L;
            try {
                srcChannel = new FileInputStream(src).getChannel();
                destChannel = new FileOutputStream(dest).getChannel();
                transferred = srcChannel.transferTo(0L, src.length(), (WritableByteChannel)((Object)destChannel));
                copiedFiles.add(dest);
                if (transferred != src.length()) {
                    throw new IOException("Unequal content size " + transferred + " from " + src.length());
                }
            }
            catch (Throwable throwable) {
                if (srcChannel != null) {
                    try {
                        srcChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (destChannel != null) {
                    try {
                        destChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (srcChannel != null) {
                try {
                    srcChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (destChannel != null) {
                try {
                    destChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getExtensionBundleAttribute(File extensionManifestFile, String attribute) throws IOException {
        String value = null;
        if (extensionManifestFile.isFile() && extensionManifestFile.getName().equals("manifest.xml")) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(extensionManifestFile), "UTF-8"));
            String line = null;
            try {
                while ((line = br.readLine()) != null) {
                    int index = line.indexOf(attribute);
                    if (index <= 0) continue;
                    int startQuoteIndex = line.indexOf("\"", index + 1) + 1;
                    int stopQuoteIndex = line.indexOf("\"", startQuoteIndex);
                    if (startQuoteIndex > 0 && stopQuoteIndex > 0) {
                        value = line.substring(startQuoteIndex, stopQuoteIndex);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return value;
    }
}

