/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.CipherSuiteConstants;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class CipherSuite
implements Comparable,
CipherSuiteConstants {
    static final int SUPPORTED_SUITES_PRIORITY = 1;
    static final int DEFAULT_SUITES_PRIORITY = 300;
    static final boolean DYNAMIC_AVAILABILITY = false;
    private static final Map idMap = new HashMap();
    private static final Map nameMap = new HashMap();
    final String name;
    final int id;
    final int priority;
    final KeyExchange keyExchange;
    final BulkCipher cipher;
    final MacAlg macAlg;
    final boolean exportable;
    final boolean allowed;
    static final CipherSuite C_NULL;

    private CipherSuite(String string, int n, int n2, KeyExchange keyExchange, BulkCipher bulkCipher, boolean bl) {
        this.name = string;
        this.id = n;
        this.priority = n2;
        this.keyExchange = keyExchange;
        this.cipher = bulkCipher;
        this.exportable = bulkCipher.exportable;
        if (string.endsWith("_MD5")) {
            this.macAlg = M_MD5;
        } else if (string.endsWith("_SHA")) {
            this.macAlg = M_SHA;
        } else if (string.endsWith("_NULL")) {
            this.macAlg = M_NULL;
        } else {
            throw new IllegalArgumentException("Unknown MAC algorithm for ciphersuite " + string);
        }
        bl &= keyExchange.allowed;
        this.allowed = bl &= bulkCipher.allowed;
    }

    private CipherSuite(String string, int n) {
        this.name = string;
        this.id = n;
        this.allowed = false;
        this.priority = 0;
        this.keyExchange = null;
        this.cipher = null;
        this.macAlg = null;
        this.exportable = false;
    }

    boolean isAvailable() {
        return this.allowed && this.cipher.isAvailable();
    }

    public int compareTo(Object object) {
        return ((CipherSuite)object).priority - this.priority;
    }

    public String toString() {
        return this.name;
    }

    static CipherSuite valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        CipherSuite cipherSuite = (CipherSuite)nameMap.get(string);
        if (cipherSuite == null || !cipherSuite.allowed) {
            throw new IllegalArgumentException("Unsupported ciphersuite " + string);
        }
        return cipherSuite;
    }

    static CipherSuite valueOf(int n, int n2) {
        int n3 = (n &= 0xFF) << 8 | (n2 &= 0xFF);
        CipherSuite cipherSuite = (CipherSuite)idMap.get(new Integer(n3));
        if (cipherSuite == null) {
            String string = Integer.toString(n, 16);
            String string2 = Integer.toString(n2, 16);
            cipherSuite = new CipherSuite("Unknown 0x" + string + ":0x" + string2, n3);
        }
        return cipherSuite;
    }

    static Collection allowedCipherSuites() {
        return nameMap.values();
    }

    private static void add(String string, int n, int n2, KeyExchange keyExchange, BulkCipher bulkCipher, boolean bl) {
        CipherSuite cipherSuite = new CipherSuite(string, n, n2, keyExchange, bulkCipher, bl);
        if (idMap.put(new Integer(n), cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
        if (cipherSuite.allowed && nameMap.put(string, cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
    }

    private static void add(String string, int n) {
        CipherSuite cipherSuite = new CipherSuite(string, n);
        if (idMap.put(new Integer(n), cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
    }

    static {
        CipherSuite.add("SSL_NULL_WITH_NULL_NULL", 0, 1, K_NULL, B_NULL, false);
        CipherSuite.add("SSL_RSA_WITH_RC4_128_MD5", 4, 950, K_RSA, B_RC4_128, true);
        CipherSuite.add("SSL_RSA_WITH_RC4_128_SHA", 5, 940, K_RSA, B_RC4_128, true);
        CipherSuite.add("TLS_RSA_WITH_AES_128_CBC_SHA", 47, 830, K_RSA, B_AES_128, true);
        CipherSuite.add("TLS_RSA_WITH_AES_256_CBC_SHA", 53, 828, K_RSA, B_AES_256, true);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51, 825, K_DHE_RSA, B_AES_128, true);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57, 823, K_DHE_RSA, B_AES_256, true);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50, 820, K_DHE_DSS, B_AES_128, true);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56, 818, K_DHE_DSS, B_AES_256, true);
        CipherSuite.add("SSL_RSA_WITH_3DES_EDE_CBC_SHA", 10, 650, K_RSA, B_3DES, true);
        CipherSuite.add("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22, 640, K_DHE_RSA, B_3DES, true);
        CipherSuite.add("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19, 630, K_DHE_DSS, B_3DES, true);
        CipherSuite.add("SSL_RSA_WITH_DES_CBC_SHA", 9, 550, K_RSA, B_DES, true);
        CipherSuite.add("SSL_DHE_RSA_WITH_DES_CBC_SHA", 21, 540, K_DHE_RSA, B_DES, true);
        CipherSuite.add("SSL_DHE_DSS_WITH_DES_CBC_SHA", 18, 530, K_DHE_DSS, B_DES, true);
        CipherSuite.add("SSL_RSA_EXPORT_WITH_RC4_40_MD5", 3, 350, K_RSA_EXPORT, B_RC4_40, true);
        CipherSuite.add("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", 8, 340, K_RSA_EXPORT, B_DES_40, true);
        CipherSuite.add("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 20, 335, K_DHE_RSA, B_DES_40, true);
        CipherSuite.add("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17, 330, K_DHE_DSS, B_DES_40, true);
        CipherSuite.add("TLS_KRB5_WITH_RC4_128_SHA", 32, 100, K_KRB5, B_RC4_128, true);
        CipherSuite.add("TLS_KRB5_WITH_RC4_128_MD5", 36, 90, K_KRB5, B_RC4_128, true);
        CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", 31, 80, K_KRB5, B_3DES, true);
        CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", 35, 75, K_KRB5, B_3DES, true);
        CipherSuite.add("TLS_KRB5_WITH_DES_CBC_SHA", 30, 70, K_KRB5, B_DES, true);
        CipherSuite.add("TLS_KRB5_WITH_DES_CBC_MD5", 34, 65, K_KRB5, B_DES, true);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC4_40_SHA", 40, 60, K_KRB5_EXPORT, B_RC4_40, true);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC4_40_MD5", 43, 50, K_KRB5_EXPORT, B_RC4_40, true);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 38, 40, K_KRB5_EXPORT, B_DES_40, true);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 41, 30, K_KRB5_EXPORT, B_DES_40, true);
        CipherSuite.add("SSL_RSA_WITH_NULL_MD5", 1, 250, K_RSA, B_NULL, true);
        CipherSuite.add("SSL_RSA_WITH_NULL_SHA", 2, 240, K_RSA, B_NULL, true);
        CipherSuite.add("SSL_DH_anon_WITH_RC4_128_MD5", 24, 190, K_DH_ANON, B_RC4_128, true);
        CipherSuite.add("TLS_DH_anon_WITH_AES_128_CBC_SHA", 52, 185, K_DH_ANON, B_AES_128, true);
        CipherSuite.add("TLS_DH_anon_WITH_AES_256_CBC_SHA", 58, 182, K_DH_ANON, B_AES_256, true);
        CipherSuite.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 27, 180, K_DH_ANON, B_3DES, true);
        CipherSuite.add("SSL_DH_anon_WITH_DES_CBC_SHA", 26, 150, K_DH_ANON, B_DES, true);
        CipherSuite.add("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 23, 130, K_DH_ANON, B_RC4_40, true);
        CipherSuite.add("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 25, 120, K_DH_ANON, B_DES_40, true);
        CipherSuite.add("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", 6);
        CipherSuite.add("SSL_RSA_WITH_IDEA_CBC_SHA", 7);
        CipherSuite.add("SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", 11);
        CipherSuite.add("SSL_DH_DSS_WITH_DES_CBC_SHA", 12);
        CipherSuite.add("SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", 13);
        CipherSuite.add("SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", 14);
        CipherSuite.add("SSL_DH_RSA_WITH_DES_CBC_SHA", 15);
        CipherSuite.add("SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", 16);
        CipherSuite.add("SSL_FORTEZZA_DMS_WITH_NULL_SHA", 28);
        CipherSuite.add("SSL_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA", 29);
        CipherSuite.add("SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA", 98);
        CipherSuite.add("SSL_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA", 99);
        CipherSuite.add("SSL_RSA_EXPORT1024_WITH_RC4_56_SHA", 100);
        CipherSuite.add("SSL_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA", 101);
        CipherSuite.add("SSL_DHE_DSS_WITH_RC4_128_SHA", 102);
        CipherSuite.add("NETSCAPE_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 65504);
        CipherSuite.add("NETSCAPE_RSA_FIPS_WITH_DES_CBC_SHA", 65505);
        CipherSuite.add("SSL_RSA_FIPS_WITH_DES_CBC_SHA", 65278);
        CipherSuite.add("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 65279);
        CipherSuite.add("TLS_KRB5_WITH_IDEA_CBC_SHA", 33);
        CipherSuite.add("TLS_KRB5_WITH_IDEA_CBC_MD5", 37);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", 39);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", 42);
        C_NULL = CipherSuite.valueOf(0, 0);
    }

    static final class BulkCipher {
        private static final Map availableCache = new HashMap(8);
        final String name;
        final boolean allowed;
        final int keySize;
        final int expandedKeySize;
        final int ivSize;
        final boolean exportable;

        BulkCipher(String string, int n, int n2, int n3, boolean bl) {
            this.name = string;
            this.keySize = n;
            this.ivSize = n3;
            this.allowed = bl;
            this.expandedKeySize = n2;
            this.exportable = true;
        }

        BulkCipher(String string, int n, int n2, boolean bl) {
            this.name = string;
            this.keySize = n;
            this.ivSize = n2;
            this.allowed = bl;
            this.expandedKeySize = n;
            this.exportable = false;
        }

        CipherBox newCipher(ProtocolVersion protocolVersion, byte[] byArray, byte[] byArray2, boolean bl) throws NoSuchAlgorithmException {
            return CipherBox.newCipherBox(protocolVersion, this, byArray, byArray2, bl);
        }

        boolean isAvailable() {
            if (!this.allowed) {
                return false;
            }
            if (this == CipherSuiteConstants.B_AES_256) {
                return BulkCipher.isAvailable(this);
            }
            return true;
        }

        static synchronized void clearAvailableCache() {
        }

        private static synchronized boolean isAvailable(BulkCipher bulkCipher) {
            Boolean bl = (Boolean)availableCache.get(bulkCipher);
            if (bl == null) {
                try {
                    byte[] byArray = new byte[bulkCipher.expandedKeySize];
                    byte[] byArray2 = new byte[bulkCipher.ivSize];
                    bulkCipher.newCipher(ProtocolVersion.DEFAULT, byArray, byArray2, true);
                    bl = Boolean.TRUE;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    bl = Boolean.FALSE;
                }
                availableCache.put(bulkCipher, bl);
            }
            return bl;
        }

        public String toString() {
            return this.name;
        }
    }

    static final class KeyExchange {
        final String name;
        final boolean allowed;

        KeyExchange(String string, boolean bl) {
            this.name = string;
            this.allowed = bl;
        }

        public String toString() {
            return this.name;
        }
    }

    static final class MacAlg {
        final String name;
        final int size;

        MacAlg(String string, int n) {
            this.name = string;
            this.size = n;
        }

        MAC newMac(ProtocolVersion protocolVersion, byte[] byArray) throws NoSuchAlgorithmException {
            return new MAC(this, protocolVersion, byArray);
        }

        public String toString() {
            return this.name;
        }
    }
}

