/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import com.sun.java.swing.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import sun.security.action.GetPropertyAction;

public class FilePane
extends JPanel
implements PropertyChangeListener {
    public static final String ACTION_APPROVE_SELECTION = "approveSelection";
    public static final String ACTION_CANCEL = "cancelSelection";
    public static final String ACTION_EDIT_FILE_NAME = "editFileName";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_CHANGE_TO_PARENT_DIRECTORY = "Go Up";
    public static final String ACTION_NEW_FOLDER = "New Folder";
    public static final String ACTION_VIEW_LIST = "viewTypeList";
    public static final String ACTION_VIEW_DETAILS = "viewTypeDetails";
    private Action[] actions;
    public static final int VIEWTYPE_LIST = 0;
    public static final int VIEWTYPE_DETAILS = 1;
    private static final int VIEWTYPE_COUNT = 2;
    private int viewType = -1;
    private JPanel[] viewPanels = new JPanel[2];
    private JPanel currentViewPanel;
    private String[] viewTypeActionNames;
    private JPopupMenu contextMenu;
    private JMenu viewMenu;
    private String viewMenuLabelText;
    private String refreshActionLabelText;
    private String newFolderActionLabelText;
    private FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                FilePane.this.applyEdit();
            }
        }
    };
    private static FocusListener repaintListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            this.repaintSelection(focusEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintSelection(focusEvent.getSource());
        }

        private void repaintSelection(Object object) {
            if (object instanceof JList) {
                this.repaintListSelection((JList)object);
            } else if (object instanceof JTable) {
                this.repaintTableSelection((JTable)object);
            }
        }

        private void repaintListSelection(JList jList) {
            int[] nArray;
            for (int n : nArray = jList.getSelectedIndices()) {
                Rectangle rectangle = jList.getCellBounds(n, n);
                jList.repaint(rectangle);
            }
        }

        private void repaintTableSelection(JTable jTable) {
            int n = jTable.getSelectionModel().getMinSelectionIndex();
            int n2 = jTable.getSelectionModel().getMaxSelectionIndex();
            if (n == -1 || n2 == -1) {
                return;
            }
            int n3 = jTable.convertColumnIndexToView(0);
            Rectangle rectangle = jTable.getCellRect(n, n3, false);
            Rectangle rectangle2 = jTable.getCellRect(n2, n3, false);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            jTable.repaint(rectangle3);
        }
    };
    private boolean smallIconsView = false;
    private Border listViewBorder;
    private Color listViewBackground;
    private boolean listViewWindowsStyle;
    private boolean readOnly;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    private File newFolderFile;
    private FileChooserUIAccessor fileChooserUIAccessor;
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    protected Action newFolderAction;
    private Handler handler;

    public FilePane(FileChooserUIAccessor fileChooserUIAccessor) {
        super(new BorderLayout());
        this.fileChooserUIAccessor = fileChooserUIAccessor;
        this.installDefaults();
        this.createActionMap();
    }

    protected JFileChooser getFileChooser() {
        return this.fileChooserUIAccessor.getFileChooser();
    }

    protected BasicDirectoryModel getModel() {
        return this.fileChooserUIAccessor.getModel();
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setViewType(int n) {
        JPanel jPanel;
        int n2 = this.viewType;
        if (n == n2) {
            return;
        }
        this.viewType = n;
        switch (n) {
            case 0: {
                if (this.viewPanels[n] == null) {
                    jPanel = this.fileChooserUIAccessor.createList();
                    if (jPanel == null) {
                        jPanel = this.createList();
                    }
                    this.setViewPanel(n, jPanel);
                }
                this.list.setLayoutOrientation(1);
                break;
            }
            case 1: {
                if (this.viewPanels[n] != null) break;
                jPanel = this.fileChooserUIAccessor.createDetailsView();
                if (jPanel == null) {
                    jPanel = this.createDetailsView();
                }
                this.setViewPanel(n, jPanel);
            }
        }
        jPanel = this.currentViewPanel;
        this.currentViewPanel = this.viewPanels[n];
        if (this.currentViewPanel != jPanel) {
            if (jPanel != null) {
                this.remove(jPanel);
            }
            this.add((Component)this.currentViewPanel, "Center");
            this.revalidate();
            this.repaint();
        }
        this.updateViewMenu();
        this.firePropertyChange("viewType", n2, n);
    }

    public Action getViewTypeAction(int n) {
        return new ViewTypeAction(n);
    }

    private static void recursivelySetInheritsPopupMenu(Container container, boolean bl) {
        if (container instanceof JComponent) {
            ((JComponent)container).setInheritsPopupMenu(bl);
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            FilePane.recursivelySetInheritsPopupMenu((Container)container.getComponent(i), bl);
        }
    }

    public void setViewPanel(int n, JPanel jPanel) {
        this.viewPanels[n] = jPanel;
        FilePane.recursivelySetInheritsPopupMenu(jPanel, true);
        switch (n) {
            case 0: {
                this.list = (JList)this.findChildComponent(this.viewPanels[n], JList.class);
                if (this.listSelectionModel == null) {
                    this.listSelectionModel = this.list.getSelectionModel();
                    if (this.detailsTable == null) break;
                    this.detailsTable.setSelectionModel(this.listSelectionModel);
                    break;
                }
                this.list.setSelectionModel(this.listSelectionModel);
                break;
            }
            case 1: {
                this.detailsTable = (JTable)this.findChildComponent(this.viewPanels[n], JTable.class);
                this.detailsTable.setRowHeight(Math.max(this.detailsTable.getFont().getSize() + 4, 17));
                if (this.listSelectionModel == null) break;
                this.detailsTable.setSelectionModel(this.listSelectionModel);
            }
        }
        if (this.viewType == n) {
            if (this.currentViewPanel != null) {
                this.remove(this.currentViewPanel);
            }
            this.currentViewPanel = jPanel;
            this.add((Component)this.currentViewPanel, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    protected void installDefaults() {
        Locale locale = this.getFileChooser().getLocale();
        this.listViewBorder = UIManager.getBorder("FileChooser.listViewBorder");
        this.listViewBackground = UIManager.getColor("FileChooser.listViewBackground");
        this.listViewWindowsStyle = UIManager.getBoolean("FileChooser.listViewWindowsStyle");
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        this.viewMenuLabelText = UIManager.getString((Object)"FileChooser.viewMenuLabelText", locale);
        this.refreshActionLabelText = UIManager.getString((Object)"FileChooser.refreshActionLabelText", locale);
        this.newFolderActionLabelText = UIManager.getString((Object)"FileChooser.newFolderActionLabelText", locale);
        this.viewTypeActionNames = new String[2];
        this.viewTypeActionNames[0] = UIManager.getString((Object)"FileChooser.listViewActionLabelText", locale);
        this.viewTypeActionNames[1] = UIManager.getString((Object)"FileChooser.detailsViewActionLabelText", locale);
    }

    public Action[] getActions() {
        if (this.actions == null) {
            ArrayList<Action> arrayList = new ArrayList<Action>(8);
            class FilePaneAction
            extends AbstractAction {
                FilePaneAction(String string) {
                    this(string, string);
                }

                FilePaneAction(String string, String string2) {
                    super(string);
                    this.putValue("ActionCommandKey", string2);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)this.getValue("ActionCommandKey");
                    if (string == FilePane.ACTION_CANCEL) {
                        if (FilePane.this.editFile != null) {
                            FilePane.this.cancelEdit();
                        } else {
                            FilePane.this.getFileChooser().cancelSelection();
                        }
                    } else if (string == FilePane.ACTION_EDIT_FILE_NAME) {
                        JFileChooser jFileChooser = FilePane.this.getFileChooser();
                        int n = FilePane.this.listSelectionModel.getMinSelectionIndex();
                        if (!(n < 0 || FilePane.this.editFile != null || jFileChooser.isMultiSelectionEnabled() && jFileChooser.getSelectedFiles().length > 1)) {
                            FilePane.this.editFileName(n);
                        }
                    } else if (string == FilePane.ACTION_REFRESH) {
                        FilePane.this.getFileChooser().rescanCurrentDirectory();
                    }
                }

                public boolean isEnabled() {
                    String string = (String)this.getValue("ActionCommandKey");
                    if (string == FilePane.ACTION_CANCEL) {
                        return FilePane.this.getFileChooser().isEnabled();
                    }
                    if (string == FilePane.ACTION_EDIT_FILE_NAME) {
                        return !FilePane.this.readOnly && FilePane.this.getFileChooser().isEnabled();
                    }
                    return true;
                }
            }
            arrayList.add(new FilePaneAction(ACTION_CANCEL));
            arrayList.add(new FilePaneAction(ACTION_EDIT_FILE_NAME));
            arrayList.add(new FilePaneAction(this.refreshActionLabelText, ACTION_REFRESH));
            Action action = this.fileChooserUIAccessor.getApproveSelectionAction();
            if (action != null) {
                arrayList.add(action);
            }
            if ((action = this.fileChooserUIAccessor.getChangeToParentDirectoryAction()) != null) {
                arrayList.add(action);
            }
            if ((action = this.getNewFolderAction()) != null) {
                arrayList.add(action);
            }
            if ((action = this.getViewTypeAction(0)) != null) {
                arrayList.add(action);
            }
            if ((action = this.getViewTypeAction(1)) != null) {
                arrayList.add(action);
            }
            this.actions = arrayList.toArray(new Action[arrayList.size()]);
        }
        return this.actions;
    }

    protected void createActionMap() {
        FilePane.addActionsToMap(super.getActionMap(), this.getActions());
    }

    public static void addActionsToMap(ActionMap actionMap, Action[] actionArray) {
        if (actionMap != null && actionArray != null) {
            for (int i = 0; i < actionArray.length; ++i) {
                Action action = actionArray[i];
                String string = (String)action.getValue("ActionCommandKey");
                if (string == null) {
                    string = (String)action.getValue("Name");
                }
                actionMap.put(string, action);
            }
        }
    }

    private void updateListRowCount(JList jList) {
        if (this.smallIconsView) {
            jList.setVisibleRowCount(this.getModel().getSize() / 3);
        } else {
            jList.setVisibleRowCount(-1);
        }
    }

    public JPanel createList() {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JFileChooser jFileChooser = this.getFileChooser();
        final JList jList = new JList(){

            public int getNextMatch(String string, int n, Position.Bias bias) {
                ListModel listModel = this.getModel();
                int n2 = listModel.getSize();
                if (string == null || n < 0 || n >= n2) {
                    throw new IllegalArgumentException();
                }
                boolean bl = bias == Position.Bias.Backward;
                int n3 = n;
                while (bl ? n3 >= 0 : n3 < n2) {
                    String string2 = jFileChooser.getName((File)listModel.getElementAt(n3));
                    if (string2.regionMatches(true, 0, string, 0, string.length())) {
                        return n3;
                    }
                    n3 += bl ? -1 : 1;
                }
                return -1;
            }
        };
        jList.setCellRenderer(new FileRenderer());
        jList.setLayoutOrientation(1);
        jList.putClientProperty("List.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            jList.addFocusListener(repaintListener);
        }
        this.updateListRowCount(jList);
        this.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                FilePane.this.updateListRowCount(jList);
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                FilePane.this.updateListRowCount(jList);
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                if (FilePane.this.isShowing()) {
                    FilePane.this.clearSelection();
                }
                FilePane.this.updateListRowCount(jList);
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            jList.setSelectionMode(2);
        } else {
            jList.setSelectionMode(0);
        }
        jList.setModel(this.getModel());
        jList.addListSelectionListener(this.createListSelectionListener());
        jList.addMouseListener(this.getMouseHandler());
        this.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                File file;
                int n;
                int n2 = listDataEvent.getIndex0();
                if (n2 == (n = listDataEvent.getIndex1()) && (file = (File)FilePane.this.getModel().getElementAt(n2)).equals(FilePane.this.newFolderFile)) {
                    new DelayedSelectionUpdater(file);
                    FilePane.this.newFolderFile = null;
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jList);
        if (this.listViewBackground != null) {
            jList.setBackground(this.listViewBackground);
        }
        if (this.listViewBorder != null) {
            jScrollPane.setBorder(this.listViewBorder);
        }
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public JPanel createDetailsView() {
        Serializable serializable;
        final JFileChooser jFileChooser = this.getFileChooser();
        Locale locale = jFileChooser.getLocale();
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", locale);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", locale);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", locale);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", locale);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", locale);
        JPanel jPanel = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(jFileChooser);
        final JTable jTable = new JTable(detailsTableModel){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (keyEvent.getKeyCode() == 27 && this.getCellEditor() == null) {
                    jFileChooser.dispatchEvent(keyEvent);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JLabel) {
                    if (this.convertColumnIndexToModel(n2) == 1) {
                        ((JLabel)component).setHorizontalAlignment(4);
                    } else {
                        ((JLabel)component).setHorizontalAlignment(10);
                    }
                }
                return component;
            }
        };
        jTable.setComponentOrientation(jFileChooser.getComponentOrientation());
        jTable.setAutoResizeMode(0);
        jTable.setShowGrid(false);
        jTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        Font font = this.list.getFont();
        jTable.setFont(font);
        jTable.setIntercellSpacing(new Dimension(0, 0));
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[5];
        for (int i = 0; i < 5; ++i) {
            tableColumnArray[i] = tableColumnModel.getColumn(i);
            tableColumnArray[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
        }
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string == null || !string.startsWith("Windows")) {
            tableColumnModel.removeColumn(tableColumnArray[2]);
            tableColumnModel.removeColumn(tableColumnArray[4]);
        }
        DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(jFileChooser);
        jTable.setDefaultRenderer(File.class, detailsTableCellRenderer);
        jTable.setDefaultRenderer(Date.class, detailsTableCellRenderer);
        jTable.setDefaultRenderer(Object.class, detailsTableCellRenderer);
        jTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (!this.readOnly) {
            serializable = new JTextField();
            ((Component)serializable).addFocusListener(this.editorFocusListener);
            tableColumnArray[0].setCellEditor(new DefaultCellEditor((JTextField)serializable, (JTextField)serializable, jFileChooser){
                final /* synthetic */ JTextField val$tf;
                final /* synthetic */ JFileChooser val$chooser;
                {
                    this.val$tf = jTextField2;
                    this.val$chooser = jFileChooser;
                    super(jTextField);
                }

                public boolean isCellEditable(EventObject eventObject) {
                    if (!SwingUtilities2.DRAG_FIX && eventObject instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)eventObject;
                        int n = jTable.rowAtPoint(mouseEvent.getPoint());
                        return mouseEvent.getClickCount() == 1 && jTable.isRowSelected(n);
                    }
                    return super.isCellEditable(eventObject);
                }

                public Component getTableCellEditorComponent(JTable jTable2, Object object, boolean bl, int n, int n2) {
                    Component component = super.getTableCellEditorComponent(jTable2, object, bl, n, n2);
                    if (object instanceof File) {
                        this.val$tf.setText(this.val$chooser.getName((File)object));
                        if (!SwingUtilities2.DRAG_FIX) {
                            this.val$tf.requestFocus();
                        }
                        this.val$tf.selectAll();
                    }
                    return component;
                }
            });
        }
        jTable.addMouseListener(this.getMouseHandler());
        jTable.putClientProperty("Table.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            jTable.addFocusListener(repaintListener);
        }
        serializable = SwingUtilities.getUIActionMap(jTable);
        ((ActionMap)serializable).remove("selectNextRowCell");
        ((ActionMap)serializable).remove("selectPreviousRowCell");
        ((ActionMap)serializable).remove("selectNextColumnCell");
        ((ActionMap)serializable).remove("selectPreviousColumnCell");
        jTable.setFocusTraversalKeys(0, null);
        jTable.setFocusTraversalKeys(1, null);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setComponentOrientation(jFileChooser.getComponentOrientation());
        LookAndFeel.installColors(jScrollPane.getViewport(), "Table.background", "Table.foreground");
        jScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                FilePane.this.fixNameColumnWidth(jScrollPane.getViewport().getSize().width);
                jScrollPane.removeComponentListener(this);
            }
        });
        jScrollPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JScrollPane jScrollPane = (JScrollPane)mouseEvent.getComponent();
                JTable jTable = (JTable)jScrollPane.getViewport().getView();
                if (!mouseEvent.isShiftDown() || jTable.getSelectionModel().getSelectionMode() == 0) {
                    FilePane.this.clearSelection();
                    TableCellEditor tableCellEditor = jTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                }
            }
        });
        if (this.listViewBackground != null) {
            jTable.setBackground(this.listViewBackground);
        }
        if (this.listViewBorder != null) {
            jScrollPane.setBorder(this.listViewBorder);
        }
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void fixNameColumnWidth(int n) {
        TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
        int n2 = this.detailsTable.getPreferredSize().width;
        if (n2 < n) {
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n - n2);
        }
    }

    public ListSelectionListener createListSelectionListener() {
        return this.fileChooserUIAccessor.createListSelectionListener();
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int n) {
        this.lastIndex = n;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int n) {
        File file = this.getFileChooser().getCurrentDirectory();
        if (this.readOnly || !FilePane.canWrite(file)) {
            return;
        }
        this.ensureIndexIsVisible(n);
        switch (this.viewType) {
            case 0: {
                this.editFile = (File)this.getModel().getElementAt(n);
                Rectangle rectangle = this.list.getCellBounds(n, n);
                if (this.editCell == null) {
                    this.editCell = new JTextField();
                    this.editCell.addActionListener(new EditActionListener());
                    this.editCell.addFocusListener(this.editorFocusListener);
                    this.editCell.setNextFocusableComponent(this.list);
                }
                this.list.add(this.editCell);
                this.editCell.setText(this.getFileChooser().getName(this.editFile));
                ComponentOrientation componentOrientation = this.list.getComponentOrientation();
                this.editCell.setComponentOrientation(componentOrientation);
                if (componentOrientation.isLeftToRight()) {
                    this.editCell.setBounds(this.editX + rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
                } else {
                    this.editCell.setBounds(rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
                }
                this.editCell.requestFocus();
                this.editCell.selectAll();
                break;
            }
            case 1: {
                this.detailsTable.editCellAt(n, 0);
            }
        }
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser jFileChooser = this.getFileChooser();
            String string = jFileChooser.getName(this.editFile);
            String string2 = this.editFile.getName();
            String string3 = this.editCell.getText().trim();
            if (!string3.equals(string)) {
                FileSystemView fileSystemView;
                File file;
                int n;
                String string4 = string3;
                int n2 = string2.length();
                if (n2 > (n = string.length()) && string2.charAt(n) == '.') {
                    string4 = string3 + string2.substring(n);
                }
                if (!(file = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), string4)).exists() && this.getModel().renameFile(this.editFile, file) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file)) {
                    if (jFileChooser.isMultiSelectionEnabled()) {
                        jFileChooser.setSelectedFiles(new File[]{file});
                    } else {
                        jFileChooser.setSelectedFile(file);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public Action getNewFolderAction() {
        if (!this.readOnly && this.newFolderAction == null) {
            this.newFolderAction = new AbstractAction(this.newFolderActionLabelText){
                private Action basicNewFolderAction;
                {
                    this.putValue("ActionCommandKey", FilePane.ACTION_NEW_FOLDER);
                    File file = FilePane.this.getFileChooser().getCurrentDirectory();
                    if (file != null) {
                        this.setEnabled(FilePane.canWrite(file));
                    }
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.basicNewFolderAction == null) {
                        this.basicNewFolderAction = FilePane.this.fileChooserUIAccessor.getNewFolderAction();
                    }
                    JFileChooser jFileChooser = FilePane.this.getFileChooser();
                    File file = jFileChooser.getSelectedFile();
                    this.basicNewFolderAction.actionPerformed(actionEvent);
                    File file2 = jFileChooser.getSelectedFile();
                    if (file2 != null && !file2.equals(file) && file2.isDirectory()) {
                        FilePane.this.newFolderFile = file2;
                    }
                }
            };
        }
        return this.newFolderAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] objectArray = this.getFileChooser().getSelectedFiles();
            Object[] objectArray2 = this.list.getSelectedValues();
            this.listSelectionModel.setValueIsAdjusting(true);
            try {
                int n;
                int n2 = this.listSelectionModel.getLeadSelectionIndex();
                int n3 = this.listSelectionModel.getAnchorSelectionIndex();
                Arrays.sort(objectArray);
                Arrays.sort(objectArray2);
                int n4 = 0;
                int n5 = 0;
                while (n4 < objectArray.length && n5 < objectArray2.length) {
                    int n6;
                    n = ((File)objectArray[n4]).compareTo((File)objectArray2[n5]);
                    if (n < 0) {
                        n6 = this.getModel().indexOf(objectArray[n4]);
                        this.listSelectionModel.addSelectionInterval(n6, n6);
                        ++n4;
                        continue;
                    }
                    if (n > 0) {
                        n6 = this.getModel().indexOf(objectArray2[n5]);
                        this.listSelectionModel.removeSelectionInterval(n6, n6);
                        ++n5;
                        continue;
                    }
                    ++n4;
                    ++n5;
                }
                while (n4 < objectArray.length) {
                    n = this.getModel().indexOf(objectArray[n4]);
                    this.listSelectionModel.addSelectionInterval(n, n);
                    ++n4;
                }
                while (n5 < objectArray2.length) {
                    n = this.getModel().indexOf(objectArray2[n5]);
                    this.listSelectionModel.removeSelectionInterval(n, n);
                    ++n5;
                }
                if (!(this.listSelectionModel instanceof DefaultListSelectionModel)) return;
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(n2);
                ((DefaultListSelectionModel)this.listSelectionModel).setAnchorSelectionIndex(n3);
                return;
            }
            finally {
                this.listSelectionModel.setValueIsAdjusting(false);
            }
        } else {
            int n;
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && (n = this.getModel().indexOf(file)) >= 0) {
                this.listSelectionModel.setSelectionInterval(n, n);
                this.ensureIndexIsVisible(n);
                return;
            } else {
                this.clearSelection();
            }
        }
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.ensureIndexIsVisible(0);
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            if (!this.readOnly) {
                this.getNewFolderAction().setEnabled(FilePane.canWrite(file));
            }
            this.fileChooserUIAccessor.getChangeToParentDirectoryAction().setEnabled(!fileSystemView.isRoot(file));
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (this.viewType == -1) {
            this.setViewType(0);
        }
        if ((string = propertyChangeEvent.getPropertyName()).equals("SelectedFileChangedProperty")) {
            this.doSelectedFileChanged(propertyChangeEvent);
        } else if (string.equals("SelectedFilesChangedProperty")) {
            this.doSelectedFilesChanged(propertyChangeEvent);
        } else if (string.equals("directoryChanged")) {
            this.doDirectoryChanged(propertyChangeEvent);
        } else if (string.equals("fileFilterChanged")) {
            this.doFilterChanged(propertyChangeEvent);
        } else if (string.equals("fileSelectionChanged")) {
            this.doFileSelectionModeChanged(propertyChangeEvent);
        } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
            this.doMultiSelectionChanged(propertyChangeEvent);
        } else if (string.equals("CancelSelection")) {
            this.applyEdit();
        } else if (string.equals("componentOrientation")) {
            ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                jFileChooser.applyComponentOrientation(componentOrientation);
            }
            if (this.detailsTable != null) {
                this.detailsTable.setComponentOrientation(componentOrientation);
                this.detailsTable.getParent().getParent().setComponentOrientation(componentOrientation);
            }
        }
    }

    private void ensureIndexIsVisible(int n) {
        if (n >= 0) {
            if (this.list != null) {
                this.list.ensureIndexIsVisible(n);
            }
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(n, 0, true));
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.ensureIndexIsVisible(this.getModel().indexOf(file));
    }

    public void rescanCurrentDirectory() {
        this.getModel().validateFileCache();
    }

    public void clearSelection() {
        if (this.listSelectionModel != null) {
            this.listSelectionModel.clearSelection();
            if (this.listSelectionModel instanceof DefaultListSelectionModel) {
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(0);
                ((DefaultListSelectionModel)this.listSelectionModel).setAnchorSelectionIndex(0);
            }
        }
    }

    public JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu(this.viewMenuLabelText);
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < 2; ++i) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ViewTypeAction(i));
                buttonGroup.add(jRadioButtonMenuItem);
                this.viewMenu.add(jRadioButtonMenuItem);
            }
            this.updateViewMenu();
        }
        return this.viewMenu;
    }

    private void updateViewMenu() {
        if (this.viewMenu != null) {
            Component[] componentArray = this.viewMenu.getMenuComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                JRadioButtonMenuItem jRadioButtonMenuItem;
                if (!(componentArray[i] instanceof JRadioButtonMenuItem) || ((ViewTypeAction)(jRadioButtonMenuItem = (JRadioButtonMenuItem)componentArray[i]).getAction()).viewType != this.viewType) continue;
                jRadioButtonMenuItem.setSelected(true);
            }
        }
    }

    public JPopupMenu getComponentPopupMenu() {
        JPopupMenu jPopupMenu = this.getFileChooser().getComponentPopupMenu();
        if (jPopupMenu != null) {
            return jPopupMenu;
        }
        JMenu jMenu = this.getViewMenu();
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
            if (jMenu != null) {
                this.contextMenu.add(jMenu);
                if (this.listViewWindowsStyle) {
                    this.contextMenu.addSeparator();
                }
            }
            ActionMap actionMap = this.getActionMap();
            Action action = actionMap.get(ACTION_REFRESH);
            Action action2 = actionMap.get(ACTION_NEW_FOLDER);
            if (action != null) {
                this.contextMenu.add(action);
                if (this.listViewWindowsStyle && action2 != null) {
                    this.contextMenu.addSeparator();
                }
            }
            if (action2 != null) {
                this.contextMenu.add(action2);
            }
        }
        if (jMenu != null) {
            jMenu.getPopupMenu().setInvoker(jMenu);
        }
        return this.contextMenu;
    }

    protected Handler getMouseHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected boolean isDirectorySelected() {
        return this.fileChooserUIAccessor.isDirectorySelected();
    }

    protected File getDirectory() {
        return this.fileChooserUIAccessor.getDirectory();
    }

    private Component findChildComponent(Container container, Class clazz) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component;
            Component component2 = container.getComponent(i);
            if (clazz.isInstance(component2)) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = this.findChildComponent((Container)component2, clazz)) == null) continue;
            return component;
        }
        return null;
    }

    public static boolean canWrite(File file) {
        boolean bl = false;
        if (file != null) {
            try {
                bl = file.canWrite();
            }
            catch (AccessControlException accessControlException) {
                bl = false;
            }
        }
        return bl;
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        File editFile;

        DelayedSelectionUpdater() {
            this(null);
        }

        DelayedSelectionUpdater(File file) {
            this.editFile = file;
            if (FilePane.this.isShowing()) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            FilePane.this.setFileSelected();
            if (this.editFile != null) {
                FilePane.this.editFileName(FilePane.this.getModel().indexOf(this.editFile));
                this.editFile = null;
            }
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (this.getHorizontalAlignment() == 10) {
                n3 = Math.min(n3, this.getPreferredSize().width + 4);
            } else {
                n -= 4;
            }
            super.setBounds(n, n2, n3, n4);
        }

        public Insets getInsets(Insets insets) {
            insets = super.getInsets(insets);
            insets.left += 4;
            insets.right += 4;
            return insets;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.convertColumnIndexToModel(n2) != 0 || FilePane.this.listViewWindowsStyle && !jTable.isFocusOwner()) {
                bl = false;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public void setValue(Object object) {
            this.setIcon(null);
            if (object instanceof File) {
                File file = (File)object;
                String string = this.chooser.getName(file);
                this.setText(string);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (object instanceof Date) {
                this.setText(object == null ? "" : this.df.format((Date)object));
            } else {
                super.setValue(object);
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        DetailsTableModel(JFileChooser jFileChooser) {
            this.columnNames = new String[]{FilePane.this.fileNameHeaderText, FilePane.this.fileSizeHeaderText, FilePane.this.fileTypeHeaderText, FilePane.this.fileDateHeaderText, FilePane.this.fileAttrHeaderText};
            this.chooser = jFileChooser;
            this.listModel = FilePane.this.getModel();
            this.listModel.addListDataListener(this);
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return File.class;
                }
                case 3: {
                    return Date.class;
                }
            }
            return super.getColumnClass(n);
        }

        public Object getValueAt(int n, int n2) {
            File file = (File)this.listModel.getElementAt(n);
            switch (n2) {
                case 0: {
                    return file;
                }
                case 1: {
                    if (!file.exists() || file.isDirectory()) {
                        return null;
                    }
                    if (FilePane.this.listViewWindowsStyle) {
                        return file.length() / 1024L + 1L + "KB";
                    }
                    long l = file.length() / 1024L;
                    if (l < 1024L) {
                        return (l == 0L ? 1L : l) + " KB";
                    }
                    if ((l /= 1024L) < 1024L) {
                        return l + " MB";
                    }
                    return (l /= 1024L) + " GB";
                }
                case 2: {
                    if (!file.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(file);
                }
                case 3: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    long l = file.lastModified();
                    return l == 0L ? null : new Date(l);
                }
                case 4: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    String string = "";
                    try {
                        if (!file.canWrite()) {
                            string = string + "R";
                        }
                    }
                    catch (AccessControlException accessControlException) {
                        // empty catch block
                    }
                    if (file.isHidden()) {
                        string = string + "H";
                    }
                    return string;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                JFileChooser jFileChooser = FilePane.this.getFileChooser();
                File file = (File)this.getValueAt(n, n2);
                if (file != null) {
                    String string = jFileChooser.getName(file);
                    String string2 = file.getName();
                    String string3 = ((String)object).trim();
                    if (!string3.equals(string)) {
                        FileSystemView fileSystemView;
                        File file2;
                        int n3;
                        String string4 = string3;
                        int n4 = string2.length();
                        if (n4 > (n3 = string.length()) && string2.charAt(n3) == '.') {
                            string4 = string3 + string2.substring(n3);
                        }
                        if (!(file2 = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(file.getParentFile(), string4)).exists() && FilePane.this.getModel().renameFile(file, file2) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file2)) {
                            if (jFileChooser.isMultiSelectionEnabled()) {
                                jFileChooser.setSelectedFiles(new File[]{file2});
                            } else {
                                jFileChooser.setSelectedFile(file2);
                            }
                        }
                    }
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            File file = FilePane.this.getFileChooser().getCurrentDirectory();
            return !FilePane.this.readOnly && n2 == 0 && FilePane.canWrite(file);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilePane.this.applyEdit();
        }
    }

    public static interface FileChooserUIAccessor {
        public JFileChooser getFileChooser();

        public BasicDirectoryModel getModel();

        public JPanel createList();

        public JPanel createDetailsView();

        public boolean isDirectorySelected();

        public File getDirectory();

        public Action getApproveSelectionAction();

        public Action getChangeToParentDirectoryAction();

        public Action getNewFolderAction();

        public MouseListener createDoubleClickListener(JList var1);

        public ListSelectionListener createListSelectionListener();
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (FilePane.this.listViewWindowsStyle && !jList.isFocusOwner()) {
                bl = false;
            }
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            File file = (File)object;
            String string = FilePane.this.getFileChooser().getName(file);
            this.setText(string);
            this.setFont(jList.getFont());
            Icon icon = FilePane.this.getFileChooser().getIcon(file);
            if (icon != null) {
                this.setIcon(icon);
                if (bl) {
                    FilePane.this.editX = icon.getIconWidth() + 4;
                }
            } else if (FilePane.this.getFileChooser().getFileSystemView().isTraversable(file).booleanValue()) {
                this.setText(string + File.separator);
            }
            return this;
        }
    }

    private class Handler
    implements MouseListener {
        private MouseListener doubleClickListener;

        private Handler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JComponent jComponent;
            int n;
            JComponent jComponent2 = (JComponent)mouseEvent.getSource();
            if (jComponent2 instanceof JList) {
                n = SwingUtilities2.loc2IndexFileList(FilePane.this.list, mouseEvent.getPoint());
            } else if (jComponent2 instanceof JTable) {
                jComponent = (JTable)jComponent2;
                Point point = mouseEvent.getPoint();
                n = ((JTable)jComponent).rowAtPoint(point);
                if (SwingUtilities2.pointOutsidePrefSize((JTable)jComponent, n, ((JTable)jComponent).columnAtPoint(point), point)) {
                    return;
                }
                if (n >= 0 && FilePane.this.list != null && FilePane.this.listSelectionModel.isSelectedIndex(n)) {
                    Rectangle rectangle = FilePane.this.list.getCellBounds(n, n);
                    mouseEvent = new MouseEvent(FilePane.this.list, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), rectangle.x + 1, rectangle.y + rectangle.height / 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                }
            } else {
                return;
            }
            if (n >= 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                jComponent = FilePane.this.getFileChooser();
                if (mouseEvent.getClickCount() == 1 && jComponent2 instanceof JList) {
                    if ((!((JFileChooser)jComponent).isMultiSelectionEnabled() || ((JFileChooser)jComponent).getSelectedFiles().length <= 1) && n >= 0 && FilePane.this.listSelectionModel.isSelectedIndex(n) && FilePane.this.getEditIndex() == n && FilePane.this.editFile == null) {
                        FilePane.this.editFileName(n);
                    } else if (n >= 0) {
                        FilePane.this.setEditIndex(n);
                    } else {
                        FilePane.this.resetEditIndex();
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    FilePane.this.resetEditIndex();
                }
            }
            if (this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseClicked(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent instanceof JTable) {
                boolean bl;
                TransferHandler transferHandler;
                JTable jTable = (JTable)mouseEvent.getSource();
                TransferHandler transferHandler2 = FilePane.this.getFileChooser().getTransferHandler();
                if (transferHandler2 != (transferHandler = jTable.getTransferHandler())) {
                    jTable.setTransferHandler(transferHandler2);
                }
                if ((bl = FilePane.this.getFileChooser().getDragEnabled()) != jTable.getDragEnabled()) {
                    jTable.setDragEnabled(bl);
                }
            } else if (jComponent instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseEntered(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseExited(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseReleased(mouseEvent);
            }
        }

        private MouseListener getDoubleClickListener() {
            if (this.doubleClickListener == null && FilePane.this.list != null) {
                this.doubleClickListener = FilePane.this.fileChooserUIAccessor.createDoubleClickListener(FilePane.this.list);
            }
            return this.doubleClickListener;
        }
    }

    class ViewTypeAction
    extends AbstractAction {
        private int viewType;

        ViewTypeAction(int n) {
            String string;
            super(FilePane.this.viewTypeActionNames[n]);
            this.viewType = n;
            switch (n) {
                case 0: {
                    string = FilePane.ACTION_VIEW_LIST;
                    break;
                }
                case 1: {
                    string = FilePane.ACTION_VIEW_DETAILS;
                    break;
                }
                default: {
                    string = (String)this.getValue("Name");
                }
            }
            this.putValue("ActionCommandKey", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilePane.this.setViewType(this.viewType);
        }
    }
}

