/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.security.Provider;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.SunProvider;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public final class Krb5MechFactory
implements MechanismFactory {
    private static final boolean DEBUG = Krb5Util.DEBUG;
    static final Provider PROVIDER = new SunProvider();
    static final Oid GSS_KRB5_MECH_OID = Krb5MechFactory.createOid("1.2.840.113554.1.2.2");
    static final Oid NT_GSS_KRB5_PRINCIPAL = Krb5MechFactory.createOid("1.2.840.113554.1.2.2.1");
    private static Oid[] nameTypes = new Oid[]{GSSName.NT_USER_NAME, GSSName.NT_HOSTBASED_SERVICE, GSSName.NT_EXPORT_NAME, NT_GSS_KRB5_PRINCIPAL};

    public GSSNameSpi getNameElement(String string, Oid oid) throws GSSException {
        return Krb5NameElement.getInstance(string, oid);
    }

    public GSSNameSpi getNameElement(byte[] byArray, Oid oid) throws GSSException {
        return Krb5NameElement.getInstance(new String(byArray), oid);
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi gSSNameSpi, int n, int n2, int n3) throws GSSException {
        if (gSSNameSpi != null && !(gSSNameSpi instanceof Krb5NameElement)) {
            gSSNameSpi = Krb5NameElement.getInstance(((Object)gSSNameSpi).toString(), gSSNameSpi.getStringNameType());
        }
        Destroyable destroyable = null;
        if (n3 == 1 || n3 == 0) {
            destroyable = Krb5InitCredential.getInstance((Krb5NameElement)gSSNameSpi, n);
            this.checkInitCredPermission((Krb5NameElement)destroyable.getName());
        } else if (n3 == 2) {
            destroyable = Krb5AcceptCredential.getInstance((Krb5NameElement)gSSNameSpi);
            this.checkAcceptCredPermission((Krb5NameElement)destroyable.getName(), gSSNameSpi);
        } else {
            throw new GSSException(11, -1, "Unknown usage mode requested");
        }
        return destroyable;
    }

    private void checkInitCredPermission(Krb5NameElement krb5NameElement) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string = krb5NameElement.getKrb5PrincipalName().getRealmAsString();
            String string2 = new String("krbtgt/" + string + '@' + string);
            ServicePermission servicePermission = new ServicePermission(string2, "initiate");
            try {
                securityManager.checkPermission(servicePermission);
            }
            catch (SecurityException securityException) {
                if (DEBUG) {
                    System.out.println("Permission to initiatekerberos init credential" + securityException.getMessage());
                }
                throw securityException;
            }
        }
    }

    private void checkAcceptCredPermission(Krb5NameElement krb5NameElement, GSSNameSpi gSSNameSpi) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ServicePermission servicePermission = new ServicePermission(krb5NameElement.toString(), "accept");
            try {
                securityManager.checkPermission(servicePermission);
            }
            catch (SecurityException securityException) {
                SecurityException securityException2;
                if (gSSNameSpi == null) {
                    securityException2 = new SecurityException("No permission to acquire Kerberos accept credential");
                }
                throw securityException2;
            }
        }
    }

    public GSSContextSpi getMechanismContext(GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n) throws GSSException {
        return new Krb5Context((Krb5NameElement)gSSNameSpi, (Krb5CredElement)gSSCredentialSpi, n);
    }

    public GSSContextSpi getMechanismContext(GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        return new Krb5Context((Krb5CredElement)gSSCredentialSpi);
    }

    public GSSContextSpi getMechanismContext(byte[] byArray) throws GSSException {
        return new Krb5Context(byArray);
    }

    public final Oid getMechanismOid() {
        return GSS_KRB5_MECH_OID;
    }

    public Provider getProvider() {
        return PROVIDER;
    }

    public Oid[] getNameTypes() {
        return nameTypes;
    }

    private static Oid createOid(String string) {
        Oid oid = null;
        try {
            oid = new Oid(string);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return oid;
    }
}

