/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.awt.windows.WPrinterJob;
import sun.print.AttributeUpdater;
import sun.print.ServiceNotifier;
import sun.print.SunAlternateMedia;
import sun.print.SunPrinterJobService;
import sun.print.Win32MediaSize;
import sun.print.Win32MediaTray;
import sun.print.Win32PrintJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Win32PrintService
implements PrintService,
AttributeUpdater,
SunPrinterJobService {
    public static MediaSize[] predefMedia;
    private static final DocFlavor[] supportedFlavors;
    private static final Class[] serviceAttrCats;
    private static Class[] otherAttrCats;
    public static final MediaSizeName[] dmPaperToPrintService;
    private static final MediaTray[] dmPaperBinToPrintService;
    private static int DM_PAPERSIZE;
    private static int DM_PRINTQUALITY;
    private static int DM_YRESOLUTION;
    private static final int DMRES_MEDIUM = -3;
    private static final int DMRES_HIGH = -4;
    private static final int DMORIENT_LANDSCAPE = 2;
    private static final int DMDUP_VERTICAL = 2;
    private static final int DMDUP_HORIZONTAL = 3;
    private static final int DMCOLLATE_TRUE = 1;
    private static final int DMPAPER_A2 = 66;
    private static final int DMPAPER_A6 = 70;
    private static final int DMPAPER_B6_JIS = 88;
    private static final int DEVCAP_COLOR = 1;
    private static final int DEVCAP_DUPLEX = 2;
    private static final int DEVCAP_COLLATE = 4;
    private static final int DEVCAP_QUALITY = 8;
    private static final int DEVCAP_POSTSCRIPT = 16;
    private String printer;
    private PrinterName name;
    private String port;
    private transient PrintServiceAttributeSet lastSet;
    private transient ServiceNotifier notifier = null;
    private MediaSizeName[] mediaSizeNames;
    private MediaPrintableArea[] mediaPrintables;
    private MediaTray[] mediaTrays;
    private PrinterResolution[] printRes;
    private int nCopies;
    private int prnCaps;
    private int[] defaultSettings;
    private boolean gotTrays;
    private boolean gotCopies;
    private boolean mediaInitialized;
    private ArrayList idList;
    private MediaSize[] mediaSizes;

    Win32PrintService(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = string;
        this.mediaInitialized = false;
        this.gotTrays = false;
        this.gotCopies = false;
        this.printRes = null;
        this.prnCaps = 0;
        this.defaultSettings = null;
        this.port = null;
    }

    @Override
    public String getName() {
        return this.printer;
    }

    private PrinterName getPrinterName() {
        if (this.name == null) {
            this.name = new PrinterName(this.printer, null);
        }
        return this.name;
    }

    public MediaSizeName findWin32Media(int n) {
        if (n >= 1 && n <= dmPaperToPrintService.length) {
            switch (n) {
                case 66: {
                    return MediaSizeName.ISO_A2;
                }
                case 70: {
                    return MediaSizeName.ISO_A6;
                }
                case 88: {
                    return MediaSizeName.JIS_B6;
                }
            }
            return dmPaperToPrintService[n - 1];
        }
        return null;
    }

    private boolean addToUniqueList(ArrayList arrayList, MediaSizeName mediaSizeName) {
        for (int i = 0; i < arrayList.size(); ++i) {
            MediaSizeName mediaSizeName2 = (MediaSizeName)arrayList.get(i);
            if (mediaSizeName2 != mediaSizeName) continue;
            return false;
        }
        arrayList.add(mediaSizeName);
        return true;
    }

    private synchronized void initMedia() {
        int n;
        if (this.mediaInitialized) {
            return;
        }
        this.mediaInitialized = true;
        int[] nArray = this.getAllMediaIDs(this.printer, this.getPort());
        if (nArray == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<MediaPrintableArea> arrayList2 = new ArrayList<MediaPrintableArea>();
        boolean bl = false;
        this.idList = new ArrayList();
        for (n = 0; n < nArray.length; ++n) {
            this.idList.add(new Integer(nArray[n]));
        }
        this.mediaSizes = this.getMediaSizes(this.idList, nArray);
        for (n = 0; n < this.idList.size(); ++n) {
            boolean bl2;
            MediaSizeName mediaSizeName = this.findWin32Media((Integer)this.idList.get(n));
            if (mediaSizeName == null && this.idList.size() == this.mediaSizes.length) {
                mediaSizeName = this.mediaSizes[n].getMediaSizeName();
            }
            if (mediaSizeName == null || !(bl2 = this.addToUniqueList(arrayList, mediaSizeName)) || bl) continue;
            float[] fArray = this.getMediaPrintableArea(this.printer, (Integer)this.idList.get(n));
            if (fArray != null) {
                try {
                    MediaPrintableArea mediaPrintableArea = new MediaPrintableArea(fArray[0], fArray[1], fArray[2], fArray[3], 25400);
                    arrayList2.add(mediaPrintableArea);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            if (n != 0) continue;
            bl = true;
        }
        this.mediaSizeNames = new MediaSizeName[arrayList.size()];
        arrayList.toArray(this.mediaSizeNames);
        this.mediaPrintables = new MediaPrintableArea[arrayList2.size()];
        arrayList2.toArray(this.mediaPrintables);
    }

    private synchronized MediaTray[] getMediaTrays() {
        if (this.gotTrays) {
            return this.mediaTrays;
        }
        this.gotTrays = true;
        String string = this.getPort();
        int[] nArray = this.getAllMediaTrays(this.printer, string);
        String[] stringArray = this.getAllMediaTrayNames(this.printer, string);
        if (nArray == null || stringArray == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            ++n;
        }
        MediaTray[] mediaTrayArray = new MediaTray[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 <= 0) continue;
            mediaTrayArray[n2++] = n3 > dmPaperBinToPrintService.length || dmPaperBinToPrintService[n3 - 1] == null ? new Win32MediaTray(n3, stringArray[i]) : dmPaperBinToPrintService[n3 - 1];
        }
        return mediaTrayArray;
    }

    private boolean isSameSize(float f, float f2, float f3, float f4) {
        float f5 = f - f3;
        float f6 = f2 - f4;
        float f7 = f - f4;
        float f8 = f2 - f3;
        return Math.abs(f5) <= 1.0f && Math.abs(f6) <= 1.0f || Math.abs(f7) <= 1.0f && Math.abs(f8) <= 1.0f;
    }

    public MediaSizeName findMatchingMediaSizeNameMM(float f, float f2) {
        if (predefMedia != null) {
            for (int i = 0; i < predefMedia.length; ++i) {
                if (predefMedia[i] == null || !this.isSameSize(predefMedia[i].getX(1000), predefMedia[i].getY(1000), f, f2)) continue;
                return predefMedia[i].getMediaSizeName();
            }
        }
        return null;
    }

    private MediaSize[] getMediaSizes(ArrayList arrayList, int[] nArray) {
        String string = this.getPort();
        int[] nArray2 = this.getAllMediaSizes(this.printer, string);
        String[] stringArray = this.getAllMediaNames(this.printer, string);
        MediaSizeName mediaSizeName = null;
        MediaSize mediaSize = null;
        if (nArray2 == null || stringArray == null) {
            return null;
        }
        int n = nArray2.length / 2;
        ArrayList<MediaSize> arrayList2 = new ArrayList<MediaSize>();
        for (int i = 0; i < n; ++i) {
            block10: {
                Serializable serializable;
                float f = nArray2[i * 2] / 10;
                float f2 = nArray2[i * 2 + 1] / 10;
                if (f <= 0.0f || f2 <= 0.0f) {
                    if (n == nArray.length) {
                        serializable = new Integer(nArray[i]);
                        arrayList.remove(arrayList.indexOf(serializable));
                    }
                } else {
                    mediaSizeName = this.findMatchingMediaSizeNameMM(f, f2);
                    if (mediaSizeName != null) {
                        mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                    }
                    if (mediaSize != null) {
                        arrayList2.add(mediaSize);
                    } else {
                        serializable = new Win32MediaSize(stringArray[i]);
                        try {
                            mediaSize = new MediaSize(f, f2, 1000, (MediaSizeName)serializable);
                            arrayList2.add(mediaSize);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (n != nArray.length) break block10;
                            Integer n2 = new Integer(nArray[i]);
                            arrayList.remove(arrayList.indexOf(n2));
                        }
                    }
                }
            }
            mediaSize = null;
        }
        MediaSize[] mediaSizeArray = new MediaSize[arrayList2.size()];
        arrayList2.toArray(mediaSizeArray);
        return mediaSizeArray;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobs() {
        if (this.getJobStatus(this.printer, 2) != 1) {
            return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
    }

    private QueuedJobCount getQueuedJobCount() {
        int n = this.getJobStatus(this.printer, 1);
        if (n != -1) {
            return new QueuedJobCount(n);
        }
        return new QueuedJobCount(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSupportedCopies(Copies copies) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (!this.gotCopies) {
                this.nCopies = this.getCopiesSupported(this.printer, this.getPort());
                this.gotCopies = true;
            }
        }
        int n = copies.getValue();
        return n > 0 && n <= this.nCopies;
    }

    private boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        this.initMedia();
        if (this.mediaSizeNames != null) {
            for (int i = 0; i < this.mediaSizeNames.length; ++i) {
                if (!mediaSizeName.equals(this.mediaSizeNames[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSupportedMediaPrintableArea(MediaPrintableArea mediaPrintableArea) {
        this.initMedia();
        if (this.mediaPrintables != null) {
            for (int i = 0; i < this.mediaPrintables.length; ++i) {
                if (!mediaPrintableArea.equals(this.mediaPrintables[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSupportedMediaTray(MediaTray mediaTray) {
        this.mediaTrays = this.getMediaTrays();
        if (this.mediaTrays != null) {
            for (int i = 0; i < this.mediaTrays.length; ++i) {
                if (!mediaTray.equals(this.mediaTrays[i])) continue;
                return true;
            }
        }
        return false;
    }

    private int getPrinterCapabilities() {
        if (this.prnCaps == 0) {
            this.prnCaps = this.getCapabilities(this.printer, this.getPort());
        }
        return this.prnCaps;
    }

    private String getPort() {
        if (this.port == null) {
            this.port = this.getPrinterPort(this.printer);
        }
        return this.port;
    }

    private int[] getDefaultPrinterSettings() {
        if (this.defaultSettings == null) {
            this.defaultSettings = this.getDefaultSettings(this.printer);
        }
        return this.defaultSettings;
    }

    private PrinterResolution[] getPrintResolutions() {
        if (this.printRes == null) {
            int[] nArray = this.getAllResolutions(this.printer, this.getPort());
            if (nArray == null) {
                this.printRes = new PrinterResolution[0];
            } else {
                int n = nArray.length / 2;
                ArrayList<PrinterResolution> arrayList = new ArrayList<PrinterResolution>();
                for (int i = 0; i < n; ++i) {
                    try {
                        PrinterResolution printerResolution = new PrinterResolution(nArray[i * 2], nArray[i * 2 + 1], 100);
                        arrayList.add(printerResolution);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                this.printRes = arrayList.toArray(new PrinterResolution[arrayList.size()]);
            }
        }
        return this.printRes;
    }

    private boolean isSupportedResolution(PrinterResolution printerResolution) {
        PrinterResolution[] printerResolutionArray = this.getPrintResolutions();
        if (printerResolutionArray != null) {
            for (int i = 0; i < printerResolutionArray.length; ++i) {
                if (!printerResolution.equals(printerResolutionArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DocPrintJob createPrintJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new Win32PrintJob(this);
    }

    private PrintServiceAttributeSet getDynamicAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobs());
        hashPrintServiceAttributeSet.add(this.getQueuedJobCount());
        return hashPrintServiceAttributeSet;
    }

    @Override
    public PrintServiceAttributeSet getUpdatedAttributes() {
        PrintServiceAttributeSet printServiceAttributeSet = this.getDynamicAttributes();
        if (this.lastSet == null) {
            this.lastSet = printServiceAttributeSet;
            return AttributeSetUtilities.unmodifiableView(printServiceAttributeSet);
        }
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            if (this.lastSet.containsValue(attribute)) continue;
            hashPrintServiceAttributeSet.add(attribute);
        }
        this.lastSet = printServiceAttributeSet;
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (printServiceAttributeListener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(printServiceAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (printServiceAttributeListener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(printServiceAttributeListener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (clazz == ColorSupported.class) {
            int n = this.getPrinterCapabilities();
            if ((n & 1) != 0) {
                return (T)ColorSupported.SUPPORTED;
            }
            return (T)ColorSupported.NOT_SUPPORTED;
        }
        if (clazz == PrinterName.class) {
            return (T)this.getPrinterName();
        }
        if (clazz == QueuedJobCount.class) {
            return (T)this.getQueuedJobCount();
        }
        if (clazz == PrinterIsAcceptingJobs.class) {
            return (T)this.getPrinterIsAcceptingJobs();
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getPrinterName());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobs());
        hashPrintServiceAttributeSet.add(this.getQueuedJobCount());
        int n = this.getPrinterCapabilities();
        if ((n & 1) != 0) {
            hashPrintServiceAttributeSet.add(ColorSupported.SUPPORTED);
        } else {
            hashPrintServiceAttributeSet.add(ColorSupported.NOT_SUPPORTED);
        }
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        DocFlavor[] docFlavorArray;
        int n = supportedFlavors.length;
        int n2 = this.getPrinterCapabilities();
        if ((n2 & 0x10) != 0) {
            docFlavorArray = new DocFlavor[n + 3];
            System.arraycopy(supportedFlavors, 0, docFlavorArray, 0, n);
            docFlavorArray[n] = DocFlavor.BYTE_ARRAY.POSTSCRIPT;
            docFlavorArray[n + 1] = DocFlavor.INPUT_STREAM.POSTSCRIPT;
            docFlavorArray[n + 2] = DocFlavor.URL.POSTSCRIPT;
        } else {
            docFlavorArray = new DocFlavor[n];
            System.arraycopy(supportedFlavors, 0, docFlavorArray, 0, n);
        }
        return docFlavorArray;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        DocFlavor[] docFlavorArray = this.isPostScriptFlavor(docFlavor) ? this.getSupportedDocFlavors() : supportedFlavors;
        for (int i = 0; i < docFlavorArray.length; ++i) {
            if (!docFlavor.equals(docFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedAttributeCategories() {
        Object[] objectArray;
        int n;
        ArrayList<Class<PrinterResolution>> arrayList = new ArrayList<Class<PrinterResolution>>(otherAttrCats.length + 3);
        for (n = 0; n < otherAttrCats.length; ++n) {
            arrayList.add(otherAttrCats[n]);
        }
        n = this.getPrinterCapabilities();
        if ((n & 2) != 0) {
            arrayList.add(Sides.class);
        }
        if ((n & 8) != 0 && (objectArray = this.getDefaultPrinterSettings())[3] >= -4 && objectArray[3] < 0) {
            arrayList.add(PrintQuality.class);
        }
        if ((objectArray = (Object[])this.getPrintResolutions()) != null && objectArray.length > 0) {
            arrayList.add(PrinterResolution.class);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        Class<?>[] classArray = this.getSupportedAttributeCategories();
        for (int i = 0; i < classArray.length; ++i) {
            if (!clazz.equals(classArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        int[] nArray = this.getDefaultPrinterSettings();
        int n = nArray[0];
        int n2 = nArray[2];
        int n3 = nArray[3];
        int n4 = nArray[4];
        int n5 = nArray[5];
        int n6 = nArray[6];
        int n7 = nArray[7];
        if (clazz == Copies.class) {
            if (n4 <= 0) return new Copies(1);
            return new Copies(n4);
        }
        if (clazz == Chromaticity.class) {
            int n8 = this.getPrinterCapabilities();
            if ((n8 & 1) != 0) return Chromaticity.COLOR;
            return Chromaticity.MONOCHROME;
        }
        if (clazz == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (clazz == OrientationRequested.class) {
            if (n5 != 2) return OrientationRequested.PORTRAIT;
            return OrientationRequested.LANDSCAPE;
        }
        if (clazz == PageRanges.class) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (clazz == Media.class) {
            MediaSizeName mediaSizeName = this.findWin32Media(n);
            if (mediaSizeName != null) {
                return mediaSizeName;
            }
            this.initMedia();
            if (this.mediaSizeNames == null) return null;
            if (this.mediaSizeNames.length <= 0) return null;
            if (this.idList == null) return this.mediaSizeNames[0];
            if (this.mediaSizes == null) return this.mediaSizeNames[0];
            if (this.idList.size() != this.mediaSizes.length) return this.mediaSizeNames[0];
            Integer n9 = new Integer(n);
            int n10 = this.idList.indexOf(n9);
            if (n10 < 0) return this.mediaSizeNames[0];
            if (n10 >= this.mediaSizes.length) return this.mediaSizeNames[0];
            return this.mediaSizes[n10].getMediaSizeName();
        }
        if (clazz == MediaPrintableArea.class) {
            float[] fArray = this.getMediaPrintableArea(this.printer, n);
            if (fArray == null) return null;
            MediaPrintableArea mediaPrintableArea = null;
            try {
                return new MediaPrintableArea(fArray[0], fArray[1], fArray[2], fArray[3], 25400);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return mediaPrintableArea;
        }
        if (clazz == SunAlternateMedia.class) {
            return null;
        }
        if (clazz == Destination.class) {
            try {
                return new Destination(new File("out.prn").toURI());
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        if (clazz == Sides.class) {
            switch (n6) {
                case 2: {
                    return Sides.TWO_SIDED_LONG_EDGE;
                }
                case 3: {
                    return Sides.TWO_SIDED_SHORT_EDGE;
                }
            }
            return Sides.ONE_SIDED;
        }
        if (clazz == PrinterResolution.class) {
            int n11 = n2;
            int n12 = n3;
            if (n12 >= 0) {
                if (n11 >= 0) return new PrinterResolution(n12, n11, 100);
            }
            int n13 = n11 > n12 ? n11 : n12;
            if (n13 <= 0) return null;
            return new PrinterResolution(n13, n13, 100);
        }
        if (clazz == ColorSupported.class) {
            int n14 = this.getPrinterCapabilities();
            if ((n14 & 1) == 0) return ColorSupported.NOT_SUPPORTED;
            return ColorSupported.SUPPORTED;
        }
        if (clazz == PrintQuality.class) {
            if (n3 >= 0) return null;
            if (n3 < -4) return null;
            switch (n3) {
                case -4: {
                    return PrintQuality.HIGH;
                }
                case -3: {
                    return PrintQuality.NORMAL;
                }
            }
            return PrintQuality.DRAFT;
        }
        if (clazz == RequestingUserName.class) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
                return new RequestingUserName(string, null);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == SheetCollate.class) {
            if (n7 != 1) return SheetCollate.UNCOLLATED;
            return SheetCollate.COLLATED;
        }
        if (clazz != Fidelity.class) return null;
        return Fidelity.FIDELITY_FALSE;
    }

    private boolean isPostScriptFlavor(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT) || docFlavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) || docFlavor.equals(DocFlavor.URL.POSTSCRIPT);
    }

    private boolean isPSDocAttr(Class clazz) {
        return clazz == OrientationRequested.class;
    }

    private boolean isAutoSense(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || docFlavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || docFlavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor) || this.isPostScriptFlavor(docFlavor) && this.isPSDocAttr(clazz)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (clazz == RequestingUserName.class) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == ColorSupported.class) {
            int n = this.getPrinterCapabilities();
            if ((n & 1) != 0) {
                return ColorSupported.SUPPORTED;
            }
            return ColorSupported.NOT_SUPPORTED;
        }
        if (clazz == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                int n = this.getPrinterCapabilities();
                if ((n & 1) == 0) {
                    Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.MONOCHROME};
                    return chromaticityArray;
                }
                Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.MONOCHROME, Chromaticity.COLOR};
                return chromaticityArray;
            }
            return null;
        }
        if (clazz == Destination.class) {
            try {
                return new Destination(new File("out.prn").toURI());
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        if (clazz == OrientationRequested.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                OrientationRequested[] orientationRequestedArray = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return orientationRequestedArray;
            }
            return null;
        }
        if (clazz == Copies.class || clazz == CopiesSupported.class) {
            Win32PrintService win32PrintService = this;
            synchronized (win32PrintService) {
                if (!this.gotCopies) {
                    this.nCopies = this.getCopiesSupported(this.printer, this.getPort());
                    this.gotCopies = true;
                }
            }
            return new CopiesSupported(1, this.nCopies);
        }
        if (clazz == Media.class) {
            this.initMedia();
            int n = this.mediaSizeNames == null ? 0 : this.mediaSizeNames.length;
            this.mediaTrays = this.getMediaTrays();
            Media[] mediaArray = new Media[n += this.mediaTrays == null ? 0 : this.mediaTrays.length];
            if (this.mediaSizeNames != null) {
                System.arraycopy(this.mediaSizeNames, 0, mediaArray, 0, this.mediaSizeNames.length);
            }
            if (this.mediaTrays != null) {
                System.arraycopy(this.mediaTrays, 0, mediaArray, this.mediaSizeNames.length, this.mediaTrays.length);
            }
            return mediaArray;
        }
        if (clazz == MediaPrintableArea.class) {
            Media media;
            this.initMedia();
            if (this.mediaPrintables == null) {
                return null;
            }
            if (attributeSet != null && (media = (Media)attributeSet.get(Media.class)) != null && media instanceof MediaSizeName) {
                MediaSize mediaSize;
                MediaPrintableArea[] mediaPrintableAreaArray = new MediaPrintableArea[1];
                if (this.mediaSizeNames.length == this.mediaPrintables.length) {
                    for (int i = 0; i < this.mediaSizeNames.length; ++i) {
                        if (!media.equals(this.mediaSizeNames[i])) continue;
                        mediaPrintableAreaArray[0] = this.mediaPrintables[i];
                        return mediaPrintableAreaArray;
                    }
                }
                if ((mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media)) != null) {
                    mediaPrintableAreaArray[0] = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(25400), mediaSize.getY(25400), 25400);
                    return mediaPrintableAreaArray;
                }
                return null;
            }
            MediaPrintableArea[] mediaPrintableAreaArray = new MediaPrintableArea[this.mediaPrintables.length];
            System.arraycopy(this.mediaPrintables, 0, mediaPrintableAreaArray, 0, this.mediaPrintables.length);
            return mediaPrintableAreaArray;
        }
        if (clazz == SunAlternateMedia.class) {
            return new SunAlternateMedia((Media)this.getDefaultAttributeValue(Media.class));
        }
        if (clazz == PageRanges.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return pageRangesArray;
            }
            return null;
        }
        if (clazz == PrinterResolution.class) {
            PrinterResolution[] printerResolutionArray = this.getPrintResolutions();
            if (printerResolutionArray == null) {
                return null;
            }
            PrinterResolution[] printerResolutionArray2 = new PrinterResolution[printerResolutionArray.length];
            System.arraycopy(printerResolutionArray, 0, printerResolutionArray2, 0, printerResolutionArray.length);
            return printerResolutionArray2;
        }
        if (clazz == Sides.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] sidesArray = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return sidesArray;
            }
            return null;
        }
        if (clazz == PrintQuality.class) {
            PrintQuality[] printQualityArray = new PrintQuality[]{PrintQuality.DRAFT, PrintQuality.HIGH, PrintQuality.NORMAL};
            return printQualityArray;
        }
        if (clazz == SheetCollate.class) {
            int n = this.getPrinterCapabilities();
            if ((this.prnCaps & 4) != 0 && docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.COLLATED, SheetCollate.UNCOLLATED};
                return sheetCollateArray;
            }
            return null;
        }
        if (clazz == Fidelity.class) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        return null;
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        Class<? extends Attribute> clazz = attribute.getCategory();
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor) || this.isPostScriptFlavor(docFlavor) && this.isPSDocAttr(clazz)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return false;
        }
        if (attribute.getCategory() == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                int n = this.getPrinterCapabilities();
                if ((n & 1) != 0) {
                    return true;
                }
                return attribute == Chromaticity.MONOCHROME;
            }
            return false;
        }
        if (attribute.getCategory() == Copies.class) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == Destination.class) {
            URI uRI = ((Destination)attribute).getURI();
            return "file".equals(uRI.getScheme()) && !uRI.getSchemeSpecificPart().equals("");
        }
        if (attribute.getCategory() == Media.class) {
            if (attribute instanceof MediaSizeName) {
                return this.isSupportedMedia((MediaSizeName)attribute);
            }
            if (attribute instanceof MediaTray) {
                return this.isSupportedMediaTray((MediaTray)attribute);
            }
        } else {
            if (attribute.getCategory() == MediaPrintableArea.class) {
                return this.isSupportedMediaPrintableArea((MediaPrintableArea)attribute);
            }
            if (attribute.getCategory() == SunAlternateMedia.class) {
                Media media = ((SunAlternateMedia)attribute).getMedia();
                return this.isAttributeValueSupported(media, docFlavor, attributeSet);
            }
            if (attribute.getCategory() == PageRanges.class) {
                if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (attribute.getCategory() == SheetCollate.class) {
                int n = this.getPrinterCapabilities();
                if (!((this.prnCaps & 4) != 0 && docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE))) {
                    return false;
                }
            } else if (attribute.getCategory() == Sides.class) {
                if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (attribute.getCategory() == PrinterResolution.class) {
                if (attribute instanceof PrinterResolution) {
                    return this.isSupportedResolution((PrinterResolution)attribute);
                }
            } else if (attribute.getCategory() == OrientationRequested.class) {
                if (!(attribute != OrientationRequested.REVERSE_PORTRAIT && (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.URL.PNG)))) {
                    return false;
                }
            } else if (attribute.getCategory() == ColorSupported.class) {
                boolean bl;
                int n = this.getPrinterCapabilities();
                boolean bl2 = bl = (n & 1) != 0;
                if (!bl && attribute == ColorSupported.SUPPORTED || bl && attribute == ColorSupported.NOT_SUPPORTED) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            try {
                Attribute attribute = attributeArray[i];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                    continue;
                }
                if (this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) continue;
                hashAttributeSet.add(attribute);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public String toString() {
        return "Win32 Printer : " + this.getName();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof Win32PrintService && ((Win32PrintService)object).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    @Override
    public boolean usesClass(Class clazz) {
        return clazz == WPrinterJob.class;
    }

    private native int[] getAllMediaIDs(String var1, String var2);

    private native int[] getAllMediaSizes(String var1, String var2);

    private native int[] getAllMediaTrays(String var1, String var2);

    private native float[] getMediaPrintableArea(String var1, int var2);

    private native String[] getAllMediaNames(String var1, String var2);

    private native String[] getAllMediaTrayNames(String var1, String var2);

    private native int getCopiesSupported(String var1, String var2);

    private native int[] getAllResolutions(String var1, String var2);

    private native int getCapabilities(String var1, String var2);

    private native int[] getDefaultSettings(String var1);

    private native int getJobStatus(String var1, int var2);

    private native String getPrinterPort(String var1);

    static {
        Class<Win32MediaSize> clazz = Win32MediaSize.class;
        supportedFlavors = new DocFlavor[]{DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF, DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG, DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG, DocFlavor.SERVICE_FORMATTED.PAGEABLE, DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.URL.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE};
        serviceAttrCats = new Class[]{PrinterName.class, PrinterIsAcceptingJobs.class, QueuedJobCount.class, ColorSupported.class};
        otherAttrCats = new Class[]{JobName.class, RequestingUserName.class, Copies.class, Destination.class, OrientationRequested.class, PageRanges.class, Media.class, MediaPrintableArea.class, Fidelity.class, SheetCollate.class, SunAlternateMedia.class, Chromaticity.class};
        dmPaperToPrintService = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.INVOICE, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.B, MediaSizeName.NA_LETTER, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ISO_C5, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.FOLIO, MediaSizeName.ISO_B4, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.NA_9X11_ENVELOPE};
        dmPaperBinToPrintService = new MediaTray[]{MediaTray.TOP, MediaTray.BOTTOM, MediaTray.MIDDLE, MediaTray.MANUAL, MediaTray.ENVELOPE, Win32MediaTray.ENVELOPE_MANUAL, Win32MediaTray.AUTO, Win32MediaTray.TRACTOR, Win32MediaTray.SMALL_FORMAT, Win32MediaTray.LARGE_FORMAT, MediaTray.LARGE_CAPACITY, null, null, MediaTray.MAIN, Win32MediaTray.FORMSOURCE};
        DM_PAPERSIZE = 2;
        DM_PRINTQUALITY = 1024;
        DM_YRESOLUTION = 8192;
    }
}

