/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.Converters;
import sun.nio.cs.HistoricallyNamedCharset;

public abstract class StreamDecoder
extends Reader {
    private static final int MIN_BYTE_BUFFER_SIZE = 32;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private volatile boolean isOpen = true;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private static volatile boolean channelsAvailable = true;

    private StreamDecoder() {
    }

    private StreamDecoder(Object object) {
        super(object);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    abstract int implRead(char[] var1, int var2, int var3) throws IOException;

    abstract String encodingName();

    abstract boolean implReady();

    abstract void implClose() throws IOException;

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            string2 = Converters.getDefaultEncodingName();
        }
        if (!Converters.isCached(0, string2)) {
            try {
                if (Charset.isSupported(string2)) {
                    return new CharsetSD(inputStream, object, Charset.forName(string2));
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        return new ConverterSD(inputStream, object, string2);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, Charset charset) {
        return new CharsetSD(inputStream, object, charset);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
        return new CharsetSD(inputStream, object, charsetDecoder);
    }

    public static StreamDecoder forDecoder(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        return new CharsetSD(readableByteChannel, charsetDecoder, n);
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    public int read() throws IOException {
        return this.read0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.haveLeftoverChar) {
                this.haveLeftoverChar = false;
                return this.leftoverChar;
            }
            char[] cArray = new char[2];
            int n = this.read(cArray, 0, 2);
            switch (n) {
                case -1: {
                    return -1;
                }
                case 2: {
                    this.leftoverChar = cArray[1];
                    this.haveLeftoverChar = true;
                }
                case 1: {
                    return cArray[0];
                }
            }
            assert (false) : n;
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n2;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n3 < 0 || n3 > cArray.length || n4 < 0 || n3 + n4 > cArray.length || n3 + n4 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n4 == 0) {
                return 0;
            }
            int n5 = 0;
            if (this.haveLeftoverChar) {
                cArray[n3] = this.leftoverChar;
                ++n3;
                this.haveLeftoverChar = false;
                n5 = 1;
                if (--n4 == 0 || !this.implReady()) {
                    return n5;
                }
            }
            if (n4 == 1) {
                int n6 = this.read0();
                if (n6 == -1) {
                    return n5 == 0 ? -1 : n5;
                }
                cArray[n3] = (char)n6;
                return n5 + 1;
            }
            return n5 + this.implRead(cArray, n3, n3 + n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.haveLeftoverChar || this.implReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.implClose();
            this.isOpen = false;
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    private static FileChannel getChannel(FileInputStream fileInputStream) {
        if (!channelsAvailable) {
            return null;
        }
        try {
            return fileInputStream.getChannel();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            channelsAvailable = false;
            return null;
        }
    }

    private static class CharsetSD
    extends StreamDecoder {
        private Charset cs;
        private CharsetDecoder decoder;
        private ByteBuffer bb;
        private InputStream in;
        private ReadableByteChannel ch;

        CharsetSD(InputStream inputStream, Object object, Charset charset) {
            this(inputStream, object, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        CharsetSD(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
            super(object);
            this.cs = charsetDecoder.charset();
            this.decoder = charsetDecoder;
            if (this.ch == null) {
                this.in = inputStream;
                this.ch = null;
                this.bb = ByteBuffer.allocate(8192);
            }
            this.bb.flip();
        }

        CharsetSD(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
            this.in = null;
            this.ch = readableByteChannel;
            this.decoder = charsetDecoder;
            this.cs = charsetDecoder.charset();
            this.bb = ByteBuffer.allocate(n < 0 ? 8192 : (n < 32 ? 32 : n));
            this.bb.flip();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readBytes() throws IOException {
            int n;
            this.bb.compact();
            try {
                if (this.ch != null) {
                    n = this.ch.read(this.bb);
                    if (n < 0) {
                        int n2 = n;
                        return n2;
                    }
                } else {
                    int n3;
                    n = this.bb.limit();
                    int n4 = this.bb.position();
                    assert (n4 <= n);
                    int n5 = n3 = n4 <= n ? n - n4 : 0;
                    assert (n3 > 0);
                    int n6 = this.in.read(this.bb.array(), this.bb.arrayOffset() + n4, n3);
                    if (n6 < 0) {
                        int n7 = n6;
                        return n7;
                    }
                    if (n6 == 0) {
                        throw new IOException("Underlying input stream returned zero bytes");
                    }
                    assert (n6 <= n3) : "n = " + n6 + ", rem = " + n3;
                    this.bb.position(n4 + n6);
                }
            }
            finally {
                this.bb.flip();
            }
            n = this.bb.remaining();
            assert (n != 0) : n;
            return n;
        }

        int implRead(char[] cArray, int n, int n2) throws IOException {
            assert (n2 - n > 1);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2 - n);
            if (charBuffer.position() != 0) {
                charBuffer = charBuffer.slice();
            }
            boolean bl = false;
            while (true) {
                CoderResult coderResult;
                if ((coderResult = this.decoder.decode(this.bb, charBuffer, bl)).isUnderflow()) {
                    if (bl || !charBuffer.hasRemaining() || charBuffer.position() > 0 && !this.inReady()) break;
                    int n3 = this.readBytes();
                    if (n3 >= 0) continue;
                    bl = true;
                    if (charBuffer.position() == 0 && !this.bb.hasRemaining()) break;
                    this.decoder.reset();
                    continue;
                }
                if (coderResult.isOverflow()) {
                    assert (charBuffer.position() > 0);
                    break;
                }
                coderResult.throwException();
            }
            if (bl) {
                this.decoder.reset();
            }
            if (charBuffer.position() == 0) {
                if (bl) {
                    return -1;
                }
                assert (false);
            }
            return charBuffer.position();
        }

        String encodingName() {
            return this.cs instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)((Object)this.cs)).historicalName() : this.cs.name();
        }

        private boolean inReady() {
            try {
                return this.in != null && this.in.available() > 0 || this.ch instanceof FileChannel;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        boolean implReady() {
            return this.bb.hasRemaining() || this.inReady();
        }

        void implClose() throws IOException {
            if (this.ch != null) {
                this.ch.close();
            } else {
                this.in.close();
            }
        }
    }

    private static class ConverterSD
    extends StreamDecoder {
        private final InputStream in;
        private ByteToCharConverter btc;
        private byte[] bb;
        private int nBytes = 0;
        private int nextByte = 0;

        private ConverterSD(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
            super(object);
            this.in = inputStream;
            this.btc = ByteToCharConverter.getConverter(string);
            this.bb = new byte[8192];
        }

        private ConverterSD(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
            this(Channels.newInputStream(readableByteChannel), null, string);
            this.lock = this;
        }

        private void malfunction() {
            throw new InternalError("Converter malfunction (" + this.btc.getCharacterEncoding() + ") -- please submit a bug report via " + System.getProperty("java.vendor.url.bug"));
        }

        private int convertInto(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this.nextByte < this.nBytes) {
                try {
                    n3 = this.btc.convert(this.bb, this.nextByte, this.nBytes, cArray, n, n2);
                    this.nextByte = this.nBytes;
                    if (this.btc.nextByteIndex() != this.nextByte) {
                        this.malfunction();
                    }
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte = this.btc.nextByteIndex();
                    n3 = this.btc.nextCharIndex() - n;
                }
            }
            return n3;
        }

        private int flushInto(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            try {
                n3 = this.btc.flush(cArray, n, n2);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                n3 = this.btc.nextCharIndex() - n;
            }
            return n3;
        }

        int implRead(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this.nextByte < this.nBytes) {
                n3 = this.convertInto(cArray, n, n2);
            }
            while (n + n3 < n2) {
                if (this.nBytes != -1) {
                    if (n3 > 0 && !this.inReady()) break;
                    this.nBytes = this.in.read(this.bb);
                }
                if (this.nBytes == -1) {
                    this.nBytes = 0;
                    if ((n3 += this.flushInto(cArray, n + n3, n2)) != 0) break;
                    return -1;
                }
                this.nextByte = 0;
                n3 += this.convertInto(cArray, n + n3, n2);
            }
            return n3;
        }

        String encodingName() {
            return this.btc.getCharacterEncoding();
        }

        private boolean inReady() {
            try {
                return this.in.available() > 0;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        boolean implReady() {
            return this.nextByte < this.nBytes || this.inReady();
        }

        void implClose() throws IOException {
            this.in.close();
        }
    }
}

