/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.geom.AffineTransform;
import sun.java2d.InvalidPipeException;
import sun.java2d.loops.XORComposite;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.Region;

public abstract class OGLContext {
    public static final int NO_CONTEXT_FLAGS = 0;
    public static final int USE_EXTRA_ALPHA = 1;
    public static final int SRC_IS_PREMULT = 2;
    public static final int SRC_IS_OPAQUE = 4;
    public static Object LOCK;
    private static OGLContext currentContext;
    protected long nativeContext;
    private OGLSurfaceData validatedSrcData;
    private OGLSurfaceData validatedDstData;
    private Region validatedClip;
    private Composite validatedComp;
    private int validatedPixel;
    private int validatedFlags;
    private boolean xformInUse;
    private static InvocationEvent flushEvt;
    private static boolean flushPending;

    private static native void initIDs();

    protected abstract boolean makeNativeContextCurrent(long var1, long var3, long var5);

    private native void setViewport(long var1, long var3);

    private native void setClip(long var1, Region var3, boolean var4, int var5, int var6, int var7, int var8);

    private native void resetComposite(long var1);

    private native void setAlphaComposite(long var1, int var3, float var4, int var5);

    private native void setXorComposite(long var1, int var3);

    private native void setTransform(long var1, AffineTransform var3, double var4, double var6, double var8, double var10, double var12, double var14);

    private native void setColor(long var1, int var3, int var4);

    public static long getContext(OGLSurfaceData oGLSurfaceData, OGLSurfaceData oGLSurfaceData2, Region region, Composite composite, AffineTransform affineTransform, int n, int n2) {
        OGLContext oGLContext = oGLSurfaceData2.getContext();
        oGLContext.validate(oGLSurfaceData, oGLSurfaceData2, region, composite, affineTransform, n, n2);
        currentContext = oGLContext;
        return oGLContext.getNativeContext();
    }

    public static long getContext(OGLSurfaceData oGLSurfaceData) {
        return OGLContext.getContext(oGLSurfaceData, oGLSurfaceData, null, null, null, 0, 0);
    }

    public static long getSharedContext(OGLSurfaceData oGLSurfaceData) {
        currentContext = null;
        return oGLSurfaceData.getSharedContext();
    }

    public long getNativeContext() {
        return this.nativeContext;
    }

    public boolean makeCurrent(OGLSurfaceData oGLSurfaceData, OGLSurfaceData oGLSurfaceData2) {
        long l;
        int n = oGLSurfaceData2.getType();
        if (n == 0 && !oGLSurfaceData2.initWindow()) {
            currentContext = null;
            return false;
        }
        if (n == 4) {
            return false;
        }
        long l2 = oGLSurfaceData.getNativeOps();
        if (this.makeNativeContextCurrent(this.nativeContext, l2, l = oGLSurfaceData2.getNativeOps())) {
            currentContext = this;
            return true;
        }
        currentContext = null;
        return false;
    }

    public void validate(OGLSurfaceData oGLSurfaceData, OGLSurfaceData oGLSurfaceData2, Region region, Composite composite, AffineTransform affineTransform, int n, int n2) {
        long l = oGLSurfaceData2.getNativeOps();
        boolean bl = false;
        if (!oGLSurfaceData2.isValid()) {
            throw new InvalidPipeException("bounds changed");
        }
        if (currentContext != this || oGLSurfaceData != this.validatedSrcData || oGLSurfaceData2 != this.validatedDstData) {
            long l2 = oGLSurfaceData.getNativeOps();
            this.validatedPixel = ~n;
            bl = true;
            if (!this.makeCurrent(oGLSurfaceData, oGLSurfaceData2)) {
                return;
            }
            this.validatedSrcData = oGLSurfaceData;
            this.validatedDstData = oGLSurfaceData2;
            this.setViewport(l2, l);
        }
        if (region != this.validatedClip || bl) {
            this.validatedClip = region;
            if (region != null) {
                this.setClip(l, region, region.isRectangular(), region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY());
            } else {
                this.setClip(l, null, false, 0, 0, 0, 0);
            }
        }
        if (composite != this.validatedComp || n2 != this.validatedFlags) {
            this.validatedPixel = ~n;
            this.validatedComp = composite;
            if (composite != null) {
                if (composite instanceof XORComposite) {
                    int n3 = ((XORComposite)composite).getXorPixel();
                    this.setXorComposite(this.nativeContext, n3);
                } else {
                    AlphaComposite alphaComposite = (AlphaComposite)composite;
                    this.setAlphaComposite(this.nativeContext, alphaComposite.getRule(), alphaComposite.getAlpha(), n2);
                }
            } else {
                this.resetComposite(this.nativeContext);
            }
        }
        if (affineTransform == null) {
            if (this.xformInUse) {
                this.setTransform(this.nativeContext, null, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                this.xformInUse = false;
            }
        } else {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.setTransform(this.nativeContext, affineTransform, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            this.xformInUse = true;
        }
        if (n != this.validatedPixel) {
            this.validatedPixel = n;
            this.setColor(this.nativeContext, n, n2);
        }
        this.validatedFlags = n2;
        oGLSurfaceData2.markDirty();
    }

    public static void invalidateCurrentContext() {
        currentContext = null;
    }

    private static native void flushPipeline();

    private static void invokeNativeGLFlush() {
        if (!flushPending) {
            flushPending = true;
            if (flushEvt == null) {
                flushEvt = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), new NativeGLFlush());
            }
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(flushEvt);
        }
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            OGLContext.initIDs();
        }
        flushPending = false;
    }

    private static class NativeGLFlush
    implements Runnable {
        private NativeGLFlush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = LOCK;
            synchronized (object) {
                OGLContext.flushPipeline();
                flushPending = false;
            }
        }
    }
}

