/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.font.FileFontStrike;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public abstract class FileFont
extends PhysicalFont {
    protected boolean useJavaRasterizer = true;
    protected int fileSize;
    protected FileFontDisposer disposer;
    protected long pScaler;
    protected boolean checkedNatives;
    protected boolean useNatives;
    protected NativeFont[] nativeFonts;
    protected char[] glyphToCharMap;

    FileFont(String string, Object object) throws FontFormatException {
        super(string, object);
    }

    FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        if (!this.checkedNatives) {
            this.checkUseNatives();
        }
        return new FileFontStrike(this, fontStrikeDesc);
    }

    protected void checkUseNatives() {
        this.checkedNatives = true;
    }

    protected abstract void close();

    abstract ByteBuffer readBlock(int var1, int var2);

    public boolean canDoStyle(int n) {
        return true;
    }

    void setFileToRemove(File file) {
        Disposer.addObjectRecord(this, new CreatedFontFileDisposerRecord(file));
    }

    static native void freeScaler(long var0);

    static synchronized native long getNullScaler();

    synchronized native StrikeMetrics getFontMetrics(long var1);

    synchronized native float getGlyphAdvance(long var1, int var3);

    synchronized native void getGlyphMetrics(long var1, int var3, Point2D.Float var4);

    synchronized native long getGlyphImage(long var1, int var3);

    synchronized native Rectangle2D.Float getGlyphOutlineBounds(long var1, int var3);

    synchronized native GeneralPath getGlyphOutline(long var1, int var3, float var4, float var5);

    synchronized native GeneralPath getGlyphVectorOutline(long var1, int[] var3, int var4, float var5, float var6);

    protected abstract long getScaler();

    private static class CreatedFontFileDisposerRecord
    extends DisposerRecord {
        File fontFile = null;

        private CreatedFontFileDisposerRecord(File file) {
            this.fontFile = file;
        }

        public void dispose() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (CreatedFontFileDisposerRecord.this.fontFile != null) {
                        try {
                            CreatedFontFileDisposerRecord.this.fontFile.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected static class FileFontDisposer
    extends DisposerRecord {
        long pScaler = 0L;
        boolean disposed = false;

        public FileFontDisposer(long l) {
            this.pScaler = l;
        }

        public synchronized void dispose() {
            if (!this.disposed) {
                FileFont.freeScaler(this.pScaler);
                this.pScaler = 0L;
                this.disposed = true;
            }
        }
    }
}

