/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    private final ReadLock readerLock;
    private final WriteLock writerLock;
    private final Sync sync;
    static final int SHARED_SHIFT = 16;
    static final int SHARED_UNIT = 65536;
    static final int EXCLUSIVE_MASK = 65535;

    public ReentrantReadWriteLock() {
        this.sync = new NonfairSync();
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    public ReentrantReadWriteLock(boolean bl) {
        this.sync = bl ? new FairSync() : new NonfairSync();
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    @Override
    public WriteLock writeLock() {
        return this.writerLock;
    }

    @Override
    public ReadLock readLock() {
        return this.readerLock;
    }

    static int sharedCount(int n) {
        return n >>> 16;
    }

    static int exclusiveCount(int n) {
        return n & 0xFFFF;
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    protected Collection<Thread> getQueuedWriterThreads() {
        return this.sync.getExclusiveQueuedThreads();
    }

    protected Collection<Thread> getQueuedReaderThreads() {
        return this.sync.getSharedQueuedThreads();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.hasWaiters((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public int getWaitQueueLength(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitingThreads((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public String toString() {
        int n = this.sync.getCount();
        int n2 = ReentrantReadWriteLock.exclusiveCount(n);
        int n3 = ReentrantReadWriteLock.sharedCount(n);
        return super.toString() + "[Write locks = " + n2 + ", Read locks = " + n3 + "]";
    }

    static final class FairSync
    extends Sync {
        FairSync() {
        }

        protected final boolean tryAcquire(int n) {
            Thread thread;
            n = ReentrantReadWriteLock.exclusiveCount(n);
            Thread thread2 = Thread.currentThread();
            int n2 = this.getState();
            int n3 = ReentrantReadWriteLock.exclusiveCount(n2);
            if (n3 + n >= 65536) {
                throw new Error("Maximum lock count exceeded");
            }
            if ((n3 == 0 || thread2 != this.owner) && (n2 != 0 || (thread = this.getFirstQueuedThread()) != null && thread != thread2)) {
                return false;
            }
            if (!this.compareAndSetState(n2, n2 + n)) {
                return false;
            }
            this.owner = thread2;
            return true;
        }

        protected final int tryAcquireShared(int n) {
            int n2;
            int n3;
            Thread thread = Thread.currentThread();
            do {
                Thread thread2;
                if (ReentrantReadWriteLock.exclusiveCount(n3 = this.getState()) != 0 ? this.owner != thread : (thread2 = this.getFirstQueuedThread()) != null && thread2 != thread) {
                    return -1;
                }
                n2 = n3 + (n << 16);
                if (n2 >= n3) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(n3, n2));
            return 1;
        }

        final void wlock() {
            this.acquire(1);
        }
    }

    static final class NonfairSync
    extends Sync {
        NonfairSync() {
        }

        protected final boolean tryAcquire(int n) {
            return this.nonfairTryAcquire(n);
        }

        protected final int tryAcquireShared(int n) {
            return this.nonfairTryAcquireShared(n);
        }

        final void wlock() {
            if (this.compareAndSetState(0, 1)) {
                this.owner = Thread.currentThread();
            } else {
                this.acquire(1);
            }
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        private final Sync sync;

        protected ReadLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            this.sync = reentrantReadWriteLock.sync;
        }

        public void lock() {
            this.sync.acquireShared(1);
        }

        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireSharedInterruptibly(1);
        }

        public boolean tryLock() {
            return this.sync.nonfairTryAcquireShared(1) >= 0;
        }

        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l));
        }

        public void unlock() {
            this.sync.releaseShared(1);
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int n = this.sync.getReadLockCount();
            return super.toString() + "[Read locks = " + n + "]";
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        transient Thread owner;

        Sync() {
        }

        abstract void wlock();

        final boolean nonfairTryAcquire(int n) {
            n = ReentrantReadWriteLock.exclusiveCount(n);
            Thread thread = Thread.currentThread();
            int n2 = this.getState();
            int n3 = ReentrantReadWriteLock.exclusiveCount(n2);
            if (n3 + n >= 65536) {
                throw new Error("Maximum lock count exceeded");
            }
            if (n2 != 0 && (n3 == 0 || thread != this.owner)) {
                return false;
            }
            if (!this.compareAndSetState(n2, n2 + n)) {
                return false;
            }
            this.owner = thread;
            return true;
        }

        final int nonfairTryAcquireShared(int n) {
            int n2;
            int n3;
            do {
                if ((n2 = (n3 = this.getState()) + (n << 16)) < n3) {
                    throw new Error("Maximum lock count exceeded");
                }
                if (ReentrantReadWriteLock.exclusiveCount(n3) == 0 || this.owner == Thread.currentThread()) continue;
                return -1;
            } while (!this.compareAndSetState(n3, n2));
            return 1;
        }

        protected final boolean tryRelease(int n) {
            Thread thread = Thread.currentThread();
            int n2 = this.getState();
            if (this.owner != thread) {
                throw new IllegalMonitorStateException();
            }
            int n3 = n2 - n;
            boolean bl = false;
            if (ReentrantReadWriteLock.exclusiveCount(n2) == n) {
                bl = true;
                this.owner = null;
            }
            this.setState(n3);
            return bl;
        }

        protected final boolean tryReleaseShared(int n) {
            int n2;
            int n3;
            do {
                if ((n2 = (n3 = this.getState()) - (n << 16)) >= 0) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(n3, n2));
            return n2 == 0;
        }

        protected final boolean isHeldExclusively() {
            return ReentrantReadWriteLock.exclusiveCount(this.getState()) != 0 && this.owner == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            int n = ReentrantReadWriteLock.exclusiveCount(this.getState());
            Thread thread = this.owner;
            return n == 0 ? null : thread;
        }

        final int getReadLockCount() {
            return ReentrantReadWriteLock.sharedCount(this.getState());
        }

        final boolean isWriteLocked() {
            return ReentrantReadWriteLock.exclusiveCount(this.getState()) != 0;
        }

        final int getWriteHoldCount() {
            int n = ReentrantReadWriteLock.exclusiveCount(this.getState());
            Thread thread = this.owner;
            return thread == Thread.currentThread() ? n : 0;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.setState(0);
        }

        final int getCount() {
            return this.getState();
        }
    }

    public static class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        private final Sync sync;

        protected WriteLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            this.sync = reentrantReadWriteLock.sync;
        }

        public void lock() {
            this.sync.wlock();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireInterruptibly(1);
        }

        public boolean tryLock() {
            return this.sync.nonfairTryAcquire(1);
        }

        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.sync.tryAcquireNanos(1, timeUnit.toNanos(l));
        }

        public void unlock() {
            this.sync.release(1);
        }

        public Condition newCondition() {
            return this.sync.newCondition();
        }

        public String toString() {
            Thread thread = this.sync.getOwner();
            return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + "]");
        }
    }
}

