/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class BandCombineOp
implements RasterOp {
    float[][] matrix;
    int nrows = 0;
    int ncols = 0;
    RenderingHints hints;

    public BandCombineOp(float[][] fArray, RenderingHints renderingHints) {
        this.nrows = fArray.length;
        this.ncols = fArray[0].length;
        this.matrix = new float[this.nrows][this.ncols + 1];
        for (int i = 0; i < this.nrows; ++i) {
            System.arraycopy(fArray[i], 0, this.matrix[i], 0, this.ncols);
        }
        this.hints = renderingHints;
    }

    public final float[][] getMatrix() {
        return (float[][])this.matrix.clone();
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n = raster.getNumBands();
        if (this.ncols != n && this.ncols != n + 1) {
            throw new IllegalArgumentException("Number of columns in the matrix (" + this.ncols + ") must be equal to the number" + " of bands ([+1]) in src (" + n + ").");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (this.nrows != writableRaster.getNumBands()) {
            throw new IllegalArgumentException("Number of rows in the matrix (" + this.nrows + ") must be equal to the number" + " of bands ([+1]) in dst (" + n + ").");
        }
        if (ImagingLib.filter(this, raster, writableRaster) != null) {
            return writableRaster;
        }
        int[] nArray = null;
        int[] nArray2 = new int[writableRaster.getNumBands()];
        int n2 = raster.getMinX();
        int n3 = raster.getMinY();
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        if (this.ncols == n) {
            int n6 = 0;
            while (n6 < raster.getHeight()) {
                int n7 = n4;
                int n8 = n2;
                int n9 = 0;
                while (n9 < raster.getWidth()) {
                    nArray = raster.getPixel(n8, n3, nArray);
                    for (int i = 0; i < this.nrows; ++i) {
                        float f = 0.0f;
                        for (int j = 0; j < this.ncols; ++j) {
                            f += this.matrix[i][j] * (float)nArray[j];
                        }
                        nArray2[i] = (int)f;
                    }
                    writableRaster.setPixel(n7, n5, nArray2);
                    ++n9;
                    ++n8;
                    ++n7;
                }
                ++n6;
                ++n3;
                ++n5;
            }
        } else {
            int n10 = 0;
            while (n10 < raster.getHeight()) {
                int n11 = n4;
                int n12 = n2;
                int n13 = 0;
                while (n13 < raster.getWidth()) {
                    nArray = raster.getPixel(n12, n3, nArray);
                    for (int i = 0; i < this.nrows; ++i) {
                        float f = 0.0f;
                        for (int j = 0; j < n; ++j) {
                            f += this.matrix[i][j] * (float)nArray[j];
                        }
                        nArray2[i] = (int)(f + this.matrix[i][n]);
                    }
                    writableRaster.setPixel(n11, n5, nArray2);
                    ++n13;
                    ++n12;
                    ++n11;
                }
                ++n10;
                ++n3;
                ++n5;
            }
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        int n = raster.getNumBands();
        if (this.ncols != n && this.ncols != n + 1) {
            throw new IllegalArgumentException("Number of columns in the matrix (" + this.ncols + ") must be equal to the number" + " of bands ([+1]) in src (" + n + ").");
        }
        if (raster.getNumBands() == this.nrows) {
            return raster.createCompatibleWritableRaster();
        }
        throw new IllegalArgumentException("Don't know how to create a  compatible Raster with " + this.nrows + " bands.");
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }
}

