/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.serializer.CharInfo;
import com.sun.org.apache.xml.internal.serializer.ElemContext;
import com.sun.org.apache.xml.internal.serializer.ElemDesc;
import com.sun.org.apache.xml.internal.serializer.Encodings;
import com.sun.org.apache.xml.internal.serializer.NamespaceMappings;
import com.sun.org.apache.xml.internal.serializer.OutputPropertiesFactory;
import com.sun.org.apache.xml.internal.serializer.OutputPropertyUtils;
import com.sun.org.apache.xml.internal.serializer.ToStream;
import com.sun.org.apache.xml.internal.utils.Trie;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToHTMLStream
extends ToStream {
    protected boolean m_inDTD = false;
    private boolean m_inBlockElem = false;
    protected static final CharInfo m_htmlcharInfo = CharInfo.getCharInfo(CharInfo.HTML_ENTITIES_RESOURCE, "html");
    static final Trie m_elementFlags = new Trie();
    private static final ElemDesc m_dummy;
    private boolean m_specialEscapeURLs = true;
    private boolean m_omitMetaTag = false;

    public void setSpecialEscapeURLs(boolean bl) {
        this.m_specialEscapeURLs = bl;
    }

    public void setOmitMetaTag(boolean bl) {
        this.m_omitMetaTag = bl;
    }

    public void setOutputFormat(Properties properties) {
        this.m_specialEscapeURLs = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}use-url-escaping", properties);
        this.m_omitMetaTag = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}omit-meta-tag", properties);
        super.setOutputFormat(properties);
    }

    private final boolean getSpecialEscapeURLs() {
        return this.m_specialEscapeURLs;
    }

    private final boolean getOmitMetaTag() {
        return this.m_omitMetaTag;
    }

    public static final ElemDesc getElemDesc(String string) {
        Object object = m_elementFlags.get(string);
        if (null != object) {
            return (ElemDesc)object;
        }
        return m_dummy;
    }

    public ToHTMLStream() {
        this.m_charInfo = m_htmlcharInfo;
        this.m_prefixMap = new NamespaceMappings();
    }

    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.setOmitXMLDeclaration(true);
        if (this.m_needToOutputDocTypeDecl) {
            String string = this.getDoctypeSystem();
            String string2 = this.getDoctypePublic();
            if (null != string || null != string2) {
                Writer writer = this.m_writer;
                try {
                    writer.write("<!DOCTYPE HTML");
                    if (null != string2) {
                        writer.write(" PUBLIC \"");
                        writer.write(string2);
                        writer.write(34);
                    }
                    if (null != string) {
                        if (null == string2) {
                            writer.write(" SYSTEM \"");
                        } else {
                            writer.write(34);
                        }
                        writer.write(string);
                        writer.write(34);
                    }
                    writer.write(62);
                    this.outputLineSep();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public final void endDocument() throws SAXException {
        this.flushPending();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ElemContext elemContext = this.m_elemContext;
        if (elemContext.m_startTagOpen) {
            this.closeStartTag();
            elemContext.m_startTagOpen = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        if (null != string && string.length() > 0) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        try {
            ElemDesc elemDesc = ToHTMLStream.getElemDesc(string3);
            int n = elemDesc.getFlags();
            if (this.m_doIndent) {
                boolean bl;
                boolean bl2 = bl = (n & 8) != 0;
                if (this.m_ispreserve) {
                    this.m_ispreserve = false;
                } else if (null != elemContext.m_elementName && (!this.m_inBlockElem || bl)) {
                    this.m_startNewLine = true;
                    this.indent();
                }
                boolean bl3 = this.m_inBlockElem = !bl;
            }
            if (attributes != null) {
                this.addAttributes(attributes);
            }
            this.m_isprevtext = false;
            Writer writer = this.m_writer;
            writer.write(60);
            writer.write(string3);
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
            if ((n & 2) != 0) {
                this.m_elemContext = elemContext.push();
                this.m_elemContext.m_elementName = string3;
                this.m_elemContext.m_elementDesc = elemDesc;
                return;
            }
            this.m_elemContext = elemContext = elemContext.push(string, string2, string3);
            elemContext.m_elementDesc = elemDesc;
            boolean bl = elemContext.m_isRaw = (n & 0x100) != 0;
            if ((n & 0x400000) != 0) {
                this.closeStartTag();
                elemContext.m_startTagOpen = false;
                if (!this.m_omitMetaTag) {
                    if (this.m_doIndent) {
                        this.indent();
                    }
                    writer.write("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
                    String string4 = this.getEncoding();
                    String string5 = Encodings.getMimeEncoding(string4);
                    writer.write(string5);
                    writer.write("\">");
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (null != string && string.length() > 0) {
            super.endElement(string, string2, string3);
            return;
        }
        try {
            int n;
            boolean bl;
            ElemContext elemContext = this.m_elemContext;
            ElemDesc elemDesc = elemContext.m_elementDesc;
            int n2 = elemDesc.getFlags();
            boolean bl2 = bl = (n2 & 2) != 0;
            if (this.m_doIndent) {
                boolean bl3 = (n2 & 8) != 0;
                n = 0;
                if (this.m_ispreserve) {
                    this.m_ispreserve = false;
                } else if (this.m_doIndent && (!this.m_inBlockElem || bl3)) {
                    this.m_startNewLine = true;
                    n = 1;
                }
                if (!elemContext.m_startTagOpen && n != 0) {
                    this.indent(elemContext.m_currentElemDepth - 1);
                }
                this.m_inBlockElem = !bl3;
            }
            Writer writer = this.m_writer;
            if (!elemContext.m_startTagOpen) {
                writer.write("</");
                writer.write(string3);
                writer.write(62);
            } else {
                if (this.m_tracer != null) {
                    super.fireStartElem(string3);
                }
                if ((n = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n);
                    this.m_attributes.clear();
                }
                if (!bl) {
                    writer.write("></");
                    writer.write(string3);
                    writer.write(62);
                } else {
                    writer.write(62);
                }
            }
            if ((n2 & 0x200000) != 0) {
                this.m_ispreserve = true;
            }
            this.m_isprevtext = false;
            if (this.m_tracer != null) {
                super.fireEndElem(string3);
            }
            if (bl) {
                this.m_elemContext = elemContext.m_prev;
                return;
            }
            if (!elemContext.m_startTagOpen && this.m_doIndent && !this.m_preserves.isEmpty()) {
                this.m_preserves.pop();
            }
            this.m_elemContext = elemContext.m_prev;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void processAttribute(Writer writer, String string, String string2, ElemDesc elemDesc) throws IOException {
        writer.write(32);
        if ((string2.length() == 0 || string2.equalsIgnoreCase(string)) && elemDesc != null && elemDesc.isAttrFlagSet(string, 4)) {
            writer.write(string);
        } else {
            writer.write(string);
            writer.write("=\"");
            if (elemDesc != null && elemDesc.isAttrFlagSet(string, 2)) {
                this.writeAttrURI(writer, string2, this.m_specialEscapeURLs);
            } else {
                this.writeAttrString(writer, string2, this.getEncoding());
            }
            writer.write(34);
        }
    }

    private boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static String makeHHString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private boolean isHHSign(String string) {
        boolean bl = true;
        try {
            char c = (char)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void writeAttrURI(Writer writer, String string, boolean bl) throws IOException {
        int n = string.length();
        if (n > this.m_attrBuff.length) {
            this.m_attrBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_attrBuff, 0);
        char[] cArray = this.m_attrBuff;
        int n2 = 0;
        int n3 = 0;
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c < ' ' || c > '~') {
                if (n3 > 0) {
                    writer.write(cArray, n2, n3);
                    n3 = 0;
                }
                if (bl) {
                    int n4;
                    int n5;
                    int n6;
                    if (c <= '\u007f') {
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(c));
                    } else if (c <= '\u07ff') {
                        n6 = c >> 6 | 0xC0;
                        n5 = c & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n6));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n5));
                    } else if (ToHTMLStream.isUTF16Surrogate(c)) {
                        n6 = c & 0x3FF;
                        n5 = (n6 & 0x3C0) >> 6;
                        n4 = n5 + 1;
                        int n7 = (n6 & 0x3C) >> 2;
                        int n8 = (n6 & 3) << 4 & 0x30;
                        c = cArray[++i];
                        int n9 = c & 0x3FF;
                        int n10 = n9 & 0x3F;
                        int n11 = 0xF0 | n4 >> 2;
                        int n12 = 0x80 | (n4 & 3) << 4 & 0x30 | n7;
                        int n13 = 0x80 | (n8 |= (n9 & 0x3C0) >> 6);
                        int n14 = 0x80 | n10;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n11));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n12));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n13));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n14));
                    } else {
                        n6 = c >> 12 | 0xE0;
                        n5 = (c & 0xFC0) >> 6 | 0x80;
                        n4 = c & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n6));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n5));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n4));
                    }
                } else if (this.escapingNotNeeded(c)) {
                    writer.write(c);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(c));
                    writer.write(59);
                }
                n2 = i + 1;
                continue;
            }
            if (c == '\"') {
                if (n3 > 0) {
                    writer.write(cArray, n2, n3);
                    n3 = 0;
                }
                if (bl) {
                    writer.write("%22");
                } else {
                    writer.write("&quot;");
                }
                n2 = i + 1;
                continue;
            }
            ++n3;
        }
        if (n3 > 1) {
            if (n2 == 0) {
                writer.write(string);
            } else {
                writer.write(cArray, n2, n3);
            }
        } else if (n3 == 1) {
            writer.write(c);
        }
    }

    public void writeAttrString(Writer writer, String string, String string2) throws IOException {
        int n = string.length();
        if (n > this.m_attrBuff.length) {
            this.m_attrBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_attrBuff, 0);
        char[] cArray = this.m_attrBuff;
        int n2 = 0;
        int n3 = 0;
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            int n4;
            c = cArray[i];
            if (this.escapingNotNeeded(c) && !this.m_charInfo.isSpecialAttrChar(c)) {
                ++n3;
                continue;
            }
            if ('<' == c || '>' == c) {
                ++n3;
                continue;
            }
            if ('&' == c && i + 1 < n && '{' == cArray[i + 1]) {
                ++n3;
                continue;
            }
            if (n3 > 0) {
                writer.write(cArray, n2, n3);
                n3 = 0;
            }
            if (i != (n4 = this.accumDefaultEntity(writer, c, i, cArray, n, false, false))) {
                i = n4 - 1;
            } else {
                String string3;
                if (ToHTMLStream.isUTF16Surrogate(c)) {
                    this.writeUTF16Surrogate(c, cArray, i, n);
                    ++i;
                }
                if (null != (string3 = this.m_charInfo.getEntityNameForChar(c))) {
                    writer.write(38);
                    writer.write(string3);
                    writer.write(59);
                } else if (this.escapingNotNeeded(c)) {
                    writer.write(c);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(c));
                    writer.write(59);
                }
            }
            n2 = i + 1;
        }
        if (n3 > 1) {
            if (n2 == 0) {
                writer.write(string);
            } else {
                writer.write(cArray, n2, n3);
            }
        } else if (n3 == 1) {
            writer.write(c);
        }
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_elemContext.m_isRaw) {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                this.writeNormalizedChars(cArray, n, n2, false, this.m_lineSepUse);
                if (this.m_tracer != null) {
                    super.fireCharEvent(cArray, n, n2);
                }
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
            }
        }
        super.characters(cArray, n, n2);
    }

    public final void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (null != this.m_elemContext.m_elementName && (this.m_elemContext.m_elementName.equalsIgnoreCase("SCRIPT") || this.m_elemContext.m_elementName.equalsIgnoreCase("STYLE"))) {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.writeNormalizedChars(cArray, n, n2, true, this.m_lineSepUse);
            }
            catch (IOException iOException) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
            }
        } else {
            super.cdata(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                } else if (this.m_needToCallStartDocument) {
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                Writer writer = this.m_writer;
                writer.write("<?");
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                writer.write(string2);
                writer.write(62);
                if (this.m_elemContext.m_currentElemDepth <= 0) {
                    this.outputLineSep();
                }
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public final void entityReference(String string) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void processAttributes(Writer writer, int n) throws IOException, SAXException {
        for (int i = 0; i < n; ++i) {
            this.processAttribute(writer, this.m_attributes.getQName(i), this.m_attributes.getValue(i), this.m_elemContext.m_elementDesc);
        }
    }

    protected void closeStartTag() throws SAXException {
        try {
            int n;
            if (this.m_tracer != null) {
                super.fireStartElem(this.m_elemContext.m_elementName);
            }
            if ((n = this.m_attributes.getLength()) > 0) {
                this.processAttributes(this.m_writer, n);
                this.m_attributes.clear();
            }
            this.m_writer.write(62);
            if (this.m_cdataSectionElements != null) {
                this.m_elemContext.m_isCdataSection = this.isCdataSection();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected synchronized void init(OutputStream outputStream, Properties properties) throws UnsupportedEncodingException {
        if (null == properties) {
            properties = OutputPropertiesFactory.getDefaultMethodProperties("html");
        }
        super.init(outputStream, properties, false);
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            Properties properties = null == this.m_format ? OutputPropertiesFactory.getDefaultMethodProperties("html") : this.m_format;
            this.init(outputStream, properties, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elemContext.m_elementURI == null && (string3 = ToHTMLStream.getPrefixPart(this.m_elemContext.m_elementName)) == null && "".equals(string)) {
            this.m_elemContext.m_elementURI = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.m_inDTD = true;
        super.startDTD(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void addUniqueAttribute(String string, String string2, int n) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if ((n & 1) > 0 && ToHTMLStream.m_htmlcharInfo.onlyQuotAmpLtGt) {
                writer.write(32);
                writer.write(string);
                writer.write("=\"");
                writer.write(string2);
                writer.write(34);
            } else if ((n & 2) > 0 && (string2.length() == 0 || string2.equalsIgnoreCase(string))) {
                writer.write(32);
                writer.write(string);
            } else {
                writer.write(32);
                writer.write(string);
                writer.write("=\"");
                if ((n & 4) > 0) {
                    this.writeAttrURI(writer, string2, this.m_specialEscapeURLs);
                } else {
                    this.writeAttrString(writer, string2, this.getEncoding());
                }
                writer.write(34);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        super.comment(cArray, n, n2);
    }

    public boolean reset() {
        boolean bl = super.reset();
        if (!bl) {
            return false;
        }
        this.initToHTMLStream();
        return true;
    }

    private void initToHTMLStream() {
        this.m_inBlockElem = false;
        this.m_inDTD = false;
        this.m_omitMetaTag = false;
        this.m_specialEscapeURLs = true;
    }

    static {
        m_elementFlags.put("BASEFONT", new ElemDesc(2));
        m_elementFlags.put("FRAME", new ElemDesc(10));
        m_elementFlags.put("FRAMESET", new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", new ElemDesc(8));
        m_elementFlags.put("ISINDEX", new ElemDesc(10));
        m_elementFlags.put("APPLET", new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", new ElemDesc(8));
        m_elementFlags.put("DIR", new ElemDesc(8));
        m_elementFlags.put("MENU", new ElemDesc(8));
        m_elementFlags.put("TT", new ElemDesc(4096));
        m_elementFlags.put("I", new ElemDesc(4096));
        m_elementFlags.put("B", new ElemDesc(4096));
        m_elementFlags.put("BIG", new ElemDesc(4096));
        m_elementFlags.put("SMALL", new ElemDesc(4096));
        m_elementFlags.put("EM", new ElemDesc(8192));
        m_elementFlags.put("STRONG", new ElemDesc(8192));
        m_elementFlags.put("DFN", new ElemDesc(8192));
        m_elementFlags.put("CODE", new ElemDesc(8192));
        m_elementFlags.put("SAMP", new ElemDesc(8192));
        m_elementFlags.put("KBD", new ElemDesc(8192));
        m_elementFlags.put("VAR", new ElemDesc(8192));
        m_elementFlags.put("CITE", new ElemDesc(8192));
        m_elementFlags.put("ABBR", new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", new ElemDesc(8192));
        m_elementFlags.put("SUP", new ElemDesc(98304));
        m_elementFlags.put("SUB", new ElemDesc(98304));
        m_elementFlags.put("SPAN", new ElemDesc(98304));
        m_elementFlags.put("BDO", new ElemDesc(98304));
        m_elementFlags.put("BR", new ElemDesc(98314));
        m_elementFlags.put("BODY", new ElemDesc(8));
        m_elementFlags.put("ADDRESS", new ElemDesc(56));
        m_elementFlags.put("DIV", new ElemDesc(56));
        m_elementFlags.put("A", new ElemDesc(32768));
        m_elementFlags.put("MAP", new ElemDesc(98312));
        m_elementFlags.put("AREA", new ElemDesc(10));
        m_elementFlags.put("LINK", new ElemDesc(131082));
        m_elementFlags.put("IMG", new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", new ElemDesc(2326528));
        m_elementFlags.put("PARAM", new ElemDesc(2));
        m_elementFlags.put("HR", new ElemDesc(58));
        m_elementFlags.put("P", new ElemDesc(56));
        m_elementFlags.put("H1", new ElemDesc(262152));
        m_elementFlags.put("H2", new ElemDesc(262152));
        m_elementFlags.put("H3", new ElemDesc(262152));
        m_elementFlags.put("H4", new ElemDesc(262152));
        m_elementFlags.put("H5", new ElemDesc(262152));
        m_elementFlags.put("H6", new ElemDesc(262152));
        m_elementFlags.put("PRE", new ElemDesc(0x100008));
        m_elementFlags.put("Q", new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", new ElemDesc(56));
        m_elementFlags.put("INS", new ElemDesc(0));
        m_elementFlags.put("DEL", new ElemDesc(0));
        m_elementFlags.put("DL", new ElemDesc(56));
        m_elementFlags.put("DT", new ElemDesc(8));
        m_elementFlags.put("DD", new ElemDesc(8));
        m_elementFlags.put("OL", new ElemDesc(524296));
        m_elementFlags.put("UL", new ElemDesc(524296));
        m_elementFlags.put("LI", new ElemDesc(8));
        m_elementFlags.put("FORM", new ElemDesc(8));
        m_elementFlags.put("LABEL", new ElemDesc(16384));
        m_elementFlags.put("INPUT", new ElemDesc(18434));
        m_elementFlags.put("SELECT", new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", new ElemDesc(0));
        m_elementFlags.put("OPTION", new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", new ElemDesc(24));
        m_elementFlags.put("LEGEND", new ElemDesc(0));
        m_elementFlags.put("BUTTON", new ElemDesc(18432));
        m_elementFlags.put("TABLE", new ElemDesc(56));
        m_elementFlags.put("CAPTION", new ElemDesc(8));
        m_elementFlags.put("THEAD", new ElemDesc(8));
        m_elementFlags.put("TFOOT", new ElemDesc(8));
        m_elementFlags.put("TBODY", new ElemDesc(8));
        m_elementFlags.put("COLGROUP", new ElemDesc(8));
        m_elementFlags.put("COL", new ElemDesc(10));
        m_elementFlags.put("TR", new ElemDesc(8));
        m_elementFlags.put("TH", new ElemDesc(0));
        m_elementFlags.put("TD", new ElemDesc(0));
        m_elementFlags.put("HEAD", new ElemDesc(0x400008));
        m_elementFlags.put("TITLE", new ElemDesc(8));
        m_elementFlags.put("BASE", new ElemDesc(10));
        m_elementFlags.put("META", new ElemDesc(131082));
        m_elementFlags.put("STYLE", new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", new ElemDesc(56));
        m_elementFlags.put("HTML", new ElemDesc(8));
        m_elementFlags.put("FONT", new ElemDesc(4096));
        m_elementFlags.put("S", new ElemDesc(4096));
        m_elementFlags.put("STRIKE", new ElemDesc(4096));
        m_elementFlags.put("U", new ElemDesc(4096));
        m_elementFlags.put("NOBR", new ElemDesc(4096));
        m_elementFlags.put("IFRAME", new ElemDesc(56));
        m_elementFlags.put("LAYER", new ElemDesc(56));
        m_elementFlags.put("ILAYER", new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("AREA");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LINK");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IFRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("ILAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DIV");
        elemDesc.setAttr("SRC", 2);
        m_dummy = new ElemDesc(8);
    }
}

