/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.dom;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BitArray
implements Externalizable {
    private int[] _bits;
    private int _bitSize;
    private int _intSize;
    private int _mask;
    private static final int[] _masks = new int[]{Integer.MIN_VALUE, 0x40000000, 0x20000000, 0x10000000, 0x8000000, 0x4000000, 0x2000000, 0x1000000, 0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};
    private static final boolean DEBUG_ASSERTIONS = false;
    private int _pos = Integer.MAX_VALUE;
    private int _node = 0;
    private int _int = 0;
    private int _bit = 0;
    int _first = Integer.MAX_VALUE;
    int _last = Integer.MIN_VALUE;

    public BitArray() {
        this(32);
    }

    public BitArray(int n) {
        if (n < 32) {
            n = 32;
        }
        this._bitSize = n;
        this._intSize = (this._bitSize >>> 5) + 1;
        this._bits = new int[this._intSize + 1];
    }

    public BitArray(int n, int[] nArray) {
        if (n < 32) {
            n = 32;
        }
        this._bitSize = n;
        this._intSize = (this._bitSize >>> 5) + 1;
        this._bits = nArray;
    }

    public void setMask(int n) {
        this._mask = n;
    }

    public int getMask() {
        return this._mask;
    }

    public final int size() {
        return this._bitSize;
    }

    public final boolean getBit(int n) {
        return (this._bits[n >>> 5] & _masks[n % 32]) != 0;
    }

    public final int getNextBit(int n) {
        for (int i = n >>> 5; i <= this._intSize; ++i) {
            int n2 = this._bits[i];
            if (n2 != 0) {
                for (int j = n % 32; j < 32; ++j) {
                    if ((n2 & _masks[j]) == 0) continue;
                    return (i << 5) + j;
                }
            }
            n = 0;
        }
        return -1;
    }

    public final int getBitNumber(int n) {
        if (n == this._pos) {
            return this._node;
        }
        if (n < this._pos) {
            this._pos = 0;
            this._bit = 0;
            this._int = 0;
        }
        while (this._int <= this._intSize) {
            int n2 = this._bits[this._int];
            if (n2 != 0) {
                while (this._bit < 32) {
                    if ((n2 & _masks[this._bit]) != 0 && ++this._pos == n) {
                        this._node = (this._int << 5) + this._bit - 1;
                        return this._node;
                    }
                    ++this._bit;
                }
                this._bit = 0;
            }
            ++this._int;
        }
        return 0;
    }

    public final int[] data() {
        return this._bits;
    }

    public final void setBit(int n) {
        if (n >= this._bitSize) {
            return;
        }
        int n2 = n >>> 5;
        if (n2 < this._first) {
            this._first = n2;
        }
        if (n2 > this._last) {
            this._last = n2;
        }
        int n3 = n2;
        this._bits[n3] = this._bits[n3] | _masks[n % 32];
    }

    public final BitArray merge(BitArray bitArray) {
        if (this._last == -1) {
            this._bits = bitArray._bits;
        } else if (bitArray._last != -1) {
            int n;
            int n2 = this._first < bitArray._first ? this._first : bitArray._first;
            int n3 = n = this._last > bitArray._last ? this._last : bitArray._last;
            if (bitArray._intSize > this._intSize) {
                if (n > this._intSize) {
                    n = this._intSize;
                }
                for (int i = n2; i <= n; ++i) {
                    int n4 = i;
                    bitArray._bits[n4] = bitArray._bits[n4] | this._bits[i];
                }
                this._bits = bitArray._bits;
            } else {
                if (n > bitArray._intSize) {
                    n = bitArray._intSize;
                }
                for (int i = n2; i <= n; ++i) {
                    int n5 = i;
                    this._bits[n5] = this._bits[n5] | bitArray._bits[i];
                }
            }
        }
        return this;
    }

    public final void resize(int n) {
        if (n > this._bitSize) {
            this._intSize = (n >>> 5) + 1;
            int[] nArray = new int[this._intSize + 1];
            System.arraycopy(this._bits, 0, nArray, 0, (this._bitSize >>> 5) + 1);
            this._bits = nArray;
            this._bitSize = n;
        }
    }

    public BitArray cloneArray() {
        return new BitArray(this._intSize, this._bits);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this._bitSize);
        objectOutput.writeInt(this._mask);
        objectOutput.writeObject(this._bits);
        objectOutput.flush();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._bitSize = objectInput.readInt();
        this._intSize = (this._bitSize >>> 5) + 1;
        this._mask = objectInput.readInt();
        this._bits = (int[])objectInput.readObject();
    }
}

