/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.hsqldb;

import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.drive.data.persistence.IDatabase;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.dialect.HSQLDialect;
import org.hsqldb.jdbcDriver;
import org.osgi.service.component.ComponentContext;

public class HSQLDBComponent
implements IDatabase {
    private static Logger LOGGER = Logger.getLogger(HSQLDBComponent.class);
    private static final File DATABASE_DIR = new File("database");
    private static final String DATABASE_NAME = "adrive-db";
    private String dbPath;

    public String getConnectionUrl() {
        return "jdbc:hsqldb:" + this.dbPath;
    }

    public String getHibernateDialect() {
        return HSQLDialect.class.getName();
    }

    public String getJdbcDriverClass() {
        return jdbcDriver.class.getName();
    }

    public String getPassword() {
        return "";
    }

    public String getUsername() {
        return "sa";
    }

    public void initializeSchema() {
        try {
            Class.forName(this.getJdbcDriverClass());
        }
        catch (ClassNotFoundException e) {
            LOGGER.fatal((Object)"Failed to load JDBC driver", (Throwable)e);
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                InputStream sqlStream;
                connection = DriverManager.getConnection(this.getConnectionUrl(), this.getUsername(), this.getPassword());
                statement = connection.createStatement();
                int currentSchema = -1;
                try {
                    ResultSet rs = statement.executeQuery("SELECT version FROM Schema WHERE id = 0");
                    rs.next();
                    currentSchema = rs.getInt("version");
                }
                catch (SQLException sQLException) {}
                while ((sqlStream = this.retrieveDatabaseSchema(++currentSchema)) != null) {
                    String line;
                    if (LOGGER.isLogging(Level.DEBUG)) {
                        LOGGER.debug((Object)("Applying database schema #" + currentSchema));
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(sqlStream));
                    int currentLine = 0;
                    String completeLine = "";
                    while ((line = reader.readLine()) != null) {
                        ++currentLine;
                        if ((line = line.trim()).length() <= 0 || !(completeLine = String.valueOf(completeLine) + line).endsWith(";")) continue;
                        try {
                            try {
                                statement.execute(completeLine);
                            }
                            catch (SQLException e) {
                                LOGGER.error((Object)("[Line " + currentLine + "]" + e.getMessage()));
                                completeLine = "";
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            completeLine = "";
                            throw throwable;
                        }
                        completeLine = "";
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error initializing database schema.", (Throwable)e);
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e2) {
                        LOGGER.warn((Object)"Error closing statement.", (Throwable)e2);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e3) {
                        LOGGER.warn((Object)"Error closing statement.", (Throwable)e3);
                    }
                }
            }
            catch (SQLException e) {
                block42: {
                    LOGGER.error((Object)"Error initializing database schema.", (Throwable)e);
                    if (statement == null) break block42;
                    try {
                        statement.close();
                    }
                    catch (SQLException e4) {
                        LOGGER.warn((Object)"Error closing statement.", (Throwable)e4);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e5) {
                        LOGGER.warn((Object)"Error closing statement.", (Throwable)e5);
                    }
                }
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.warn((Object)"Error closing statement.", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.warn((Object)"Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    protected void activate(ComponentContext context) throws InterruptedException {
        if (LOGGER.isLogging(Level.TRACE)) {
            LOGGER.trace((Object)"{activate} Starting HSQL database...");
        }
        DATABASE_DIR.mkdir();
        this.dbPath = new File(DATABASE_DIR, DATABASE_NAME).getAbsolutePath();
        new File(DATABASE_DIR, "adrive-db.lck").delete();
    }

    private InputStream retrieveDatabaseSchema(int currentSchema) {
        String schemaFileName = "DatabaseSchema_" + currentSchema + ".sql";
        return HSQLDBComponent.class.getResourceAsStream(schemaFileName);
    }
}

