/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.preference.parser;

import com.adobe.csi.preference.PreferenceType;
import com.adobe.csi.preference.StorePreferenceRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StorePreferenceRequestParser {
    private final SAXParserFactory saxParserFactory;

    public StorePreferenceRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public StorePreferenceRequest parse(InputStream request) throws IOException {
        StorePreferenceRequest storePreferenceRequest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            storePreferenceRequest = handler.getStorePreferenceRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return storePreferenceRequest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ATTRIBUTE_KEY = "key";
        private static final String XML_ATTRIBUTE_TYPE = "type";
        private static final String XML_ATTRIBUTE_VALUE = "value";
        private static final String XML_ELEMENT_STORE_PREFERENCES_REQUEST = "storePreferencesRequest";
        private ParserState parserState = ParserState.INITIAL;
        private StorePreferenceRequest storePreferenceRequest;

        Handler() {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_STORE_PREFERENCES_REQUEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public StorePreferenceRequest getStorePreferenceRequest() {
            return this.storePreferenceRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_STORE_PREFERENCES_REQUEST)) {
                        this.storePreferenceRequest = new StorePreferenceRequest();
                        String key = attributes.getValue(XML_ATTRIBUTE_KEY);
                        String value = attributes.getValue(XML_ATTRIBUTE_VALUE);
                        String type = attributes.getValue(XML_ATTRIBUTE_TYPE);
                        if (key == null) {
                            throw new SAXException("key is null");
                        }
                        this.storePreferenceRequest.setKey(key);
                        if (value == null) {
                            throw new SAXException("value is null");
                        }
                        this.storePreferenceRequest.setValue(value);
                        if (type == null) {
                            throw new SAXException("type is null");
                        }
                        PreferenceType preferenceType = null;
                        PreferenceType[] preferenceTypeArray = PreferenceType.values();
                        int n = preferenceTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            PreferenceType currentType = preferenceTypeArray[n2];
                            if (currentType.toString().equals(type)) {
                                preferenceType = currentType;
                                break;
                            }
                            ++n2;
                        }
                        if (preferenceType == null) {
                            throw new SAXException("preferenceType is invalid");
                        }
                        this.storePreferenceRequest.setType(preferenceType);
                        this.parserState = ParserState.ELEMENT_STORE_PREFERENCES_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_STORE_PREFERENCES_REQUEST: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_STORE_PREFERENCES_REQUEST,
            INITIAL;

        }
    }
}

