/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.preference.parser;

import com.adobe.csi.preference.RetrievePreferenceRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RetrievePreferenceRequestParser {
    private final SAXParserFactory saxParserFactory;

    public RetrievePreferenceRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public RetrievePreferenceRequest parse(InputStream request) throws IOException {
        RetrievePreferenceRequest retrievePreferenceRequest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            retrievePreferenceRequest = handler.getRetrievePreferenceRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return retrievePreferenceRequest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ATTRIBUTE_KEY = "key";
        private static final String XML_ELEMENT_RETRIEVE_PREFERENCES_REQUEST = "retrievePreferencesRequest";
        private ParserState parserState = ParserState.INITIAL;
        private RetrievePreferenceRequest retrievePreferenceRequest;

        Handler() {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_RETRIEVE_PREFERENCES_REQUEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public RetrievePreferenceRequest getRetrievePreferenceRequest() {
            return this.retrievePreferenceRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_RETRIEVE_PREFERENCES_REQUEST)) {
                        this.retrievePreferenceRequest = new RetrievePreferenceRequest();
                        String key = attributes.getValue(XML_ATTRIBUTE_KEY);
                        if (key == null) {
                            throw new SAXException("key is null");
                        }
                        this.retrievePreferenceRequest.setKey(key);
                        this.parserState = ParserState.ELEMENT_RETRIEVE_PREFERENCES_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_RETRIEVE_PREFERENCES_REQUEST: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_RETRIEVE_PREFERENCES_REQUEST,
            INITIAL;

        }
    }
}

