/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.preference.parser;

import com.adobe.csi.preference.DeletePreferenceRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeletePreferenceRequestParser {
    private final SAXParserFactory saxParserFactory;

    public DeletePreferenceRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public DeletePreferenceRequest parse(InputStream request) throws IOException {
        DeletePreferenceRequest deletePreferenceRequest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            deletePreferenceRequest = handler.getDeletePreferenceRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return deletePreferenceRequest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ATTRIBUTE_KEY = "key";
        private static final String XML_ELEMENT_DELETE_PREFERENCES_REQUEST = "deletePreferencesRequest";
        private DeletePreferenceRequest deletePreferenceRequest;
        private ParserState parserState = ParserState.INITIAL;

        Handler() {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_DELETE_PREFERENCES_REQUEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public DeletePreferenceRequest getDeletePreferenceRequest() {
            return this.deletePreferenceRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_DELETE_PREFERENCES_REQUEST)) {
                        this.deletePreferenceRequest = new DeletePreferenceRequest();
                        String key = attributes.getValue(XML_ATTRIBUTE_KEY);
                        if (key == null) {
                            throw new SAXException("key is null");
                        }
                        this.deletePreferenceRequest.setKey(key);
                        this.parserState = ParserState.ELEMENT_DELETE_PREFERENCES_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_DELETE_PREFERENCES_REQUEST: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_DELETE_PREFERENCES_REQUEST,
            INITIAL;

        }
    }
}

