/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.preference.handler;

import com.adobe.csi.internal.preference.parser.StorePreferenceRequestParser;
import com.adobe.csi.internal.preference.parser.StorePreferencesResponseBuilder;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import com.adobe.csi.preference.IPreferenceService;
import com.adobe.csi.preference.PreferenceServiceException;
import com.adobe.csi.preference.StatusCode;
import com.adobe.csi.preference.StorePreferenceRequest;
import com.adobe.csi.preference.StorePreferenceResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;

public class StorePreferenceInvocationHandler
implements IExtensionInvocationHandler {
    private IPreferenceService preferenceService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) {
        StorePreferenceResponse storePreferenceResponse = new StorePreferenceResponse();
        StorePreferenceRequest storePreferenceRequest = null;
        try {
            storePreferenceRequest = this.deserializeRequest(request);
            if ("".equals(storePreferenceRequest.getKey().trim())) {
                throw new PreferenceServiceException("Empty key value not permitted");
            }
            this.preferenceService.storePreference(extensionId, storePreferenceRequest.getKey(), storePreferenceRequest.getValue(), storePreferenceRequest.getType());
            storePreferenceResponse.setKey(storePreferenceRequest.getKey());
            storePreferenceResponse.setStatus(StatusCode.ok);
        }
        catch (PreferenceServiceException e) {
            if (storePreferenceRequest != null) {
                storePreferenceResponse.setKey(storePreferenceRequest.getKey());
            }
            storePreferenceResponse.setStatus(StatusCode.error);
            storePreferenceResponse.setMessage(e.getMessage());
        }
        catch (IOException e) {
            storePreferenceResponse.setStatus(StatusCode.error);
            storePreferenceResponse.setMessage(e.getMessage());
        }
        String result = null;
        try {
            result = this.serialize(storePreferenceResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void bindPreferenceService(IPreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    protected void unbindPreferenceService(IPreferenceService preferenceService) {
        this.preferenceService = null;
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = null;
    }

    private StorePreferenceRequest deserializeRequest(String request) throws IOException {
        StorePreferenceRequest storePreferenceRequest = null;
        StorePreferenceRequestParser storePreferenceRequestParser = new StorePreferenceRequestParser(this.saxParserFactory);
        storePreferenceRequest = storePreferenceRequestParser.parse(new ByteArrayInputStream(request.getBytes("UTF-8")));
        return storePreferenceRequest;
    }

    private String serialize(StorePreferenceResponse storePreferenceResponse) throws IOException {
        StorePreferencesResponseBuilder builder = new StorePreferencesResponseBuilder();
        return builder.build(storePreferenceResponse);
    }
}

