/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.preference.handler;

import com.adobe.csi.internal.preference.parser.RetrievePreferenceRequestParser;
import com.adobe.csi.internal.preference.parser.RetrievePreferenceResponseBuilder;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import com.adobe.csi.preference.IPreferenceService;
import com.adobe.csi.preference.PreferenceServiceException;
import com.adobe.csi.preference.PreferenceType;
import com.adobe.csi.preference.RetrievePreferenceRequest;
import com.adobe.csi.preference.RetrievePreferenceResponse;
import com.adobe.csi.preference.StatusCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;

public class RetrievePreferenceInvocationHandler
implements IExtensionInvocationHandler {
    private IPreferenceService preferenceService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        RetrievePreferenceResponse retrievePreferenceResponse = new RetrievePreferenceResponse();
        RetrievePreferenceRequest retrievePreferenceRequest = null;
        try {
            retrievePreferenceRequest = this.deserializeRequest(request);
            if ("".equals(retrievePreferenceRequest.getKey().trim())) {
                throw new PreferenceServiceException("Empty key value not permitted");
            }
            String value = this.preferenceService.retrievePreference(extensionId, retrievePreferenceRequest.getKey());
            if (value != null) {
                String type = this.preferenceService.retrievePreferenceType(extensionId, retrievePreferenceRequest.getKey());
                PreferenceType preferenceType = null;
                PreferenceType[] preferenceTypeArray = PreferenceType.values();
                int n = preferenceTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PreferenceType currentType = preferenceTypeArray[n2];
                    if (currentType.toString().equalsIgnoreCase(type)) {
                        preferenceType = currentType;
                        break;
                    }
                    ++n2;
                }
                retrievePreferenceResponse.setKey(retrievePreferenceRequest.getKey());
                retrievePreferenceResponse.setType(preferenceType);
                retrievePreferenceResponse.setValue(value);
                retrievePreferenceResponse.setStatus(StatusCode.ok);
            } else {
                retrievePreferenceResponse.setKey(retrievePreferenceRequest.getKey());
                retrievePreferenceResponse.setStatus(StatusCode.error);
                retrievePreferenceResponse.setMessage("Failed to retrieve preferences.");
            }
        }
        catch (PreferenceServiceException e) {
            if (retrievePreferenceRequest != null) {
                retrievePreferenceResponse.setKey(retrievePreferenceRequest.getKey());
            }
            retrievePreferenceResponse.setStatus(StatusCode.error);
            retrievePreferenceResponse.setMessage(e.getMessage());
        }
        catch (IOException e) {
            retrievePreferenceResponse.setStatus(StatusCode.error);
            retrievePreferenceResponse.setMessage(e.getMessage());
        }
        String result = null;
        try {
            result = this.serialize(retrievePreferenceResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void bindPreferenceService(IPreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    protected void unbindPreferenceService(IPreferenceService preferenceService) {
        this.preferenceService = null;
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = null;
    }

    private RetrievePreferenceRequest deserializeRequest(String request) throws IOException {
        RetrievePreferenceRequest retrievePreferenceRequest = null;
        RetrievePreferenceRequestParser retrievePreferenceRequestParser = new RetrievePreferenceRequestParser(this.saxParserFactory);
        retrievePreferenceRequest = retrievePreferenceRequestParser.parse(new ByteArrayInputStream(request.getBytes("UTF-8")));
        return retrievePreferenceRequest;
    }

    private String serialize(RetrievePreferenceResponse retrievePreferenceResponse) throws IOException {
        RetrievePreferenceResponseBuilder builder = new RetrievePreferenceResponseBuilder();
        return builder.build(retrievePreferenceResponse);
    }
}

