/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.preference.handler;

import com.adobe.csi.internal.preference.parser.DeletePreferenceRequestParser;
import com.adobe.csi.internal.preference.parser.DeletePreferencesResponseBuilder;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import com.adobe.csi.preference.DeletePreferenceRequest;
import com.adobe.csi.preference.DeletePreferenceResponse;
import com.adobe.csi.preference.IPreferenceService;
import com.adobe.csi.preference.PreferenceServiceException;
import com.adobe.csi.preference.StatusCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;

public class DeletePreferenceInvocationHandler
implements IExtensionInvocationHandler {
    private IPreferenceService preferenceService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        DeletePreferenceResponse deletePreferenceResponse = new DeletePreferenceResponse();
        DeletePreferenceRequest deletePreferenceRequest = null;
        try {
            deletePreferenceRequest = this.deserializeRequest(request);
            if ("".equals(deletePreferenceRequest.getKey().trim())) {
                throw new PreferenceServiceException("Empty key value not permitted");
            }
            this.preferenceService.deletePreference(extensionId, deletePreferenceRequest.getKey());
            deletePreferenceResponse.setKey(deletePreferenceRequest.getKey());
            deletePreferenceResponse.setStatus(StatusCode.ok);
        }
        catch (PreferenceServiceException e) {
            if (deletePreferenceRequest != null) {
                deletePreferenceResponse.setKey(deletePreferenceRequest.getKey());
            }
            deletePreferenceResponse.setStatus(StatusCode.error);
            deletePreferenceResponse.setMessage(e.getMessage());
        }
        catch (IOException e) {
            deletePreferenceResponse.setStatus(StatusCode.error);
            deletePreferenceResponse.setMessage(e.getMessage());
        }
        String result = null;
        try {
            result = this.serialize(deletePreferenceResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void bindPreferenceService(IPreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    protected void unbindPreferenceService(IPreferenceService preferenceService) {
        this.preferenceService = null;
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = null;
    }

    private DeletePreferenceRequest deserializeRequest(String request) throws IOException {
        DeletePreferenceRequest deletePreferenceRequest = null;
        DeletePreferenceRequestParser deletePreferenceRequestParser = new DeletePreferenceRequestParser(this.saxParserFactory);
        deletePreferenceRequest = deletePreferenceRequestParser.parse(new ByteArrayInputStream(request.getBytes("UTF-8")));
        return deletePreferenceRequest;
    }

    private String serialize(DeletePreferenceResponse deletePreferenceResponse) throws IOException {
        DeletePreferencesResponseBuilder builder = new DeletePreferencesResponseBuilder();
        return builder.build(deletePreferenceResponse);
    }
}

