/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.preference;

import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.preference.IPreferenceService;
import com.adobe.csi.preference.PreferenceServiceException;
import com.adobe.csi.preference.PreferenceType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.osgi.service.component.ComponentContext;

public class PropertiesFilePreferenceService
implements IPreferenceService {
    private static final Logger LOGGER = Logger.getLogger(PropertiesFilePreferenceService.class);
    private static final String PROP_PROPERTIES_FILE_LOCATION = "com.adobe.csi.preference.propertiesfile.location";
    private Properties properties;
    private File propertiesFile;

    public boolean deletePreference(String user, String key) throws PreferenceServiceException {
        boolean success;
        block9: {
            success = false;
            if (key.equals("AdobeOnlineDefault") || key.equals("AdobeOnlineUser")) {
                try {
                    RuntimeExec.deleteAdobeOnlineDefaultPropertyFromOsStore(key);
                    if (LOGGER.isLogging(Level.DEBUG)) {
                        LOGGER.debug((Object)("Deleted online preference: key=\"" + key + "\""));
                    }
                    success = true;
                }
                catch (IOException e) {
                    if (LOGGER.isLogging(Level.ERROR)) {
                        LOGGER.error((Object)("Error while storing online preference: " + e.getMessage()), (Throwable)e);
                    }
                    break block9;
                }
            }
            String userKey = this.createUserDistinctKey(user, key);
            String typeKey = this.createUserDistinctTypeKey(user, key);
            if (this.properties.containsKey(userKey)) {
                success = true;
                this.properties.remove(userKey);
                this.properties.remove(typeKey);
                try {
                    this.storeProperties();
                    if (LOGGER.isLogging(Level.DEBUG)) {
                        LOGGER.debug((Object)("Deleted preference: key=\"" + userKey + "\""));
                        LOGGER.debug((Object)("Deleted preference: key=\"" + typeKey + "\""));
                    }
                }
                catch (IOException e) {
                    throw new PreferenceServiceException("An error occurred while storing the preferences", e);
                }
            }
        }
        return success;
    }

    public String retrievePreference(String user, String key) {
        String value;
        block7: {
            value = null;
            if (key.equals("AdobeOnlineDefault") || key.equals("AdobeOnlineUser")) {
                try {
                    value = RuntimeExec.getAdobeOnlineDefaultPropertyFromOsStore(key);
                    if (LOGGER.isLogging(Level.DEBUG)) {
                        LOGGER.debug((Object)("Retrieved online preference: key=\"" + key + "\" value=\"" + value + "\""));
                    }
                    break block7;
                }
                catch (IOException e) {
                    if (LOGGER.isLogging(Level.ERROR)) {
                        LOGGER.error((Object)("Error while retrieving online preference: " + e.getMessage()), (Throwable)e);
                    }
                    break block7;
                }
            }
            String userKey = this.createUserDistinctKey(user, key);
            value = (String)this.properties.get(userKey);
            if (value == null) {
                String defaultKey = this.createDefaultKey(userKey);
                value = (String)this.properties.get(defaultKey);
            }
            if (LOGGER.isLogging(Level.DEBUG)) {
                LOGGER.debug((Object)("Retrieved preference: key=\"" + userKey + "\" value=\"" + value + "\""));
            }
        }
        return value;
    }

    public String retrievePreferenceType(String user, String key) {
        String value = null;
        if (key.equals("AdobeOnlineDefault") || key.equals("AdobeOnlineUser")) {
            value = PreferenceType.String.toString();
        } else {
            String typeKey = this.createUserDistinctTypeKey(user, key);
            value = (String)this.properties.get(typeKey);
            if (value == null) {
                String defaultKey = this.createDefaultKey(key);
                typeKey = this.createUserDistinctTypeKey(user, defaultKey);
                value = (String)this.properties.get(typeKey);
            }
            if (LOGGER.isLogging(Level.DEBUG)) {
                LOGGER.debug((Object)("Retrieved preference: key=\"" + typeKey + "\" value=\"" + value + "\""));
            }
        }
        return value;
    }

    public void storeDefaultPreference(String user, String key, String value, PreferenceType type) throws PreferenceServiceException {
        if (user == null) {
            throw new IllegalArgumentException("user must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        String defaultKey = this.createDefaultKey(key);
        this.storePreference(user, defaultKey, value, type);
    }

    public void storePreference(String user, String key, String value, PreferenceType type) throws PreferenceServiceException {
        block12: {
            if (user == null) {
                throw new IllegalArgumentException("user must not be null");
            }
            if (key == null) {
                throw new IllegalArgumentException("key must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("type must not be null");
            }
            if (key.equals("AdobeOnlineDefault") || key.equals("AdobeOnlineUser")) {
                try {
                    RuntimeExec.setAdobeOnlineDefaultPropertyToOsStore(key, value);
                    if (LOGGER.isLogging(Level.DEBUG)) {
                        LOGGER.debug((Object)("Stored online preference: key=\"" + key + "\" value=\"" + value + "\""));
                    }
                    break block12;
                }
                catch (IOException e) {
                    if (LOGGER.isLogging(Level.ERROR)) {
                        LOGGER.error((Object)("Error while storing online preference: " + e.getMessage()), (Throwable)e);
                    }
                    break block12;
                }
            }
            String userKey = this.createUserDistinctKey(user, key);
            String typeKey = this.createUserDistinctTypeKey(user, key);
            this.properties.put(userKey, value);
            this.properties.put(typeKey, type.toString());
            try {
                this.storeProperties();
                if (LOGGER.isLogging(Level.DEBUG)) {
                    LOGGER.debug((Object)("Stored preference: key=\"" + userKey + "\" value=\"" + value + "\""));
                    LOGGER.debug((Object)("Stored preference: key=\"" + typeKey + "\" value=\"" + type.toString() + "\""));
                }
            }
            catch (IOException e) {
                throw new PreferenceServiceException("An error occurred while storing the preferences", e);
            }
        }
    }

    protected void activate(ComponentContext context) throws IOException {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating IPreferenceService: " + PropertiesFilePreferenceService.class));
        }
        String propertiesFileLocation = (String)context.getProperties().get(PROP_PROPERTIES_FILE_LOCATION);
        this.initPropertiesFile(propertiesFileLocation);
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating IPreferenceService: " + PropertiesFilePreferenceService.class));
        }
    }

    private String createDefaultKey(String key) {
        return String.valueOf(key) + ".default";
    }

    private String createUserDistinctKey(String user, String key) {
        return String.valueOf(user) + "." + key;
    }

    private String createUserDistinctTypeKey(String user, String key) {
        return String.valueOf(user) + "." + key + ".type";
    }

    private void initPropertiesFile(String propertiesFileLocation) throws IOException {
        if (propertiesFileLocation == null || propertiesFileLocation.trim().equals("")) {
            propertiesFileLocation = String.valueOf(System.getProperty("user.dir")) + "/preference/";
        }
        this.properties = new Properties();
        File file = new File(propertiesFileLocation);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(file, "csi.pref");
        this.propertiesFile = file.getAbsoluteFile();
        if (file.exists()) {
            this.loadProperties();
        }
    }

    private void loadProperties() throws IOException {
        try {
            this.properties.load(new FileInputStream(this.propertiesFile));
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Loaded preferences from: " + this.propertiesFile));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("The preferences file could not be found: " + this.propertiesFile), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error while loading the preferences file: " + this.propertiesFile), (Throwable)e);
            throw e;
        }
    }

    private void storeProperties() throws IOException {
        try {
            this.properties.store(new FileOutputStream(this.propertiesFile), "Preferences for CSI");
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Saved preferences to: " + this.propertiesFile));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("The preferences file could not be found: " + this.propertiesFile), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error while saving the preferences file: " + this.propertiesFile), (Throwable)e);
            throw e;
        }
    }

    private static class RuntimeExec {
        private static final String MAC_FILE_SYSTEM = "/Library/Application Support/Adobe/AdobeOnlineDefault.txt";
        private static final String MAC_FILE_USER = String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/Adobe/AdobeOnlineDefault.txt";
        private static final String WIN_REG_KEY = "AdobeOnlineDefault";
        private static final String WIN_REG_PATH_SYSTEM = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Adobe\\";
        private static final String WIN_REG_PATH_USER = "HKEY_CURRENT_USER\\SOFTWARE\\Adobe\\";

        private RuntimeExec() {
        }

        public static void deleteAdobeOnlineDefaultPropertyFromOsStore(String key) throws IOException {
            if (RuntimeExec.isWin()) {
                RuntimeExec.deleteAdobeOnlineDefaultPropertyFromWinRegistry(key);
            } else if (RuntimeExec.isMac()) {
                RuntimeExec.deleteAdobeOnlineDefaultPropertyFromMacFile(key);
            }
        }

        public static String getAdobeOnlineDefaultPropertyFromOsStore(String key) throws IOException {
            String adobeOnlineDefault = null;
            if (RuntimeExec.isWin()) {
                adobeOnlineDefault = RuntimeExec.getAdobeOnlineDefaultPropertyFromWinRegistry(key);
            } else if (RuntimeExec.isMac()) {
                adobeOnlineDefault = RuntimeExec.getAdobeOnlineDefaultPropertyFromMacFile(key);
            }
            return adobeOnlineDefault;
        }

        public static void setAdobeOnlineDefaultPropertyToOsStore(String key, String adobeOnlineDefault) throws IOException {
            if (RuntimeExec.isWin()) {
                RuntimeExec.setAdobeOnlineDefaultPropertyToWinRegistry(key, adobeOnlineDefault);
            } else if (RuntimeExec.isMac()) {
                RuntimeExec.setAdobeOnlineDefaultPropertyToMacFile(key, adobeOnlineDefault);
            }
        }

        private static void deleteAdobeOnlineDefaultPropertyFromMacFile(String key) throws IOException {
            boolean delete;
            File file = null;
            if (key.equals(WIN_REG_KEY)) {
                file = new File(MAC_FILE_SYSTEM);
            } else if (key.equals("AdobeOnlineUser")) {
                file = new File(MAC_FILE_USER);
            } else {
                throw new IOException("Unknown preference");
            }
            if (!file.isFile()) {
                file.getParentFile().mkdirs();
            }
            if (file.isFile() && !(delete = file.delete())) {
                throw new IOException("File could not be deleted");
            }
        }

        private static void deleteAdobeOnlineDefaultPropertyFromWinRegistry(String key) throws IOException {
            String command = null;
            if (key.equals(WIN_REG_KEY)) {
                command = "reg delete HKEY_LOCAL_MACHINE\\SOFTWARE\\Adobe\\ /v AdobeOnlineDefault /f";
            } else if (key.equals("AdobeOnlineUser")) {
                command = "reg delete HKEY_CURRENT_USER\\SOFTWARE\\Adobe\\ /v AdobeOnlineDefault /f";
            } else {
                throw new IOException("Unknown preference");
            }
            RuntimeExec.execute(command);
        }

        private static String execute(String command) throws IOException {
            String inResponse = null;
            Process process = Runtime.getRuntime().exec(command);
            InputStream in = process.getInputStream();
            InputStream error = process.getErrorStream();
            inResponse = RuntimeExec.streamToString(in);
            RuntimeExec.streamToString(error);
            process.exitValue();
            return inResponse;
        }

        private static String getAdobeOnlineDefaultPropertyFromMacFile(String key) throws IOException {
            String value;
            String adobeOnlineDefault = "1";
            File file = null;
            if (key.equals(WIN_REG_KEY)) {
                file = new File(MAC_FILE_SYSTEM);
            } else if (key.equals("AdobeOnlineUser")) {
                file = new File(MAC_FILE_USER);
            } else {
                throw new IOException("Unknown preference");
            }
            if (file.isFile() && (value = RuntimeExec.streamToString(new FileInputStream(file))).equals("0")) {
                adobeOnlineDefault = "0";
            }
            return adobeOnlineDefault;
        }

        private static String getAdobeOnlineDefaultPropertyFromWinRegistry(String key) throws IOException {
            String property;
            String adobeOnlineDefault = "1";
            String response = null;
            String command = null;
            if (key.equals(WIN_REG_KEY)) {
                command = "reg query HKEY_LOCAL_MACHINE\\SOFTWARE\\Adobe\\ /v AdobeOnlineDefault";
            } else if (key.equals("AdobeOnlineUser")) {
                command = "reg query HKEY_CURRENT_USER\\SOFTWARE\\Adobe\\ /v AdobeOnlineDefault";
            } else {
                throw new IOException("Unknown preference");
            }
            response = RuntimeExec.execute(command);
            String[] parts = response.split("\\s+");
            if (parts.length == 5 && (property = parts[4]).charAt(0) == '0') {
                adobeOnlineDefault = "0";
            }
            return adobeOnlineDefault;
        }

        private static boolean isMac() {
            String osName = System.getProperty("os.name");
            return osName.toLowerCase().contains("mac");
        }

        private static boolean isWin() {
            String osName = System.getProperty("os.name");
            return osName.toLowerCase().contains("win");
        }

        private static void setAdobeOnlineDefaultPropertyToMacFile(String key, String adobeOnlineDefault) throws IOException {
            File file = null;
            if (key.equals(WIN_REG_KEY)) {
                file = new File(MAC_FILE_SYSTEM);
            } else if (key.equals("AdobeOnlineUser")) {
                file = new File(MAC_FILE_USER);
            } else {
                throw new IOException("Unknown preference");
            }
            if (!file.isFile()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            try {
                String property = adobeOnlineDefault.equals("0") ? "0" : "1";
                fos.write(property.getBytes());
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }

        private static void setAdobeOnlineDefaultPropertyToWinRegistry(String key, String adobeOnlineDefault) throws IOException {
            String property = adobeOnlineDefault.equals("0") ? "0000" : "1111";
            String command = null;
            if (key.equals(WIN_REG_KEY)) {
                command = "reg add HKEY_LOCAL_MACHINE\\SOFTWARE\\Adobe\\ /v AdobeOnlineDefault /t REG_BINARY  /d " + property + " /f";
            } else if (key.equals("AdobeOnlineUser")) {
                command = "reg add HKEY_CURRENT_USER\\SOFTWARE\\Adobe\\ /v AdobeOnlineDefault /t REG_BINARY  /d " + property + " /f";
            } else {
                throw new IOException("Unknown preference");
            }
            RuntimeExec.execute(command);
        }

        private static String streamToString(InputStream is) throws IOException {
            StringBuilder buffer = new StringBuilder();
            byte[] bytes = new byte[2048];
            int length = 0;
            BufferedInputStream bis = new BufferedInputStream(is);
            while ((length = bis.read(bytes)) > 0) {
                String content = new String(bytes, 0, length, "UTF-8");
                buffer.append(content);
            }
            return buffer.toString();
        }
    }
}

