/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.core.preferences;

import com.adobe.csi.core.preferences.ErrorCodeEnum;
import com.adobe.csi.core.preferences.IPreferences;
import com.adobe.csi.core.preferences.IPreferencesChangeListener;
import com.adobe.csi.core.preferences.IPreferencesService;
import com.adobe.csi.core.preferences.PreferencesException;
import com.adobe.csi.internal.core.preferences.PreferencesFactory;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService {
    private org.osgi.service.prefs.PreferencesService osgiPreferencesService;
    private Dictionary<String, String> defaultPreferences;
    Map<String, List<IPreferencesChangeListener>> listers;

    public IPreferences getPreferences() throws PreferencesException {
        Preferences osgiPreferences = this.osgiPreferencesService.getSystemPreferences();
        try {
            if (osgiPreferences.keys().length == 0) {
                this.initializePreferences(osgiPreferences);
            }
        }
        catch (BackingStoreException e) {
            throw new PreferencesException(ErrorCodeEnum.RETRIEVE_PREFS_FAILED, e.getMessage());
        }
        return new PreferencesChangeTracker(this.getPreferences(osgiPreferences));
    }

    public void savePreferences(IPreferences preferences) throws PreferencesException {
        Preferences osgiPreferences = this.osgiPreferencesService.getSystemPreferences();
        this.savePreferences(osgiPreferences, preferences);
    }

    protected void activate(ComponentContext context) {
        this.listers = new HashMap<String, List<IPreferencesChangeListener>>();
        com.adobe.csi.core.preferences.PreferencesFactory.setFactory(new PreferencesFactory());
        this.defaultPreferences = context.getProperties();
    }

    protected void deactivate(ComponentContext context) {
        this.defaultPreferences = null;
        com.adobe.csi.core.preferences.PreferencesFactory.setFactory(null);
    }

    public synchronized void addPreferencesChangeListener(String name, IPreferencesChangeListener changeListener) {
        if (this.listers != null) {
            List<IPreferencesChangeListener> listenerByName = this.listers.get(name);
            if (listenerByName == null) {
                listenerByName = new ArrayList<IPreferencesChangeListener>(2);
                this.listers.put(name, listenerByName);
            }
            listenerByName.add(changeListener);
        }
    }

    public synchronized void removePreferencesChangeListener(String name, IPreferencesChangeListener changeListener) {
        List<IPreferencesChangeListener> listenerByName;
        if (this.listers != null && (listenerByName = this.listers.get(name)) != null) {
            int i = 0;
            while (i < listenerByName.size()) {
                if (listenerByName.equals(changeListener)) {
                    listenerByName.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void setPreferencesService(org.osgi.service.prefs.PreferencesService osgiPreferencesService) {
        if (this.osgiPreferencesService == null) {
            this.osgiPreferencesService = osgiPreferencesService;
        }
    }

    public void unsetPreferencesService(org.osgi.service.prefs.PreferencesService osgiPreferencesService) {
        if (this.osgiPreferencesService == osgiPreferencesService) {
            this.osgiPreferencesService = null;
        }
    }

    private void initializePreferences(Preferences osgiPreferences) throws PreferencesException {
        try {
            osgiPreferences.put("cache_location", this.defaultPreferences.get("cache_location"));
            osgiPreferences.putInt("cache_size", new Integer(this.defaultPreferences.get("cache_size")).intValue());
            osgiPreferences.put("log_level", this.defaultPreferences.get("log_level"));
            osgiPreferences.put("log_location", this.defaultPreferences.get("log_location"));
            osgiPreferences.flush();
        }
        catch (NumberFormatException e) {
            throw new PreferencesException(ErrorCodeEnum.INVALID_PARAMETER, e.getMessage(), e);
        }
        catch (BackingStoreException e) {
            throw new PreferencesException(ErrorCodeEnum.STORE_PREFS_FAILED, e.getMessage(), e);
        }
    }

    private IPreferences getPreferences(Preferences osgiPreferences) throws PreferencesException {
        assert (osgiPreferences != null) : "osgiPreferences != null";
        IPreferences preferences = com.adobe.csi.core.preferences.PreferencesFactory.createPreferences();
        try {
            preferences.setValue("cache_location", osgiPreferences.get("cache_location", this.defaultPreferences.get("cache_location")));
            preferences.setValue("cache_size", osgiPreferences.getInt("cache_size", new Integer(this.defaultPreferences.get("cache_size")).intValue()));
            preferences.setValue("log_level", osgiPreferences.get("log_level", this.defaultPreferences.get("log_level")));
            preferences.setValue("log_location", osgiPreferences.get("log_location", this.defaultPreferences.get("log_location")));
        }
        catch (NumberFormatException e) {
            throw new PreferencesException(ErrorCodeEnum.INVALID_PARAMETER, e.getMessage(), e);
        }
        return preferences;
    }

    private void savePreferences(Preferences osgiPreferences, IPreferences preferences) throws PreferencesException {
        osgiPreferences.put("cache_location", preferences.getString("cache_location"));
        osgiPreferences.putInt("cache_size", preferences.getInt("cache_size"));
        osgiPreferences.put("log_level", preferences.getString("log_level"));
        osgiPreferences.put("log_location", preferences.getString("log_location"));
        try {
            osgiPreferences.flush();
        }
        catch (BackingStoreException e) {
            throw new PreferencesException(ErrorCodeEnum.STORE_PREFS_FAILED, e.getMessage(), e);
        }
        this.notifyChanges(preferences);
    }

    private synchronized void notifyChanges(IPreferences preferences) {
        if (this.listers != null && preferences instanceof PreferencesChangeTracker) {
            String[] names = ((PreferencesChangeTracker)preferences).getTrackedNames();
            preferences = new ImmutablePreferences(preferences);
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                List<IPreferencesChangeListener> listenerByName = this.listers.get(name);
                if (listenerByName != null) {
                    for (IPreferencesChangeListener pcl : listenerByName) {
                        pcl.changed(preferences);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmutablePreferences
    implements IPreferences {
        private IPreferences delegate;

        public ImmutablePreferences(IPreferences delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean getBoolean(String name) {
            return this.delegate.getBoolean(name);
        }

        @Override
        public int getInt(String name) {
            return this.delegate.getInt(name);
        }

        @Override
        public List<? extends Object> getList(String name) {
            return this.delegate.getList(name);
        }

        @Override
        public String getString(String name) {
            return this.delegate.getString(name);
        }

        @Override
        public void setDefault(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault(String name, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault(String name, List<? extends Object> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefault(String name, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(String name, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(String name, List<? extends Object> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(String name, String value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreferencesChangeTracker
    implements IPreferences {
        private IPreferences delegate;
        private Set<String> names;

        public PreferencesChangeTracker(IPreferences delegate) {
            this.delegate = delegate;
            this.names = new HashSet<String>();
        }

        public String[] getTrackedNames() {
            return this.names.toArray(new String[0]);
        }

        @Override
        public boolean getBoolean(String name) {
            return this.delegate.getBoolean(name);
        }

        @Override
        public int getInt(String name) {
            return this.delegate.getInt(name);
        }

        @Override
        public List<? extends Object> getList(String name) {
            return this.delegate.getList(name);
        }

        @Override
        public String getString(String name) {
            return this.delegate.getString(name);
        }

        @Override
        public void setDefault(String name, boolean value) {
            this.delegate.setDefault(name, value);
            this.names.add(name);
        }

        @Override
        public void setDefault(String name, int value) {
            this.delegate.setDefault(name, value);
            this.names.add(name);
        }

        @Override
        public void setDefault(String name, List<? extends Object> value) {
            this.delegate.setDefault(name, value);
            this.names.add(name);
        }

        @Override
        public void setDefault(String name, String value) {
            this.delegate.setDefault(name, value);
            this.names.add(name);
        }

        @Override
        public void setValue(String name, boolean value) {
            this.delegate.setValue(name, value);
            this.names.add(name);
        }

        @Override
        public void setValue(String name, int value) {
            this.delegate.setValue(name, value);
            this.names.add(name);
        }

        @Override
        public void setValue(String name, List<? extends Object> value) {
            this.delegate.setValue(name, value);
            this.names.add(name);
        }

        @Override
        public void setValue(String name, String value) {
            this.delegate.setValue(name, value);
            this.names.add(name);
        }
    }
}

