/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.nativecomm.msg;

import com.adobe.versioncue.nativecomm.msg.BadMessageException;
import com.adobe.versioncue.nativecomm.msg.INCExternalizable;
import com.adobe.versioncue.nativecomm.msg.NCBool;
import com.adobe.versioncue.nativecomm.msg.NCData;
import com.adobe.versioncue.nativecomm.msg.NCDouble;
import com.adobe.versioncue.nativecomm.msg.NCInt;
import com.adobe.versioncue.nativecomm.msg.NCList;
import com.adobe.versioncue.nativecomm.msg.NCLong;
import com.adobe.versioncue.nativecomm.msg.NCNumber;
import com.adobe.versioncue.nativecomm.msg.NCString;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NCMap
extends NCType {
    private final HashMap<NCType, NCType> map = new HashMap();

    public int size() {
        return this.map.size();
    }

    public boolean isEmtpy() {
        return this.map.isEmpty();
    }

    public Iterator<Map.Entry<NCType, NCType>> entries() {
        return this.map.entrySet().iterator();
    }

    public Set<Map.Entry<NCType, NCType>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(NCType key) {
        return this.map.containsKey(key);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(new NCString(key));
    }

    public NCMap put(NCType key, NCType value) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
        this.map.put(key, value);
        return this;
    }

    public NCMap put(String key, NCType value) {
        return this.put(new NCString(key), value);
    }

    public NCMap put(String key, INCExternalizable value) {
        return this.put(new NCString(key), value.externalize());
    }

    public NCMap put(String key, String value) {
        return this.put(new NCString(key), (NCType)new NCString(value));
    }

    public NCMap put(String key, boolean value) {
        return this.put(new NCString(key), (NCType)(value ? NCBool.TRUE : NCBool.FALSE));
    }

    public NCMap put(String key, int value) {
        return this.put(new NCString(key), (NCType)new NCInt(value));
    }

    public NCMap put(String key, long value) {
        return this.put(new NCString(key), (NCType)new NCLong(value));
    }

    public NCMap put(String key, double value) {
        return this.put(new NCString(key), (NCType)new NCDouble(value));
    }

    public NCMap put(String key, byte[] value) {
        return this.put(new NCString(key), (NCType)new NCData(value));
    }

    public NCMap put(String key, ByteBuffer value) {
        return this.put(new NCString(key), (NCType)new NCData(value));
    }

    public NCType get(NCType key) {
        return this.map.get(key);
    }

    public NCType get(String key) {
        return this.get(new NCString(key));
    }

    public String getString(String key) throws BadMessageException {
        NCString value = (NCString)this.checkedGet(key, NCString.class);
        return value.string();
    }

    public boolean getBool(String key) throws BadMessageException {
        NCBool value = (NCBool)this.checkedGet(key, NCBool.class);
        return value.booleanValue();
    }

    public double getDouble(String key) throws BadMessageException {
        NCNumber value = (NCNumber)this.checkedGet(key, NCNumber.class);
        return value.doubleValue();
    }

    public int getInt(String key) throws BadMessageException {
        NCNumber value = (NCNumber)this.checkedGet(key, NCNumber.class);
        return value.intValue();
    }

    public long getLong(String key) throws BadMessageException {
        NCNumber value = (NCNumber)this.checkedGet(key, NCNumber.class);
        return value.longValue();
    }

    public byte[] getByteArray(String key) throws BadMessageException {
        NCData value = (NCData)this.checkedGet(key, NCData.class);
        return value.byteArray();
    }

    public ByteBuffer getBytes(String key) throws BadMessageException {
        NCData value = (NCData)this.checkedGet(key, NCData.class);
        return value.bytes();
    }

    public NCList getList(String key) throws BadMessageException {
        return (NCList)this.checkedGet(key, NCList.class);
    }

    public NCMap getMap(String key) throws BadMessageException {
        return (NCMap)this.checkedGet(key, NCMap.class);
    }

    public NCType remove(NCType key) {
        return this.map.remove(key);
    }

    public NCType remove(String key) {
        return this.remove(new NCString(key));
    }

    public NCMap clear() {
        this.map.clear();
        return this;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof NCMap) {
            NCMap otherDict = (NCMap)other;
            return this.map.equals(otherDict.map);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        String nl = System.getProperty("line.separator");
        buf.append(this.getClass().getSimpleName()).append("\n{").append(nl);
        for (Map.Entry<NCType, NCType> entry : this.map.entrySet()) {
            buf.append("    ").append(entry.getKey()).append(": ").append(entry.getValue()).append(nl);
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private NCType checkedGet(String key, Class expectedType) throws BadMessageException {
        NCType value = this.get(key);
        if (!expectedType.isInstance(value)) {
            throw new BadMessageException("Expected <" + expectedType + "> for key '" + key + "'. Actual value: " + value);
        }
        return value;
    }
}

