/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.nativecomm;

import com.adobe.versioncue.internal.nativecomm.NativeService;
import com.adobe.versioncue.internal.nativecomm.ServiceBuilder;
import com.adobe.versioncue.internal.nativecomm.ServiceConfig;
import com.adobe.versioncue.internal.nativecomm.io.TCPConnection;
import com.adobe.versioncue.nativecomm.INativeService;
import com.adobe.versioncue.nativecomm.IServiceBuilder;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.io.IConnection;
import com.adobe.versioncue.nativecomm.io.IConnectionFactory;
import java.io.File;

public final class NativeComm {
    private static String defaultCommand;
    private static File defaultTmpDir;
    private static File defaultLogDir;

    static {
        switch (OS.current) {
            case win32: {
                defaultCommand = "VCNativeHelper.exe";
                break;
            }
            default: {
                defaultCommand = "VCNativeHelper";
            }
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        defaultTmpDir = tmpDir.getAbsoluteFile();
        defaultLogDir = new File("logs").getAbsoluteFile();
    }

    public static IServiceBuilder serviceBuilder(String id) {
        return new ServiceBuilder(id).command(defaultCommand).tmpDir(defaultTmpDir).logDir(defaultLogDir);
    }

    public static INativeService service(String id, final int port) {
        final ServiceConfig cfg = new ServiceConfig(id);
        cfg.maxConnections(2);
        IConnectionFactory factory = new IConnectionFactory(){

            public IConnection[] connect(INativeService service) throws NativeCommException {
                TCPConnection con = new TCPConnection(cfg, port);
                return new IConnection[]{con};
            }
        };
        return new NativeService(cfg, factory);
    }

    public static String getDefaultCommand() {
        return defaultCommand;
    }

    public static File getDefaultTmpDir() {
        return defaultTmpDir;
    }

    public static File getDefaultLogDir() {
        return defaultLogDir;
    }

    public static void setDefaultCommand(String command) {
        defaultCommand = command;
    }

    public static void setDefaultTmpDir(File tmpDir) {
        defaultTmpDir = tmpDir.getAbsoluteFile();
    }

    public static void setDefaultLogDir(File logDir) {
        defaultLogDir = logDir.getAbsoluteFile();
    }

    private NativeComm() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        win32,
        linux,
        macosx,
        unknown;

        public static final OS current;

        static {
            String os = System.getProperty("os.name").toLowerCase();
            current = os.startsWith("mac os x") ? macosx : (os.startsWith("win") ? win32 : (os.startsWith("linux") ? linux : unknown));
        }

        public static boolean isWin32() {
            return current == win32;
        }

        public static boolean isLinux() {
            return current == linux;
        }

        public static boolean isMacOSX() {
            return current == macosx;
        }
    }
}

