/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.io;

import com.adobe.versioncue.internal.nativecomm.ServiceConfig;
import com.adobe.versioncue.internal.nativecomm.io.SerializerFactory;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.ServiceTimeoutException;
import com.adobe.versioncue.nativecomm.io.IConnection;
import com.adobe.versioncue.nativecomm.io.ISerializer;
import com.adobe.versioncue.nativecomm.msg.INCExternalizable;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;

public final class TCPConnection
implements IConnection {
    private final Socket socket;
    private final ISerializer serializer;

    public TCPConnection(ServiceConfig config, int port) throws NativeCommException {
        assert (config != null) : "config != null";
        try {
            this.socket = this.establishConnection(port);
            this.serializer = SerializerFactory.getInstance().serializer(new BufferedInputStream(this.socket.getInputStream()), new BufferedOutputStream(this.socket.getOutputStream()));
        }
        catch (IOException ioe) {
            this.dispose();
            throw new NativeCommException("Socket connection failed <" + config.id() + "> - " + ioe, ioe);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public boolean isValid() {
        return this.serializer.isValid();
    }

    public void beginTransaction() {
        this.throwIfNotValid();
    }

    public NCType read(int timeout) throws NativeCommException {
        try {
            this.socket.setSoTimeout(timeout);
            NCType result = this.serializer.read();
            return result;
        }
        catch (IOException ioe) {
            throw this.handleException(ioe);
        }
    }

    public void write(INCExternalizable message, int timeout) throws NativeCommException {
        try {
            this.socket.setSoTimeout(timeout);
            this.serializer.write(message.externalize()).flush();
        }
        catch (IOException ioe) {
            throw this.handleException(ioe);
        }
    }

    public void endTransaction() {
    }

    public void dispose() {
        if (this.serializer != null) {
            this.serializer.dispose();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void throwIfNotValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    private NativeCommException handleException(IOException ioe) {
        this.dispose();
        if (ioe instanceof SocketTimeoutException) {
            return new ServiceTimeoutException(ioe.getMessage());
        }
        return new NativeCommException("Connection terminated", ioe);
    }

    private Socket establishConnection(int port) throws IOException {
        Socket result = new Socket("localhost", port);
        result.setTcpNoDelay(true);
        result.setSendBufferSize(Math.max(65536, result.getSendBufferSize()));
        result.setSoTimeout(0);
        return result;
    }
}

