/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.io;

import com.adobe.versioncue.internal.nativecomm.NativeProcess;
import com.adobe.versioncue.internal.nativecomm.ProcessLauncher;
import com.adobe.versioncue.internal.nativecomm.ServiceConfig;
import com.adobe.versioncue.internal.nativecomm.io.SerializerFactory;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.ServiceTimeoutException;
import com.adobe.versioncue.nativecomm.io.IConnection;
import com.adobe.versioncue.nativecomm.io.ISerializer;
import com.adobe.versioncue.nativecomm.msg.INCExternalizable;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public final class SocketConnection
implements IConnection {
    private final ServiceConfig config;
    private final NativeProcess process;
    private final Socket socket;
    private final ISerializer serializer;

    public static IConnection[] connect(ServiceConfig config) throws NativeCommException {
        ServerSocket server = SocketConnection.openServerSocket(config);
        int port = server.getLocalPort();
        try {
            int count = config.connectionsPerProcess();
            IConnection[] result = new IConnection[count];
            NativeProcess proc = new NativeProcess(SocketConnection.launchProcess(config, port));
            int i = 0;
            while (i < count) {
                Socket socket = SocketConnection.establishConnection(server);
                result[i] = new SocketConnection(config, proc, socket);
                ++i;
            }
            IConnection[] iConnectionArray = result;
            return iConnectionArray;
        }
        catch (IOException ioe) {
            throw new NativeCommException("Socket connection failed <" + config.id() + "> - " + ioe, ioe);
        }
        finally {
            SocketConnection.safeClose(server);
        }
    }

    private static ServerSocket openServerSocket(ServiceConfig config) throws NativeCommException {
        try {
            int port = config.debugPort();
            int backlog = config.connectionsPerProcess();
            InetAddress lo = InetAddress.getByName(null);
            ServerSocket server = new ServerSocket(port, backlog, lo);
            server.setSoTimeout(config.launchTimeout());
            server.setReceiveBufferSize(Math.max(65536, server.getReceiveBufferSize()));
            return server;
        }
        catch (IOException ioe) {
            throw new NativeCommException("Failed to open ServerSocket <" + config.id() + "> - " + ioe, ioe);
        }
    }

    private static Socket establishConnection(ServerSocket server) throws IOException {
        Socket result = server.accept();
        result.setTcpNoDelay(true);
        result.setSendBufferSize(Math.max(65536, result.getSendBufferSize()));
        result.setSoTimeout(0);
        return result;
    }

    private static Process launchProcess(ServiceConfig config, int port) throws NativeCommException, IOException {
        if (config.isDebug()) {
            System.out.println("Waiting for <" + config.id() + "> service on port: " + port);
            return null;
        }
        return new ProcessLauncher(config).launch(new String[]{"-port", Integer.toString(port)});
    }

    private static void safeClose(ServerSocket sock) {
        try {
            sock.close();
        }
        catch (Throwable throwable) {}
    }

    private SocketConnection(ServiceConfig config, NativeProcess process, Socket socket) throws NativeCommException {
        assert (config != null) : "config != null";
        assert (process != null) : "process != null";
        assert (socket != null) : "socket != null";
        this.config = config;
        this.process = process;
        this.socket = socket;
        process.registerConnection(this);
        try {
            this.serializer = SerializerFactory.getInstance().serializer(new BufferedInputStream(socket.getInputStream()), new BufferedOutputStream(socket.getOutputStream()));
        }
        catch (IOException ioe) {
            this.dispose();
            throw new NativeCommException("Socket connection failed <" + config.id() + "> - " + ioe, ioe);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public boolean isValid() {
        return this.serializer.isValid();
    }

    public void beginTransaction() {
        this.throwIfNotValid();
    }

    public NCType read(int timeout) throws NativeCommException {
        try {
            this.socket.setSoTimeout(timeout);
            NCType result = this.serializer.read();
            return result;
        }
        catch (IOException ioe) {
            throw this.handleException(ioe);
        }
    }

    public void write(INCExternalizable message, int timeout) throws NativeCommException {
        try {
            this.socket.setSoTimeout(timeout);
            this.serializer.write(message.externalize()).flush();
        }
        catch (IOException ioe) {
            throw this.handleException(ioe);
        }
    }

    public void endTransaction() {
        if (this.process.incRequestCount() >= this.config.maxRequests()) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.serializer != null) {
            this.serializer.dispose();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
        if (this.process != null) {
            this.process.deregisterConnection(this);
            this.process.waitAndKill(this.config.terminationTimeout());
        }
    }

    private void throwIfNotValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    private NativeCommException handleException(IOException ioe) {
        this.dispose();
        if (ioe instanceof SocketTimeoutException) {
            return new ServiceTimeoutException(ioe.getMessage());
        }
        return new NativeCommException("Process crashed <" + this.pid() + ">", ioe);
    }

    private int pid() {
        try {
            return this.serializer.handshake().getInt("pid");
        }
        catch (Throwable throwable) {
            return 0;
        }
    }
}

