/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.io;

import com.adobe.versioncue.internal.nativecomm.TimeOut;
import com.adobe.versioncue.internal.nativecomm.io.Serializer;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.ServiceTimeoutException;
import com.adobe.versioncue.nativecomm.io.ISerializer;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SerializerFactory {
    private static final byte[] NCOMM_TAG = new byte[]{86, 67, 78, 67};
    private static final int PROTCOL_VERSION = 200;
    private static final int PROTCOL_MIN_VERSION = 200;
    private static final SerializerFactory INSTANCE = new SerializerFactory();

    public static SerializerFactory getInstance() {
        return INSTANCE;
    }

    private SerializerFactory() {
    }

    public ISerializer serializer(final InputStream in, final OutputStream out) throws NativeCommException {
        try {
            return TimeOut.execute(new TimeOut.ITarget<ISerializer>(){

                @Override
                public ISerializer call() throws NativeCommException {
                    try {
                        return SerializerFactory.this.createSerializer(in, out);
                    }
                    catch (IOException ioe) {
                        throw new NativeCommException("I/O error initializing connection", ioe);
                    }
                }

                @Override
                public void timeout() {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }, 50000);
        }
        catch (TimeOut.TimeoutException timeoutException) {
            throw new ServiceTimeoutException("handshake timeout");
        }
    }

    private ISerializer createSerializer(InputStream in, OutputStream out) throws IOException, NativeCommException {
        int proto = this.readStreamPrefix(in);
        switch (proto) {
            case 200: {
                Serializer result = new Serializer(in, out);
                result.handshake(this.doHandshake(result));
                return result;
            }
        }
        throw new NativeCommException("Connection handshake failed (protocol: " + proto + ")");
    }

    private int readStreamPrefix(InputStream in) throws IOException, NativeCommException {
        byte[] buf = new byte[8];
        if (in.read(buf) != buf.length) {
            throw new EOFException();
        }
        if (NCOMM_TAG[0] != buf[0] || NCOMM_TAG[1] != buf[1] || NCOMM_TAG[2] != buf[2] || NCOMM_TAG[3] != buf[3]) {
            throw new NativeCommException("Bad ncomm stream (missing 'VCNC' tag)");
        }
        int proto = buf[4] << 24 | (0xFF & buf[5]) << 16 | (0xFF & buf[6]) << 8 | 0xFF & buf[7];
        return proto;
    }

    private NCMap doHandshake(ISerializer serializer) throws IOException, NativeCommException {
        int version = -1;
        int protcol = -1;
        NCType incoming = serializer.read();
        if (incoming.getType() == 7) {
            NCMap hshake = (NCMap)incoming;
            version = hshake.getInt("version");
            protcol = hshake.getInt("protocol");
            if (protcol >= 200 && protcol <= 200) {
                return hshake;
            }
        }
        throw new IOException("Connection handshake failed (version: " + version + ", protocol: " + protcol + ")");
    }
}

