/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.io;

import com.adobe.versioncue.nativecomm.io.ISerializer;
import com.adobe.versioncue.nativecomm.msg.NCBool;
import com.adobe.versioncue.nativecomm.msg.NCData;
import com.adobe.versioncue.nativecomm.msg.NCDouble;
import com.adobe.versioncue.nativecomm.msg.NCInt;
import com.adobe.versioncue.nativecomm.msg.NCList;
import com.adobe.versioncue.nativecomm.msg.NCLong;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCNull;
import com.adobe.versioncue.nativecomm.msg.NCNumber;
import com.adobe.versioncue.nativecomm.msg.NCString;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class Serializer
implements ISerializer {
    private static final byte[] ALIGN_BUFFER = new byte[3];
    private boolean isValid = true;
    private final DataInputStream in;
    private final DataOutputStream out;
    private NCMap handshake;

    public Serializer(InputStream in, OutputStream out) {
        this.in = new DataInputStream(in);
        this.out = new DataOutputStream(out);
    }

    public NCMap handshake() {
        return this.handshake;
    }

    public NCType read() throws IOException {
        int theType = this.in.readInt();
        switch (theType) {
            case 1: {
                return new NCInt(this.in.readInt());
            }
            case 2: {
                return NCBool.getBoolean(this.in.readInt() != 0);
            }
            case 8: {
                return new NCLong(this.in.readLong());
            }
            case 3: {
                return new NCDouble(this.in.readDouble());
            }
            case 4: {
                return this.readChars();
            }
            case 5: {
                return this.readData();
            }
            case 6: {
                return this.readList();
            }
            case 7: {
                return this.readMap();
            }
            case 0: {
                return NCNull.INSTANCE;
            }
        }
        throw new IllegalArgumentException();
    }

    public ISerializer write(NCType val) throws IOException {
        int type = val.getType();
        this.out.writeInt(type);
        switch (type) {
            case 1: {
                this.out.writeInt(((NCNumber)val).intValue());
                break;
            }
            case 2: {
                this.out.writeInt(((NCBool)val).booleanValue() ? 1 : 0);
                break;
            }
            case 3: {
                this.out.writeDouble(((NCNumber)val).doubleValue());
                break;
            }
            case 8: {
                this.out.writeLong(((NCNumber)val).longValue());
                break;
            }
            case 4: {
                this.writeChars(((NCString)val).string());
                break;
            }
            case 5: {
                this.writeData((NCData)val);
                break;
            }
            case 6: {
                this.writeList((NCList)val);
                break;
            }
            case 7: {
                this.writeMap((NCMap)val);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ISerializer flush() throws IOException {
        this.out.flush();
        return this;
    }

    public void dispose() {
        try {
            this.write(NCNull.INSTANCE).flush();
        }
        catch (IOException iOException) {}
        this.isValid = false;
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException iOException) {}
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void handshake(NCMap handshake) {
        this.handshake = handshake;
    }

    private NCList readList() throws IOException {
        int count = this.in.readInt();
        NCList result = new NCList(count);
        int i = 0;
        while (i < count) {
            NCType value = this.read();
            result.add(value);
            ++i;
        }
        return result;
    }

    private void writeList(NCList arr) throws IOException {
        int count = arr.size();
        this.out.writeInt(count);
        int i = 0;
        while (i < count) {
            this.write(arr.get(i));
            ++i;
        }
    }

    private NCMap readMap() throws IOException {
        NCMap result = new NCMap();
        int count = this.in.readInt();
        int i = 0;
        while (i < count) {
            NCType key = this.read();
            NCType val = this.read();
            result.put(key, val);
            ++i;
        }
        return result;
    }

    private void writeMap(NCMap dict) throws IOException {
        int count = dict.size();
        this.out.writeInt(count);
        for (Map.Entry<NCType, NCType> entry : dict.entrySet()) {
            this.write(entry.getKey());
            this.write(entry.getValue());
        }
    }

    private NCString readChars() throws IOException {
        int len = this.in.readInt();
        int alignedLen = len + 3 & 0xFFFFFFFC;
        byte[] buf = new byte[alignedLen];
        this.in.readFully(buf);
        return new NCString(new String(buf, 0, len, "UTF-8"));
    }

    private void writeChars(String val) throws IOException {
        byte[] buf = val.getBytes("UTF-8");
        this.out.writeInt(buf.length);
        this.out.write(buf);
        int align = buf.length & 3;
        if (align != 0) {
            this.out.write(ALIGN_BUFFER, 0, 4 - align);
        }
    }

    private NCData readData() throws IOException {
        int len = this.in.readInt();
        int alignedLen = len + 3 & 0xFFFFFFFC;
        byte[] buf = new byte[alignedLen];
        this.in.readFully(buf);
        return new NCData(buf, 0, len);
    }

    private void writeData(NCData data) throws IOException {
        byte[] b;
        ByteBuffer buf = data.bytes();
        int count = buf.remaining();
        this.out.writeInt(count);
        if (buf.hasArray()) {
            b = buf.array();
            this.out.write(b, buf.position(), buf.remaining());
        } else {
            b = new byte[count];
            buf.get(b);
            this.out.write(b);
        }
        int align = count & 3;
        if (align != 0) {
            this.out.write(ALIGN_BUFFER, 0, 4 - align);
        }
    }
}

