/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.io;

import com.adobe.versioncue.internal.nativecomm.ProcessLauncher;
import com.adobe.versioncue.internal.nativecomm.ServiceConfig;
import com.adobe.versioncue.internal.nativecomm.TimeOut;
import com.adobe.versioncue.internal.nativecomm.io.SerializerFactory;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.ServiceTimeoutException;
import com.adobe.versioncue.nativecomm.io.IConnection;
import com.adobe.versioncue.nativecomm.io.ISerializer;
import com.adobe.versioncue.nativecomm.msg.INCExternalizable;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.io.IOException;

public final class PipeConnection
implements IConnection {
    private static final String[] ARGS = new String[]{"-NComm_pipe"};
    private final ServiceConfig config;
    private final ISerializer serializer;
    private final Process process;
    private int requestCount = 0;

    public PipeConnection(ServiceConfig config) throws NativeCommException {
        assert (config != null) : "config != null";
        this.config = config;
        try {
            this.process = this.launchProcess();
            this.serializer = SerializerFactory.getInstance().serializer(this.process.getInputStream(), this.process.getOutputStream());
        }
        catch (IOException ioe) {
            this.dispose();
            throw new NativeCommException("Pipe connection failed <" + config.id() + "> - " + ioe, ioe);
        }
    }

    public boolean isValid() {
        return this.serializer.isValid();
    }

    public void beginTransaction() {
        this.throwIfNotValid();
    }

    public NCType read(int timeout) throws NativeCommException {
        try {
            return TimeOut.execute(new TimeOut.ITarget<NCType>(){

                @Override
                public NCType call() throws NativeCommException {
                    try {
                        NCType result = PipeConnection.this.serializer.read();
                        return result;
                    }
                    catch (IOException ioe) {
                        PipeConnection.this.dispose();
                        throw new NativeCommException("Process crashed <" + PipeConnection.this.pid() + '>', ioe);
                    }
                }

                @Override
                public void timeout() {
                    if (PipeConnection.this.process != null) {
                        PipeConnection.this.process.destroy();
                    }
                }
            }, timeout);
        }
        catch (TimeOut.TimeoutException e) {
            this.dispose();
            throw new ServiceTimeoutException(e.getMessage());
        }
    }

    public void write(final INCExternalizable message, int timeout) throws NativeCommException {
        try {
            TimeOut.execute(new TimeOut.ITarget<Object>(){

                @Override
                public Object call() throws NativeCommException {
                    try {
                        PipeConnection.this.serializer.write(message.externalize()).flush();
                        return null;
                    }
                    catch (IOException ioe) {
                        PipeConnection.this.dispose();
                        throw new NativeCommException("Process crashed <" + PipeConnection.this.pid() + '>', ioe);
                    }
                }

                @Override
                public void timeout() {
                    if (PipeConnection.this.process != null) {
                        PipeConnection.this.process.destroy();
                    }
                }
            }, timeout);
        }
        catch (TimeOut.TimeoutException e) {
            this.dispose();
            throw new ServiceTimeoutException(e.getMessage());
        }
    }

    public void endTransaction() {
        ++this.requestCount;
        if (this.requestCount >= this.config.maxRequests()) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.serializer != null) {
            this.serializer.dispose();
        }
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private void throwIfNotValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    private Process launchProcess() throws NativeCommException, IOException {
        return new ProcessLauncher(this.config).launch(ARGS);
    }

    private int pid() {
        try {
            return this.serializer.handshake().getInt("pid");
        }
        catch (Throwable throwable) {
            return 0;
        }
    }
}

