/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.io;

import com.adobe.versioncue.nativecomm.INativeService;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.io.IConnection;
import com.adobe.versioncue.nativecomm.io.IConnectionFactory;
import com.adobe.versioncue.nativecomm.msg.NCList;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCString;
import java.util.ArrayList;

public class ConnectionPool {
    private static final NCString NCOMM_PING = new NCString("NCOMM_PING");
    private static final int RETRY_COUNT = 5;
    private final int PING_TIMEOUT = 40000;
    private boolean isDisposed;
    private final INativeService service;
    private final IConnectionFactory factory;
    private ArrayList<IConnection> pool;
    private ArrayList<IConnection> freelist;

    public ConnectionPool(INativeService service, IConnectionFactory factory) {
        assert (service != null) : "service != null";
        assert (factory != null) : "factory != null";
        this.service = service;
        this.factory = factory;
        int maxsize = service.maxConnections();
        this.pool = new ArrayList(maxsize);
        this.freelist = new ArrayList(maxsize);
    }

    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            while (!this.freelist.isEmpty()) {
                this.disposeConnection(this.freelist.get(0));
            }
        }
        this.notifyAll();
    }

    public synchronized boolean isValid() {
        return !this.isDisposed;
    }

    public synchronized int poolSize() {
        return this.pool.size();
    }

    public IConnectionFactory factory() {
        return this.factory;
    }

    public synchronized IConnection aquireConnection() throws NativeCommException {
        IConnection result;
        this.throwIfReleased();
        while (true) {
            if (this.freelist.isEmpty()) {
                this.throwIfReleased();
                if (this.pool.size() < this.service.maxConnections()) {
                    this.connect();
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException iex) {
                    throw new RuntimeException(iex.getMessage(), iex);
                }
            }
            result = this.freelist.remove(this.freelist.size() - 1);
            if (result.isValid()) break;
        }
        return result;
    }

    public synchronized void releaseConnection(IConnection con) {
        assert (this.pool.contains(con));
        assert (!this.freelist.contains(con));
        if (this.isDisposed || !con.isValid()) {
            this.disposeConnection(con);
        } else {
            this.freelist.add(con);
            this.notify();
        }
    }

    private void throwIfReleased() throws NativeCommException {
        if (this.isDisposed) {
            throw new NativeCommException("NativeService disposed <" + this.service.id() + ">");
        }
    }

    private synchronized void connect() throws NativeCommException {
        int attempt = 0;
        while (true) {
            try {
                IConnection[] cons = this.factory.connect(this.service);
                int i = 0;
                while (i < cons.length) {
                    this.sendPing(cons[i]);
                    ++i;
                }
                i = 0;
                while (i < cons.length) {
                    this.addConnection(cons[i]);
                    ++i;
                }
            }
            catch (NativeCommException ex) {
                if (attempt >= 5) {
                    this.dispose();
                    throw ex;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    private synchronized void addConnection(IConnection con) {
        assert (!this.pool.contains(con));
        assert (!this.freelist.contains(con));
        this.pool.add(con);
        this.freelist.add(con);
        this.notify();
    }

    private synchronized void disposeConnection(IConnection con) {
        assert (this.pool.contains(con));
        this.pool.remove(con);
        this.freelist.remove(con);
        con.dispose();
        this.notify();
    }

    private void sendPing(IConnection con) throws NativeCommException {
        NCList ping = new NCList(2);
        ping.add(NCOMM_PING);
        ping.add(new NCMap());
        con.beginTransaction();
        try {
            con.write(ping, 40000);
            con.read(40000);
        }
        finally {
            con.endTransaction();
        }
    }
}

