/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm;

import com.adobe.versioncue.nativecomm.NativeCommException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeOut {
    private static final ScheduledExecutorService SRV = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        final ThreadFactory delegate = Executors.defaultThreadFactory();

        public Thread newThread(Runnable r) {
            Thread t = this.delegate.newThread(r);
            t.setDaemon(true);
            return t;
        }
    });

    public static <V> V execute(ITarget<V> target, int timeout) throws TimeoutException, NativeCommException {
        Guard guard = new Guard(target, timeout);
        try {
            V v = target.call();
            return v;
        }
        finally {
            guard.dismiss();
        }
    }

    private TimeOut() {
    }

    private static class Guard
    implements Runnable {
        private final ITarget target;
        private Future future;

        public Guard(ITarget target, int timeout) {
            this.target = target;
            if (timeout > 0) {
                this.future = SRV.schedule(this, (long)timeout, TimeUnit.MILLISECONDS);
            }
        }

        public void run() {
            this.target.timeout();
        }

        public void dismiss() throws TimeoutException {
            if (this.future != null && !this.future.cancel(false)) {
                throw new TimeoutException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITarget<V> {
        public V call() throws NativeCommException;

        public void timeout();
    }

    public static final class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 3396522838876207957L;
    }
}

