/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm;

import com.adobe.versioncue.internal.nativecomm.NativeService;
import com.adobe.versioncue.internal.nativecomm.ServiceConfig;
import com.adobe.versioncue.internal.nativecomm.io.ConnectionFactory;
import com.adobe.versioncue.nativecomm.INativeService;
import java.io.File;

public final class ServiceFactory {
    private static final ServiceFactory INSTANCE = new ServiceFactory();

    public static ServiceFactory getInstance() {
        return INSTANCE;
    }

    private ServiceFactory() {
    }

    public INativeService nativeService(ServiceConfig config) {
        this.applyDefaults(config);
        return new NativeService(config, new ConnectionFactory(config));
    }

    private void applyDefaults(ServiceConfig config) {
        if (config.directory() == null) {
            String path = config.library();
            if (path == null) {
                path = config.command();
            }
            if (path != null) {
                config.directory(this.getParent(path));
            }
        }
        if (config.isDebug()) {
            config.maxConnections(config.connectionsPerProcess());
            config.launchTimeout(600000);
            config.maxRequests(Integer.MAX_VALUE);
        }
        if (config.maxRequests() == 0) {
            config.maxRequests(Integer.MAX_VALUE);
        }
    }

    private File getParent(String path) {
        return new File(path).getAbsoluteFile().getParentFile();
    }
}

