/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceConfig
implements Cloneable {
    private String id;
    private int maxConnections = 1;
    private String command;
    private String library;
    private File directory;
    private String[] arguments = new String[0];
    private HashMap<String, String> environemt = new HashMap();
    private int maxRequests;
    private int connectionsPerProcess = 1;
    private File tmpdir;
    private File logdir;
    private int launchTimeout = 5000;
    private int terminationTimeout = 3000;
    private int debugPort;

    public ServiceConfig(String id) {
        this.id(id);
    }

    public String id() {
        return this.id;
    }

    public ServiceConfig id(String id) {
        assert (id.length() != 0) : "id.length() != 0";
        this.id = id;
        return this;
    }

    public int maxConnections() {
        return this.maxConnections;
    }

    public ServiceConfig maxConnections(int maxConnections) {
        assert (maxConnections > 0) : "maxPoolSize > 0";
        this.maxConnections = maxConnections;
        return this;
    }

    public int maxRequests() {
        return this.maxRequests;
    }

    public ServiceConfig maxRequests(int maxRequests) {
        assert (maxRequests >= 0) : "maxRequests >= 0";
        this.maxRequests = maxRequests;
        return this;
    }

    public String[] arguments() {
        return (String[])this.arguments.clone();
    }

    public ServiceConfig arguments(String[] args) {
        this.arguments = (String[])args.clone();
        return this;
    }

    public Map<String, String> environment() {
        return this.environemt;
    }

    public String library() {
        return this.library;
    }

    public ServiceConfig library(String library) {
        this.library = library;
        return this;
    }

    public File directory() {
        return this.directory;
    }

    public ServiceConfig directory(File directory) {
        this.directory = directory;
        return this;
    }

    public String command() {
        return this.command;
    }

    public ServiceConfig command(String command) {
        this.command = command;
        return this;
    }

    public int connectionsPerProcess() {
        return this.connectionsPerProcess;
    }

    public ServiceConfig connectionsPerProcess(int connectionsPerProcess) {
        assert (connectionsPerProcess >= 1) : "connectionsPerProcess >= 1";
        this.connectionsPerProcess = connectionsPerProcess;
        return this;
    }

    public File logDir() {
        return this.logdir;
    }

    public ServiceConfig logDir(File logdir) {
        this.logdir = logdir;
        return this;
    }

    public File tmpDir() {
        return this.tmpdir;
    }

    public ServiceConfig tmpDir(File tmpDir) {
        this.tmpdir = tmpDir;
        return this;
    }

    public int launchTimeout() {
        return this.launchTimeout;
    }

    public ServiceConfig launchTimeout(int timeout) {
        assert (timeout > 0) : "timeout > 0";
        this.launchTimeout = timeout;
        return this;
    }

    public int terminationTimeout() {
        return this.terminationTimeout;
    }

    public ServiceConfig terminationTimeout(int timeout) {
        assert (timeout > 0) : "timeout > 0";
        this.terminationTimeout = timeout;
        return this;
    }

    public int debugPort() {
        return this.debugPort;
    }

    public ServiceConfig debugPort(int port) {
        assert (port >= 0 && port < 65536) : "port >= 0 && port < 65536";
        this.debugPort = port;
        return this;
    }

    public boolean isDebug() {
        return this.debugPort != 0;
    }

    public Object clone() {
        try {
            ServiceConfig result = (ServiceConfig)super.clone();
            result.arguments = (String[])this.arguments.clone();
            result.environemt = new HashMap<String, String>(this.environemt);
            return result;
        }
        catch (CloneNotSupportedException clo) {
            throw new RuntimeException(clo);
        }
    }
}

