/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm;

import com.adobe.versioncue.internal.nativecomm.NativeService;
import com.adobe.versioncue.nativecomm.INativeService;
import com.adobe.versioncue.nativecomm.IRequest;
import com.adobe.versioncue.nativecomm.IResult;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.msg.INCExternalizable;
import com.adobe.versioncue.nativecomm.msg.NCList;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCString;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.nio.ByteBuffer;

class Request
implements IRequest,
INCExternalizable {
    private static IRequest.IListener NULL_LISTENER = new IRequest.IListener(){

        public void progressChanged(IRequest request, String taskname, double progress) {
        }
    };
    private final NativeService service;
    private final String call;
    private NCMap params = new NCMap();
    private int timeout;
    private IRequest.IListener listener = NULL_LISTENER;

    public Request(NativeService service, String call) {
        assert (service != null) : "service!= null";
        assert (call != null) : "call != null";
        this.service = service;
        this.call = call;
    }

    public INativeService processPool() {
        return this.service;
    }

    public INativeService service() {
        return this.service;
    }

    public String call() {
        return this.call;
    }

    public NCMap params() {
        return this.params;
    }

    public IRequest params(NCMap params) {
        assert (params != null) : "params != null";
        this.params = params;
        return this;
    }

    public int timeout() {
        return this.timeout;
    }

    public IRequest timeout(int timeout) {
        assert (timeout >= 0) : "timeout >= 0";
        this.timeout = timeout;
        return this;
    }

    public IRequest.IListener listener() {
        return this.listener;
    }

    public IRequest listener(IRequest.IListener listener) {
        this.listener = listener != null ? listener : NULL_LISTENER;
        return this;
    }

    public IResult execute() throws NativeCommException {
        return this.service.execute(this, this.timeout);
    }

    public String toString() {
        return "[NComm Request id: <" + this.service.id() + '>' + " call: '" + this.call + '\'' + " params: " + this.params + ']';
    }

    public IRequest put(String name, boolean value) {
        this.params.put(name, value);
        return this;
    }

    public IRequest put(String name, ByteBuffer value) {
        this.params.put(name, value);
        return this;
    }

    public IRequest put(String name, double value) {
        this.params.put(name, value);
        return this;
    }

    public IRequest put(String name, INCExternalizable value) {
        this.params.put(name, value);
        return this;
    }

    public IRequest put(String name, int value) {
        this.params.put(name, value);
        return this;
    }

    public IRequest put(String name, long value) {
        this.params.put(name, value);
        return this;
    }

    public IRequest put(String name, NCType value) {
        this.params.put(name, value);
        return this;
    }

    public IRequest put(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public NCType externalize() {
        NCList outgoing = new NCList(2);
        outgoing.add(new NCString(this.call));
        outgoing.add(this.params);
        return outgoing;
    }
}

