/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm;

import com.adobe.versioncue.internal.nativecomm.ServiceConfig;
import com.adobe.versioncue.nativecomm.BadConfigException;
import com.adobe.versioncue.nativecomm.NativeComm;
import com.adobe.versioncue.nativecomm.NativeCommException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessLauncher {
    private static final String NCOMM_THREAD_CT = "-threadCt";
    private static final String NCOMM_ID_ENV = "ADOBE_NCOMM_id";
    private static final String NCOMM_CWD_ENV = "ADOBE_NCOMM_cwd";
    private static final String NCOMM_LOGDIR_ENV = "ADOBE_NCOMM_logdir";
    private static final String NCOMM_LIBRARY_ENV = "ADOBE_NCOMM_lib";
    private static final String NCOMM_THREAD_CT_ENV = "ADOBE_NCOMM_threadCt";
    private final ServiceConfig config;

    public ProcessLauncher(ServiceConfig config) throws NativeCommException {
        this.config = config;
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process launch(String[] extraArgs) throws IOException {
        List<String> argList = this.processArguments();
        int i = 0;
        while (i < extraArgs.length) {
            argList.add(extraArgs[i]);
            ++i;
        }
        ProcessBuilder pb = new ProcessBuilder(argList);
        this.addEnvironment(pb);
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            return pb.start();
        }
    }

    private List<String> processArguments() {
        ArrayList<String> result = new ArrayList<String>(20);
        result.add(this.getRelativePath(this.config.command()));
        result.add(NCOMM_THREAD_CT);
        result.add(Integer.toString(this.config.connectionsPerProcess()));
        String[] args = this.config.arguments();
        int i = 0;
        while (i < args.length) {
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    private void addEnvironment(ProcessBuilder pb) {
        File tmpDir;
        File logDir;
        Map<String, String> env = pb.environment();
        env.putAll(this.config.environment());
        env.put(NCOMM_ID_ENV, this.config.id());
        env.put(NCOMM_THREAD_CT_ENV, Integer.toString(this.config.connectionsPerProcess()));
        env.put(NCOMM_CWD_ENV, this.config.directory().getAbsolutePath());
        String library = this.config.library();
        if (library != null) {
            env.put(NCOMM_LIBRARY_ENV, this.config.library());
        }
        if ((logDir = this.config.logDir()) != null) {
            env.put(NCOMM_LOGDIR_ENV, logDir.getAbsolutePath());
        }
        if ((tmpDir = this.config.tmpDir()) != null) {
            String tmpPath = tmpDir.getAbsolutePath();
            if (NativeComm.OS.isWin32()) {
                env.put("TMP", tmpPath);
                env.put("TEMP", tmpPath);
            } else {
                env.put("TMPDIR", tmpPath);
            }
        }
        if (NativeComm.OS.isMacOSX()) {
            File cwd = this.config.directory();
            env.put("DYLD_FRAMEWORK_PATH", cwd.getAbsolutePath());
        }
    }

    private String getRelativePath(String absolute) {
        String cwd = new File("").getAbsolutePath();
        if (absolute.startsWith(cwd)) {
            int idx = cwd.length();
            String relativePath = absolute.substring(absolute.charAt(idx) == File.separatorChar ? idx + 1 : idx);
            return relativePath;
        }
        return absolute;
    }

    private void validate() throws BadConfigException {
        File libFile;
        File command = new File(this.config.command());
        if (!command.exists()) {
            throw new BadConfigException("NComm executable does not exist: " + command);
        }
        String lib = this.config.library();
        if (lib != null && !(libFile = new File(lib)).exists()) {
            throw new BadConfigException("NComm library does not exist: " + lib);
        }
        File dir = this.config.directory();
        if (!dir.exists()) {
            throw new BadConfigException("NComm working dir does not exist: " + dir);
        }
        File logDir = this.config.logDir();
        if (logDir != null) {
            if (logDir.equals(NativeComm.getDefaultLogDir())) {
                logDir.mkdirs();
            }
            if (!logDir.exists()) {
                throw new BadConfigException("NComm log dir does not exist: " + logDir);
            }
        }
    }
}

