/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm;

import com.adobe.versioncue.internal.nativecomm.Request;
import com.adobe.versioncue.internal.nativecomm.Result;
import com.adobe.versioncue.internal.nativecomm.ServiceConfig;
import com.adobe.versioncue.internal.nativecomm.io.ConnectionPool;
import com.adobe.versioncue.nativecomm.INativeService;
import com.adobe.versioncue.nativecomm.IRequest;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.ServiceCallException;
import com.adobe.versioncue.nativecomm.io.IConnection;
import com.adobe.versioncue.nativecomm.io.IConnectionFactory;
import com.adobe.versioncue.nativecomm.msg.BadMessageException;
import com.adobe.versioncue.nativecomm.msg.NCList;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.util.concurrent.atomic.AtomicInteger;

public class NativeService
implements INativeService {
    private final int MSGID_RESULT = 0;
    private final int MSGID_ERROR = 1;
    private final int MSGID_PROGRESS = 2;
    private final ServiceConfig config;
    private final ConnectionPool pool;
    private AtomicInteger requestCount = new AtomicInteger();

    public NativeService(ServiceConfig config, IConnectionFactory factory) {
        assert (config != null) : "config != null";
        assert (factory != null) : "factory != null";
        this.config = config;
        this.pool = new ConnectionPool(this, factory);
    }

    public IRequest request(String function) {
        return new Request(this, function);
    }

    public void dispose() {
        this.pool.dispose();
    }

    public boolean isValid() {
        return this.pool.isValid();
    }

    public String id() {
        return this.config.id();
    }

    public int maxConnections() {
        return this.config.maxConnections();
    }

    public int poolSize() {
        return this.pool.poolSize();
    }

    public int totalRequests() {
        return this.requestCount.get();
    }

    public String toString() {
        return "[NativeService id:" + this.config.id() + ']';
    }

    protected Result execute(Request request, int timeout) throws NativeCommException {
        IConnection con = this.pool.aquireConnection();
        try {
            Result result = this.transact(con, request, timeout);
            return result;
        }
        finally {
            this.requestCount.incrementAndGet();
            this.pool.releaseConnection(con);
        }
    }

    protected Result transact(IConnection con, Request request, int timeout) throws NativeCommException {
        con.beginTransaction();
        try {
            NCType incoming;
            Result result;
            con.write(request, timeout);
            while ((result = this.parseResponse(request, incoming = con.read(timeout))) == null) {
            }
            Result result2 = result;
            return result2;
        }
        finally {
            con.endTransaction();
        }
    }

    private Result parseResponse(Request request, NCType incoming) throws NativeCommException {
        NCMap results;
        int responseCode;
        try {
            NCList response = (NCList)incoming;
            responseCode = response.getInt(0);
            results = response.getMap(1);
        }
        catch (Exception e) {
            throw new NativeCommException("Illegal response <" + this.id() + ">: " + incoming, e);
        }
        switch (responseCode) {
            case 0: {
                return new Result(this, request.call(), results);
            }
            case 1: {
                return this.handleError(request, results);
            }
            case 2: {
                return this.handleProgress(request, results);
            }
        }
        throw new BadMessageException("Illegal response <" + this.id() + ">: " + incoming);
    }

    private Result handleError(Request request, NCMap results) throws NativeCommException {
        String reasonCode = results.getString("errReason");
        String errWhy = results.getString("errWhy");
        errWhy = errWhy != null ? errWhy : "";
        throw new ServiceCallException(request.call(), reasonCode, errWhy);
    }

    private Result handleProgress(Request request, NCMap info) throws NativeCommException {
        IRequest.IListener listener = request.listener();
        String taskname = info.getString("taskname");
        double progress = info.getDouble("progress");
        listener.progressChanged(request, taskname, progress);
        return null;
    }
}

