/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm;

import com.adobe.versioncue.nativecomm.io.IConnection;
import java.util.HashSet;
import java.util.Set;

public final class NativeProcess {
    private final Process process;
    private int requestCount = 0;
    private boolean isValid = true;
    private Set<IConnection> connections = new HashSet<IConnection>();

    public NativeProcess(Process process) {
        this.process = process;
    }

    public synchronized int requestCount() {
        return this.requestCount;
    }

    public synchronized int incRequestCount() {
        return ++this.requestCount;
    }

    public synchronized boolean isValid() {
        return this.isValid;
    }

    public synchronized void registerConnection(IConnection connection) {
        assert (connection != null) : "connection != null";
        assert (!this.connections.contains(connection));
        this.connections.add(connection);
    }

    public synchronized void deregisterConnection(IConnection connection) {
        assert (connection != null) : "connection != null";
        this.connections.remove(connection);
    }

    public void waitAndKill(int timeout) {
        if (!this.invalidate()) {
            return;
        }
        long endTime = System.currentTimeMillis() + (long)timeout;
        while (this.isRunning()) {
            long sleepTime = endTime - System.currentTimeMillis();
            if (sleepTime <= 0L) break;
            this.sleep(sleepTime);
        }
        this.kill();
    }

    private synchronized boolean invalidate() {
        this.isValid = false;
        return this.connections.isEmpty();
    }

    private boolean isRunning() {
        try {
            if (this.process != null) {
                this.process.exitValue();
            }
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    private void sleep(long maxSleepTime) {
        long sleepTime = Math.min(200L, maxSleepTime);
        if (sleepTime > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void kill() {
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

