/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.auth.internal.renga.parsers;

import com.adobe.csi.auth.AuthenticationToken;
import com.adobe.csi.auth.internal.renga.parsers.RengaResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RengaResponseParser {
    private SAXParser saxParser;

    public RengaResponse parse(InputStream is) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.saxParser = factory.newSAXParser();
            Handler handler = new Handler();
            this.saxParser.parse(is, (DefaultHandler)handler);
            return handler.getRengaResponse();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static class Handler
    extends DefaultHandler {
        private ParserState state = ParserState.INITIAL;
        private RengaResponse response;
        private AuthenticationToken token;
        private StringBuilder authTokenBuffer = new StringBuilder();
        private StringBuilder errorMessageBuffer = new StringBuilder();

        private Handler() {
        }

        public RengaResponse getRengaResponse() {
            return this.response;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.state) {
                case INITIAL: {
                    if (name.equals("response")) {
                        this.state = ParserState.PARSE_RESPONSE;
                        break;
                    }
                    throw new SAXException("Invalid request format.");
                }
                case PARSE_RESPONSE: {
                    if (name.equals("error")) {
                        this.state = ParserState.PARSE_RESPONSE_ERROR;
                        this.response = new RengaResponse(RengaResponse.StatusCode.ERROR);
                        break;
                    }
                    if (name.equals("authtoken")) {
                        this.state = ParserState.PARSE_RESPONSE_AUTHTOKEN;
                        this.response = new RengaResponse(RengaResponse.StatusCode.OK);
                        this.token = AuthenticationToken.createCookie();
                        this.response.setAuthenticationToken(this.token);
                        int i = 0;
                        while (i < attributes.getLength()) {
                            String key = attributes.getQName(i);
                            String value = attributes.getValue(i);
                            this.token.addAttribute(key, value);
                            ++i;
                        }
                        break;
                    }
                    throw new SAXException("Invalid request format.");
                }
                case PARSE_RESPONSE_ERROR: {
                    if (name.equals("msg")) {
                        this.state = ParserState.PARSE_RESPONSE_ERROR_MSG;
                        break;
                    }
                    if (name.equals("exception")) {
                        this.state = ParserState.PARSE_RESPONSE_ERROR_EXCEPTION;
                        String exception = attributes.getValue("msg");
                        this.response.setExceptionMessage(exception);
                        break;
                    }
                    throw new SAXException("Invalid request format.");
                }
                default: {
                    throw new SAXException("Unhandled state: " + (Object)((Object)this.state));
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state == ParserState.PARSE_RESPONSE_AUTHTOKEN) {
                this.authTokenBuffer.append(new String(ch, start, length));
            } else if (this.state == ParserState.PARSE_RESPONSE_ERROR_MSG) {
                this.errorMessageBuffer.append(new String(ch, start, length));
                String value = new String(ch, start, length).trim();
                this.response.setErrorMessage(value);
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.authTokenBuffer.length() > 0) {
                this.token.addAttribute("value", this.authTokenBuffer.toString());
                this.token.addAttribute("type", "SSO_ADOBE");
                this.token.addAttribute("name", "WCDServer");
            }
            if (this.errorMessageBuffer.length() > 0) {
                this.response.setErrorMessage(this.errorMessageBuffer.toString());
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.state) {
                case PARSE_RESPONSE_ERROR_MSG: 
                case PARSE_RESPONSE_ERROR_EXCEPTION: {
                    this.state = ParserState.PARSE_RESPONSE_ERROR;
                    break;
                }
                case PARSE_RESPONSE_AUTHTOKEN: 
                case PARSE_RESPONSE_ERROR: {
                    this.state = ParserState.PARSE_RESPONSE;
                    break;
                }
                case PARSE_RESPONSE: {
                    this.state = ParserState.DONE;
                    break;
                }
                default: {
                    throw new SAXException("Unhandled state: " + (Object)((Object)this.state));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            INITIAL,
            PARSE_RESPONSE,
            PARSE_RESPONSE_AUTHTOKEN,
            PARSE_RESPONSE_ERROR,
            PARSE_RESPONSE_ERROR_MSG,
            PARSE_RESPONSE_ERROR_EXCEPTION,
            DONE;

        }
    }
}

