/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.auth.internal.renga;

import com.adobe.csi.auth.AuthenticationException;
import com.adobe.csi.auth.AuthenticationToken;
import com.adobe.csi.auth.IAuthenticationProvider;
import com.adobe.csi.auth.internal.renga.parsers.RengaResponse;
import com.adobe.csi.auth.internal.renga.parsers.RengaResponseParser;
import com.adobe.csi.core.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.osgi.service.component.ComponentContext;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RengaAuthenticationProvider
implements IAuthenticationProvider {
    private static final String ACCOUNT_WSAPI_AUTH_V1 = "/account/wsapi/auth/v1";
    private static final Logger LOGGER = Logger.getLogger(RengaAuthenticationProvider.class);
    private static final String PROP_RENGA_BASE_URL = "renga.baseUrl";
    private String baseUrl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthenticationToken authenticate(String username, String password) throws AuthenticationException, IOException {
        AuthenticationToken authenticationToken;
        InputStream is;
        block14: {
            is = null;
            OutputStream os = null;
            try {
                URL url = new URL(String.valueOf(this.baseUrl) + ACCOUNT_WSAPI_AUTH_V1);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                os = conn.getOutputStream();
                OutputStreamWriter wr = new OutputStreamWriter(os);
                wr.write(this.buildRequestString(username, password));
                wr.flush();
                RengaResponseParser parser = new RengaResponseParser();
                is = conn.getInputStream();
                RengaResponse response = parser.parse(is);
                if (response.getStatusCode() == RengaResponse.StatusCode.ERROR) {
                    throw new AuthenticationException(response.getErrorMessage());
                }
                authenticationToken = response.getAuthenticationToken();
                if (os == null) break block14;
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)("{authenticate} Caught exception: " + e.getMessage()));
                    throw e;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        if (is == null) return authenticationToken;
        try {
            is.close();
            return authenticationToken;
        }
        catch (IOException iOException) {}
        return authenticationToken;
    }

    public void logout(AuthenticationToken token) {
    }

    protected void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.baseUrl = (String)properties.get(PROP_RENGA_BASE_URL);
    }

    private String buildRequestString(String username, String password) throws IOException {
        StringWriter stringWriter = new StringWriter();
        SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            TransformerHandler transformerHandler = saxTransformerFactory.newTransformerHandler();
            Transformer serializer = transformerHandler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            transformerHandler.setResult(new StreamResult(stringWriter));
            transformerHandler.startDocument();
            AttributesImpl attributes = new AttributesImpl();
            transformerHandler.startElement("", "", "request", attributes);
            transformerHandler.startElement("", "", "username", attributes);
            transformerHandler.characters(username.toCharArray(), 0, username.length());
            transformerHandler.endElement("", "", "username");
            transformerHandler.startElement("", "", "password", attributes);
            transformerHandler.characters(password.toCharArray(), 0, password.length());
            transformerHandler.endElement("", "", "password");
            transformerHandler.endElement("", "", "request");
            transformerHandler.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        return stringWriter.toString();
    }
}

