/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.parsers;

import com.adobe.csi.auth.AuthenticationToken;
import com.adobe.csi.auth.StoreCredentialsRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StoreCredentialsRequestParser {
    private final SAXParserFactory saxParserFactory;

    public StoreCredentialsRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public StoreCredentialsRequest parse(InputStream request) throws IOException {
        StoreCredentialsRequest storeCredentialsRequest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            storeCredentialsRequest = handler.getStoreCredentialsRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return storeCredentialsRequest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ELEMENT_AUTHTOKEN = "authtoken";
        private static final String XML_ELEMENT_COOKIE = "cookie";
        private static final String XML_ELEMENT_CREDENTIALS = "credentials";
        private static final String XML_ELEMENT_PASSWORD = "password";
        private static final String XML_ELEMENT_STORE = "store";
        private static final String XML_ELEMENT_STORE_CREDENTIALS_REQUEST = "storeCredentialsRequest";
        private static final String XML_ELEMENT_UID = "uid";
        private ParserState parserState = ParserState.INITIAL;
        private final StringBuilder passwordBuffer;
        private StoreCredentialsRequest storeCredentialsRequest;
        private final StringBuilder uidBuffer = new StringBuilder();
        private final StringBuilder storeBuffer;

        Handler() {
            this.passwordBuffer = new StringBuilder();
            this.storeBuffer = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.parserState) {
                case ELEMENT_UID: {
                    this.uidBuffer.append(new String(ch, start, length));
                    break;
                }
                case ELEMENT_PASSWORD: {
                    this.passwordBuffer.append(new String(ch, start, length));
                    break;
                }
                case ELEMENT_STORE: {
                    this.storeBuffer.append(new String(ch, start, length));
                }
            }
        }

        public void endDocument() throws SAXException {
            if (this.uidBuffer.length() > 0) {
                this.storeCredentialsRequest.setUserId(this.uidBuffer.toString());
            }
            if (this.passwordBuffer.length() > 0) {
                this.storeCredentialsRequest.setPassword(this.passwordBuffer.toString());
            }
            if (this.storeBuffer.length() > 0) {
                this.storeCredentialsRequest.setStore(Boolean.parseBoolean(this.storeBuffer.toString()));
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_STORE_CREDENTIALS_REQUEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                case ELEMENT_AUTHTOKEN: {
                    this.parserState = ParserState.ELEMENT_STORE_CREDENTIALS_REQUEST;
                    break;
                }
                case ELEMENT_COOKIE: {
                    this.parserState = ParserState.ELEMENT_AUTHTOKEN;
                    break;
                }
                case ELEMENT_CREDENTIALS: {
                    this.parserState = ParserState.ELEMENT_STORE_CREDENTIALS_REQUEST;
                    break;
                }
                case ELEMENT_UID: {
                    this.parserState = ParserState.ELEMENT_CREDENTIALS;
                    break;
                }
                case ELEMENT_PASSWORD: {
                    this.parserState = ParserState.ELEMENT_CREDENTIALS;
                    break;
                }
                case ELEMENT_STORE: {
                    this.parserState = ParserState.ELEMENT_CREDENTIALS;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public StoreCredentialsRequest getStoreCredentialsRequest() {
            return this.storeCredentialsRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_STORE_CREDENTIALS_REQUEST)) {
                        this.storeCredentialsRequest = new StoreCredentialsRequest();
                        this.parserState = ParserState.ELEMENT_STORE_CREDENTIALS_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_STORE_CREDENTIALS_REQUEST: {
                    if (name.equals(XML_ELEMENT_AUTHTOKEN)) {
                        this.parserState = ParserState.ELEMENT_AUTHTOKEN;
                        break;
                    }
                    if (name.equals(XML_ELEMENT_CREDENTIALS)) {
                        this.parserState = ParserState.ELEMENT_CREDENTIALS;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_AUTHTOKEN: {
                    if (name.equals(XML_ELEMENT_COOKIE)) {
                        AuthenticationToken authToken = AuthenticationToken.createCookie();
                        int i = 0;
                        while (i < attributes.getLength()) {
                            String key = attributes.getQName(i);
                            String value = attributes.getValue(i);
                            authToken.addAttribute(key, value);
                            ++i;
                        }
                        this.storeCredentialsRequest.setAuthenticationToken(authToken);
                        this.parserState = ParserState.ELEMENT_COOKIE;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_COOKIE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_CREDENTIALS: {
                    if (name.equals(XML_ELEMENT_UID)) {
                        this.parserState = ParserState.ELEMENT_UID;
                        break;
                    }
                    if (name.equals(XML_ELEMENT_PASSWORD)) {
                        this.parserState = ParserState.ELEMENT_PASSWORD;
                        break;
                    }
                    if (name.equals(XML_ELEMENT_STORE)) {
                        this.parserState = ParserState.ELEMENT_STORE;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_UID: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_PASSWORD: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_AUTHTOKEN,
            ELEMENT_COOKIE,
            ELEMENT_CREDENTIALS,
            ELEMENT_PASSWORD,
            ELEMENT_STORE,
            ELEMENT_STORE_CREDENTIALS_REQUEST,
            ELEMENT_UID,
            INITIAL;

        }
    }
}

