/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.parsers;

import com.adobe.csi.auth.AuthenticationToken;
import com.adobe.csi.auth.RetrieveCredentialsResponse;
import com.adobe.csi.auth.StatusCode;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RetrieveCredentialsResponseBuilder {
    private static final String XML_ATTRIBUTE_STATUS = "status";
    private static final String XML_ELEMENT_AUTHTOKEN = "authtoken";
    private static final String XML_ELEMENT_COOKIE = "cookie";
    private static final String XML_ELEMENT_CREDENTIALS = "credentials";
    private static final String XML_ELEMENT_MESSAGE = "message";
    private static final String XML_ELEMENT_PASSWORD = "password";
    private static final String XML_ELEMENT_RETRIEVE_CREDENTIALS_RESPONSE = "retrieveCredentialsResponse";
    private static final String XML_ELEMENT_UID = "uid";
    private static final String XML_ELEMENT_STORE = "store";

    public String build(RetrieveCredentialsResponse retrieveCredentialsResponse) throws IOException {
        StringWriter stringWriter = new StringWriter();
        SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            TransformerHandler transformerHandler = saxTransformerFactory.newTransformerHandler();
            Transformer serializer = transformerHandler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            transformerHandler.setResult(new StreamResult(stringWriter));
            transformerHandler.startDocument();
            AttributesImpl attributes = new AttributesImpl();
            StatusCode status = retrieveCredentialsResponse.getStatus();
            if (status != null) {
                attributes.addAttribute("", "", XML_ATTRIBUTE_STATUS, null, status.getStatus());
            }
            transformerHandler.startElement("", "", XML_ELEMENT_RETRIEVE_CREDENTIALS_RESPONSE, attributes);
            attributes.clear();
            if (status == StatusCode.OK) {
                AuthenticationToken authToken = retrieveCredentialsResponse.getAuthenticationToken();
                if (authToken != null) {
                    transformerHandler.startElement("", "", XML_ELEMENT_AUTHTOKEN, attributes);
                    Map<String, String> map = authToken.getAttributes();
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        attributes.addAttribute("", "", entry.getKey(), null, entry.getValue());
                    }
                    transformerHandler.startElement("", "", XML_ELEMENT_COOKIE, attributes);
                    attributes.clear();
                    transformerHandler.endElement("", "", XML_ELEMENT_COOKIE);
                    transformerHandler.endElement("", "", XML_ELEMENT_AUTHTOKEN);
                }
                String uid = retrieveCredentialsResponse.getUserId();
                String password = retrieveCredentialsResponse.getPassword();
                if (uid != null) {
                    password = password != null ? password : "";
                    transformerHandler.startElement("", "", XML_ELEMENT_CREDENTIALS, attributes);
                    transformerHandler.startElement("", "", XML_ELEMENT_UID, attributes);
                    transformerHandler.characters(uid.toCharArray(), 0, uid.length());
                    transformerHandler.endElement("", "", XML_ELEMENT_UID);
                    transformerHandler.startElement("", "", XML_ELEMENT_PASSWORD, attributes);
                    transformerHandler.characters(password.toCharArray(), 0, password.length());
                    transformerHandler.endElement("", "", XML_ELEMENT_PASSWORD);
                    String store = Boolean.toString(retrieveCredentialsResponse.isStore());
                    transformerHandler.startElement("", "", XML_ELEMENT_STORE, attributes);
                    transformerHandler.characters(store.toCharArray(), 0, store.length());
                    transformerHandler.endElement("", "", XML_ELEMENT_STORE);
                    transformerHandler.endElement("", "", XML_ELEMENT_CREDENTIALS);
                }
            } else {
                String message = retrieveCredentialsResponse.getMessage();
                if (message != null) {
                    transformerHandler.startElement("", "", XML_ELEMENT_MESSAGE, new AttributesImpl());
                    transformerHandler.characters(message.toCharArray(), 0, message.length());
                    transformerHandler.endElement("", "", XML_ELEMENT_MESSAGE);
                }
            }
            transformerHandler.endElement("", "", XML_ELEMENT_RETRIEVE_CREDENTIALS_RESPONSE);
            transformerHandler.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        return stringWriter.toString();
    }
}

