/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.parsers;

import com.adobe.csi.auth.RetrieveCredentialsRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RetrieveCredentialsRequestParser {
    private final SAXParserFactory saxParserFactory;

    public RetrieveCredentialsRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public RetrieveCredentialsRequest parse(InputStream request) throws IOException {
        RetrieveCredentialsRequest retrieveCredentialsRequest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            retrieveCredentialsRequest = handler.getRetrieveCredentialsRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return retrieveCredentialsRequest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ELEMENT_RETRIEVE_CREDENTIALS_REQUEST = "retrieveCredentialsRequest";
        private ParserState parserState = ParserState.INITIAL;
        private RetrieveCredentialsRequest retrieveCredentialsRequest;

        Handler() {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_RETRIEVE_CREDENTIALS_REQUEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public RetrieveCredentialsRequest getRetrieveCredentialsRequest() {
            return this.retrieveCredentialsRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_RETRIEVE_CREDENTIALS_REQUEST)) {
                        this.retrieveCredentialsRequest = new RetrieveCredentialsRequest();
                        this.parserState = ParserState.ELEMENT_RETRIEVE_CREDENTIALS_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_RETRIEVE_CREDENTIALS_REQUEST: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_RETRIEVE_CREDENTIALS_REQUEST,
            INITIAL;

        }
    }
}

