/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.parsers;

import com.adobe.csi.auth.LogoutRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LogoutRequestParser {
    private SAXParserFactory saxParserFactory;

    public LogoutRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public LogoutRequest parse(String is) throws IOException {
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            InputSource source = new InputSource(new ByteArrayInputStream(is.getBytes("UTF-8")));
            saxParser.parse(source, (DefaultHandler)handler);
            return handler.getLogoutRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static class Handler
    extends DefaultHandler {
        private LogoutRequest logoutRequest;
        private ParserState state = ParserState.INITIAL;

        private Handler() {
        }

        public LogoutRequest getLogoutRequest() {
            return this.logoutRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.state) {
                case INITIAL: {
                    if (name.equals("logoutRequest")) {
                        this.logoutRequest = new LogoutRequest();
                        this.state = ParserState.PARSE_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid request format.");
                }
                case PARSE_REQUEST: {
                    if (name.equals("extensionId")) {
                        this.state = ParserState.PARSE_REQUEST_SERVICE;
                        break;
                    }
                    throw new SAXException("Invalid request format.");
                }
                default: {
                    throw new SAXException("Unhandled state: " + (Object)((Object)this.state));
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.state) {
                case PARSE_REQUEST_SERVICE: {
                    this.state = ParserState.PARSE_REQUEST;
                    break;
                }
                case PARSE_REQUEST: {
                    this.state = ParserState.DONE;
                    break;
                }
                default: {
                    throw new SAXException("Unhandled state: " + (Object)((Object)this.state));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            INITIAL,
            PARSE_REQUEST,
            PARSE_REQUEST_SERVICE,
            DONE;

        }
    }
}

