/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.parsers;

import com.adobe.csi.auth.DeleteCredentialsRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeleteCredentialsRequestParser {
    private final SAXParserFactory saxParserFactory;

    public DeleteCredentialsRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public DeleteCredentialsRequest parse(InputStream request) throws IOException {
        DeleteCredentialsRequest storeCredentialsRequest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            storeCredentialsRequest = handler.getStoreCredentialsRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return storeCredentialsRequest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ELEMENT_STORE = "store";
        private static final String XML_ELEMENT_DELETE_CREDENTIALS_REQUEST = "deleteCredentialsRequest";
        private ParserState parserState = ParserState.INITIAL;
        private DeleteCredentialsRequest deleteCredentialsRequest;
        private final StringBuilder storeBuffer = new StringBuilder();

        Handler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.parserState) {
                case ELEMENT_STORE: {
                    this.storeBuffer.append(new String(ch, start, length));
                }
            }
        }

        public void endDocument() throws SAXException {
            if (this.storeBuffer.length() > 0) {
                this.deleteCredentialsRequest.setStore(Boolean.parseBoolean(this.storeBuffer.toString()));
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_DELETE_CREDENTIALS_REQUEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                case ELEMENT_STORE: {
                    this.parserState = ParserState.ELEMENT_DELETE_CREDENTIALS_REQUEST;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public DeleteCredentialsRequest getStoreCredentialsRequest() {
            return this.deleteCredentialsRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_DELETE_CREDENTIALS_REQUEST)) {
                        this.deleteCredentialsRequest = new DeleteCredentialsRequest();
                        this.parserState = ParserState.ELEMENT_DELETE_CREDENTIALS_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_DELETE_CREDENTIALS_REQUEST: {
                    if (name.equals(XML_ELEMENT_STORE)) {
                        this.parserState = ParserState.ELEMENT_STORE;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_STORE,
            ELEMENT_DELETE_CREDENTIALS_REQUEST,
            INITIAL;

        }
    }
}

