/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.parsers;

import com.adobe.csi.auth.AuthenticationRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AuthenticationRequestParser {
    private SAXParserFactory saxParserFactory;

    public AuthenticationRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public AuthenticationRequest parse(String is) throws IOException {
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            InputSource source = new InputSource(new ByteArrayInputStream(is.getBytes("UTF-8")));
            saxParser.parse(source, (DefaultHandler)handler);
            return handler.getAuthenticationRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static class Handler
    extends DefaultHandler {
        private AuthenticationRequest authenticationRequest;
        private ParserState state = ParserState.INITIAL;
        private StringBuilder passwordBuffer = new StringBuilder();
        private StringBuilder userBuffer = new StringBuilder();
        private StringBuilder shareSessionBuffer = new StringBuilder();
        private StringBuilder credentialsStoreBuffer = new StringBuilder();

        private Handler() {
        }

        public AuthenticationRequest getAuthenticationRequest() {
            return this.authenticationRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.state) {
                case INITIAL: {
                    if (name.equals("authenticationRequest")) {
                        this.authenticationRequest = new AuthenticationRequest();
                        this.state = ParserState.PARSE_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid request format.");
                }
                case PARSE_REQUEST: {
                    if (name.equals("extensionId")) {
                        this.state = ParserState.PARSE_REQUEST_SERVICE;
                        break;
                    }
                    if (name.equals("shareSession")) {
                        this.state = ParserState.PARSE_REQUEST_SHARE_SESSION;
                        break;
                    }
                    if (name.equals("credentials")) {
                        this.state = ParserState.PARSE_REQUEST_CREDENTIALS;
                        break;
                    }
                    throw new SAXException("Invalid request format.");
                }
                case PARSE_REQUEST_CREDENTIALS: {
                    if (name.equals("uid")) {
                        this.state = ParserState.PARSE_REQUEST_CREDENTIALS_UID;
                        break;
                    }
                    if (name.equals("password")) {
                        this.state = ParserState.PARSE_REQUEST_CREDENTIALS_PWD;
                        break;
                    }
                    if (name.equals("store")) {
                        this.state = ParserState.PARSE_REQUEST_CREDENTIALS_STORE;
                        break;
                    }
                    throw new SAXException("Invalid request format.");
                }
                default: {
                    throw new SAXException("Unhandled state: " + (Object)((Object)this.state));
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state != ParserState.PARSE_REQUEST_SERVICE) {
                if (this.state == ParserState.PARSE_REQUEST_SHARE_SESSION) {
                    this.shareSessionBuffer.append(new String(ch, start, length));
                } else if (this.state == ParserState.PARSE_REQUEST_CREDENTIALS_UID) {
                    this.userBuffer.append(new String(ch, start, length));
                } else if (this.state == ParserState.PARSE_REQUEST_CREDENTIALS_PWD) {
                    this.passwordBuffer.append(new String(ch, start, length));
                } else if (this.state == ParserState.PARSE_REQUEST_CREDENTIALS_STORE) {
                    this.credentialsStoreBuffer.append(new String(ch, start, length));
                }
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.state) {
                case PARSE_REQUEST_CREDENTIALS_UID: 
                case PARSE_REQUEST_CREDENTIALS_PWD: 
                case PARSE_REQUEST_CREDENTIALS_STORE: {
                    this.state = ParserState.PARSE_REQUEST_CREDENTIALS;
                    break;
                }
                case PARSE_REQUEST_SERVICE: 
                case PARSE_REQUEST_SHARE_SESSION: 
                case PARSE_REQUEST_CREDENTIALS: {
                    this.state = ParserState.PARSE_REQUEST;
                    break;
                }
                case PARSE_REQUEST: {
                    this.state = ParserState.DONE;
                    break;
                }
                default: {
                    throw new SAXException("Unhandled state: " + (Object)((Object)this.state));
                }
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.userBuffer.length() > 0) {
                this.authenticationRequest.setUserId(this.userBuffer.toString());
            }
            if (this.passwordBuffer.length() > 0) {
                this.authenticationRequest.setPassword(this.passwordBuffer.toString());
            }
            if (this.shareSessionBuffer.length() > 0) {
                this.authenticationRequest.setSharedSession(Boolean.parseBoolean(this.shareSessionBuffer.toString()));
            }
            if (this.credentialsStoreBuffer.length() > 0) {
                this.authenticationRequest.setStoreCredentials(Boolean.parseBoolean(this.credentialsStoreBuffer.toString()));
            }
        }

        private boolean parseBoolean(String value) {
            if (value.equals("0")) {
                return false;
            }
            if (value.equals("1")) {
                return true;
            }
            return Boolean.valueOf(value);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            INITIAL,
            PARSE_REQUEST,
            PARSE_REQUEST_SERVICE,
            PARSE_REQUEST_SHARE_SESSION,
            PARSE_REQUEST_CREDENTIALS,
            PARSE_REQUEST_CREDENTIALS_UID,
            PARSE_REQUEST_CREDENTIALS_PWD,
            PARSE_REQUEST_CREDENTIALS_STORE,
            DONE;

        }
    }
}

