/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.handlers;

import com.adobe.csi.auth.IAuthenticationService;
import com.adobe.csi.auth.StatusCode;
import com.adobe.csi.auth.StoreCredentialsRequest;
import com.adobe.csi.auth.StoreCredentialsResponse;
import com.adobe.csi.internal.auth.parsers.StoreCredentialsRequestParser;
import com.adobe.csi.internal.auth.parsers.StoreCredentialsResponseBuilder;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;

public class StoreCredentialsInvocationHandler
implements IExtensionInvocationHandler {
    private IAuthenticationService authenticationService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        StoreCredentialsResponse storeCredentialsResponse = null;
        StoreCredentialsRequest storeCredentialsRequest = null;
        try {
            storeCredentialsRequest = this.deserializeRequest(request);
            storeCredentialsRequest.setExtensionId(extensionId);
            storeCredentialsResponse = this.authenticationService.storeCredentials(storeCredentialsRequest);
            storeCredentialsResponse.setStatus(StatusCode.OK);
        }
        catch (IOException e) {
            storeCredentialsResponse = new StoreCredentialsResponse();
            storeCredentialsResponse.setStatus(StatusCode.ERROR);
            storeCredentialsResponse.setMessage(e.getMessage());
        }
        String result = null;
        try {
            result = this.serialize(storeCredentialsResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void bindAuthenticationService(IAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    protected void unbindAuthenticationService(IAuthenticationService authenticationService) {
        this.authenticationService = null;
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = null;
    }

    private StoreCredentialsRequest deserializeRequest(String request) throws IOException {
        StoreCredentialsRequest storeCredentialsRequest = null;
        StoreCredentialsRequestParser storeCredentialsRequestParser = new StoreCredentialsRequestParser(this.saxParserFactory);
        storeCredentialsRequest = storeCredentialsRequestParser.parse(new ByteArrayInputStream(request.getBytes("UTF-8")));
        return storeCredentialsRequest;
    }

    private String serialize(StoreCredentialsResponse storeCredentialsResponse) throws IOException {
        StoreCredentialsResponseBuilder builder = new StoreCredentialsResponseBuilder();
        return builder.build(storeCredentialsResponse);
    }
}

