/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.handlers;

import com.adobe.csi.auth.IAuthenticationService;
import com.adobe.csi.auth.RetrieveCredentialsRequest;
import com.adobe.csi.auth.RetrieveCredentialsResponse;
import com.adobe.csi.auth.StatusCode;
import com.adobe.csi.internal.auth.parsers.RetrieveCredentialsRequestParser;
import com.adobe.csi.internal.auth.parsers.RetrieveCredentialsResponseBuilder;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;

public class RetrieveCredentialsInvocationHandler
implements IExtensionInvocationHandler {
    private IAuthenticationService authenticationService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        RetrieveCredentialsResponse retrieveCredentialsResponse = null;
        RetrieveCredentialsRequest retrieveCredentialsRequest = null;
        try {
            retrieveCredentialsRequest = this.deserializeRequest(request);
            retrieveCredentialsRequest.setExtensionId(extensionId);
            retrieveCredentialsResponse = this.authenticationService.retrieveCredentials(retrieveCredentialsRequest);
            retrieveCredentialsResponse.setStatus(StatusCode.OK);
        }
        catch (IOException e) {
            retrieveCredentialsResponse = new RetrieveCredentialsResponse();
            retrieveCredentialsResponse.setStatus(StatusCode.ERROR);
            retrieveCredentialsResponse.setMessage(e.getMessage());
        }
        String result = null;
        try {
            result = this.serialize(retrieveCredentialsResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void bindAuthenticationService(IAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    protected void unbindAuthenticationService(IAuthenticationService authenticationService) {
        this.authenticationService = null;
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = null;
    }

    private RetrieveCredentialsRequest deserializeRequest(String request) throws IOException {
        RetrieveCredentialsRequest retrieveCredentialsRequest = null;
        RetrieveCredentialsRequestParser retrieveCredentialsRequestParser = new RetrieveCredentialsRequestParser(this.saxParserFactory);
        retrieveCredentialsRequest = retrieveCredentialsRequestParser.parse(new ByteArrayInputStream(request.getBytes("UTF-8")));
        return retrieveCredentialsRequest;
    }

    private String serialize(RetrieveCredentialsResponse retrieveCredentialsResponse) throws IOException {
        RetrieveCredentialsResponseBuilder builder = new RetrieveCredentialsResponseBuilder();
        return builder.build(retrieveCredentialsResponse);
    }
}

