/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.handlers;

import com.adobe.csi.auth.IAuthenticationService;
import com.adobe.csi.auth.LogoutRequest;
import com.adobe.csi.auth.LogoutResponse;
import com.adobe.csi.auth.StatusCode;
import com.adobe.csi.internal.auth.parsers.LogoutRequestParser;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LogoutInvocationHandler
implements IExtensionInvocationHandler {
    private IAuthenticationService authService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        LogoutRequest logoutReq = this.deserializeRequest(request);
        logoutReq.setExtensionId(extensionId);
        return logoutReq != null ? this.serializeResponse(this.authService.logout(logoutReq)) : null;
    }

    protected void bindAuthenticationService(IAuthenticationService authService) {
        if (this.authService == null) {
            this.authService = authService;
        }
    }

    protected void unbindAuthenticationService(IAuthenticationService authService) {
        if (this.authService == authService) {
            this.authService = null;
        }
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        if (this.saxParserFactory == null) {
            this.saxParserFactory = saxParserFactory;
        }
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        if (this.saxParserFactory == saxParserFactory) {
            this.saxParserFactory = null;
        }
    }

    private LogoutRequest deserializeRequest(String request) throws IOException {
        assert (request != null) : "request != null";
        LogoutRequestParser parser = new LogoutRequestParser(this.saxParserFactory);
        return parser.parse(request);
    }

    private String serializeResponse(LogoutResponse response) throws IOException {
        assert (response != null) : "response != null";
        StringWriter writer = new StringWriter();
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            hd.setResult(new StreamResult(writer));
            hd.startDocument();
            AttributesImpl attributes = new AttributesImpl();
            StatusCode statusCode = response.getStatusCode();
            attributes.addAttribute("", "", "status", "CDATA", statusCode.getStatus());
            hd.startElement("", "", "logoutResponse", attributes);
            attributes.clear();
            hd.endElement("", "", "logoutResponse");
            hd.endDocument();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return writer.toString();
    }
}

