/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.handlers;

import com.adobe.csi.auth.DeleteCredentialsRequest;
import com.adobe.csi.auth.DeleteCredentialsResponse;
import com.adobe.csi.auth.IAuthenticationService;
import com.adobe.csi.auth.StatusCode;
import com.adobe.csi.internal.auth.parsers.DeleteCredentialsRequestParser;
import com.adobe.csi.internal.auth.parsers.DeleteCredentialsResponseBuilder;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;

public class DeleteCredentialsInvocationHandler
implements IExtensionInvocationHandler {
    private IAuthenticationService authenticationService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        DeleteCredentialsResponse deleteCredentialsResponse = null;
        DeleteCredentialsRequest deleteCredentialsRequest = null;
        try {
            deleteCredentialsRequest = this.deserializeRequest(request);
            deleteCredentialsRequest.setExtensionId(extensionId);
            deleteCredentialsResponse = this.authenticationService.deleteCredentials(deleteCredentialsRequest);
            deleteCredentialsResponse.setStatus(StatusCode.OK);
        }
        catch (IOException e) {
            deleteCredentialsResponse = new DeleteCredentialsResponse();
            deleteCredentialsResponse.setStatus(StatusCode.ERROR);
            deleteCredentialsResponse.setMessage(e.getMessage());
        }
        String result = null;
        try {
            result = this.serialize(deleteCredentialsResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void bindAuthenticationService(IAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    protected void unbindAuthenticationService(IAuthenticationService authenticationService) {
        this.authenticationService = null;
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = null;
    }

    private DeleteCredentialsRequest deserializeRequest(String request) throws IOException {
        DeleteCredentialsRequest deleteCredentialsRequest = null;
        DeleteCredentialsRequestParser deleteCredentialsRequestParser = new DeleteCredentialsRequestParser(this.saxParserFactory);
        deleteCredentialsRequest = deleteCredentialsRequestParser.parse(new ByteArrayInputStream(request.getBytes("UTF-8")));
        return deleteCredentialsRequest;
    }

    private String serialize(DeleteCredentialsResponse deleteCredentialsResponse) throws IOException {
        DeleteCredentialsResponseBuilder builder = new DeleteCredentialsResponseBuilder();
        return builder.build(deleteCredentialsResponse);
    }
}

