/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.auth.handlers;

import com.adobe.csi.auth.AuthenticationRequest;
import com.adobe.csi.auth.AuthenticationResponse;
import com.adobe.csi.auth.AuthenticationToken;
import com.adobe.csi.auth.IAuthenticationService;
import com.adobe.csi.auth.StatusCode;
import com.adobe.csi.internal.auth.parsers.AuthenticationRequestParser;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AuthenticationInvocationHandler
implements IExtensionInvocationHandler {
    private IAuthenticationService authService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        AuthenticationRequest authReq = this.deserializeRequest(request);
        authReq.setExtensionId(extensionId);
        return authReq != null ? this.serializeResponse(this.authService.authenticate(authReq)) : null;
    }

    protected void bindAuthenticationService(IAuthenticationService authService) {
        if (this.authService == null) {
            this.authService = authService;
        }
    }

    protected void unbindAuthenticationService(IAuthenticationService authService) {
        if (this.authService == authService) {
            this.authService = null;
        }
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        if (this.saxParserFactory == null) {
            this.saxParserFactory = saxParserFactory;
        }
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        if (this.saxParserFactory == saxParserFactory) {
            this.saxParserFactory = null;
        }
    }

    private AuthenticationRequest deserializeRequest(String request) throws IOException {
        assert (request != null) : "request != null";
        AuthenticationRequestParser parser = new AuthenticationRequestParser(this.saxParserFactory);
        return parser.parse(request);
    }

    private String serializeResponse(AuthenticationResponse response) throws IOException {
        assert (response != null) : "response != null";
        StringWriter writer = new StringWriter();
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            hd.setResult(new StreamResult(writer));
            hd.startDocument();
            AttributesImpl attributes = new AttributesImpl();
            StatusCode statusCode = response.getStatusCode();
            attributes.addAttribute("", "", "status", "CDATA", statusCode.getStatus());
            hd.startElement("", "", "authenticationResponse", attributes);
            attributes.clear();
            if (statusCode != StatusCode.OK) {
                String statusMessage = statusCode.getMessage();
                if (statusMessage != null) {
                    hd.startElement("", "", "message", attributes);
                    char[] charArray = statusMessage.toCharArray();
                    hd.characters(charArray, 0, charArray.length);
                    hd.endElement("", "", "message");
                }
            } else {
                AuthenticationToken token = response.getAuthenticationToken();
                hd.startElement("", "", "authtoken", attributes);
                Map<String, String> tokenAttributes = token.getAttributes();
                for (Map.Entry<String, String> entry : tokenAttributes.entrySet()) {
                    attributes.addAttribute("", "", entry.getKey(), "CDATA", entry.getValue());
                }
                hd.startElement("", "", token.getType(), attributes);
                hd.endElement("", "", token.getType());
                hd.endElement("", "", "authtoken");
                attributes.clear();
                hd.startElement("", "", "credentials", attributes);
                hd.startElement("", "", "uid", attributes);
                String uid = response.getUserId();
                hd.characters(uid.toCharArray(), 0, uid.length());
                hd.endElement("", "", "uid");
                hd.startElement("", "", "password", attributes);
                String pw = response.getPassword();
                hd.characters(pw.toCharArray(), 0, pw.length());
                hd.endElement("", "", "password");
                hd.startElement("", "", "store", attributes);
                String store = Boolean.toString(response.isStore());
                hd.characters(store.toCharArray(), 0, store.length());
                hd.endElement("", "", "store");
                hd.endElement("", "", "credentials");
            }
            hd.endElement("", "", "authenticationResponse");
            hd.endDocument();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return writer.toString();
    }
}

